/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.glacier.v2;

import rice.p2p.commonapi.IdRange;

public class GlacierStatistics {
    public int[] messagesSentByTag;
    public int pendingRequests;
    public int numNeighbors;
    public int numFragments;
    public int numContinuations;
    public int numObjectsInTrash;
    public int activeFetches;
    public IdRange responsibleRange;
    public long fragmentStorageSize;
    public long trashStorageSize;
    public long tbegin;
    public long bucketMin;
    public long bucketMax;
    public long bucketConsumed;
    public long bucketTokensPerSecond;
    public long bucketMaxBurstSize;

    public GlacierStatistics(int numTags) {
        this.messagesSentByTag = new int[numTags];
        this.pendingRequests = 0;
        this.numNeighbors = 0;
        this.numFragments = 0;
        this.numContinuations = 0;
        this.numObjectsInTrash = 0;
        this.fragmentStorageSize = 0L;
        this.trashStorageSize = 0L;
        this.activeFetches = 0;
        this.tbegin = System.currentTimeMillis();
        this.bucketMin = 0L;
        this.bucketMax = 0L;
        this.bucketConsumed = 0L;
    }

    public void dump() {
        System.out.println("@L.ME free=" + Runtime.getRuntime().freeMemory() + " max=" + Runtime.getRuntime().maxMemory() + " total=" + Runtime.getRuntime().totalMemory());
        System.out.println("@L.GL interval=" + this.tbegin + "-" + System.currentTimeMillis() + " range=" + this.responsibleRange);
        System.out.println("@L.GL   neighbors=" + this.numNeighbors + " fragments=" + this.numFragments + " trash=" + this.numObjectsInTrash);
        System.out.println("@L.GL   continuations=" + this.numContinuations + " pending=" + this.pendingRequests);
        System.out.println("@L.GL   fragSizeBytes=" + this.fragmentStorageSize + " trashSizeBytes=" + this.trashStorageSize);
        System.out.println("@L.GL   activeFetches=" + this.activeFetches + " bucketMin=" + this.bucketMin + " bucketMax=" + this.bucketMax);
        System.out.println("@L.GL   bucketConsumed=" + this.bucketConsumed);
        System.out.print("@L.GL   byTag=");
        for (int i = 0; i < this.messagesSentByTag.length; ++i) {
            System.out.print(this.messagesSentByTag[i] + " ");
        }
        System.out.println();
    }
}

