/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.glacier.v2.messaging;

import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.glacier.v2.messaging.GlacierMessage;

public class GlacierNeighborResponseMessage
extends GlacierMessage {
    protected Id[] neighbors;
    protected long[] lastSeen;

    public GlacierNeighborResponseMessage(int uid, Id[] neighbors, long[] lastSeen, NodeHandle source, Id dest, char tag) {
        super(uid, source, dest, true, tag);
        this.neighbors = neighbors;
        this.lastSeen = lastSeen;
    }

    public Id getNeighbor(int index) {
        return this.neighbors[index];
    }

    public long getLastSeen(int index) {
        return this.lastSeen[index];
    }

    public int numNeighbors() {
        if (this.neighbors == null || this.lastSeen == null) {
            return 0;
        }
        if (this.lastSeen.length < this.neighbors.length) {
            return this.lastSeen.length;
        }
        return this.neighbors.length;
    }

    public String toString() {
        return "[GlacierNeighborResponse with " + this.numNeighbors() + " keys]";
    }
}

