/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.multiring;

import rice.Continuation;
import rice.Executable;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.CancellableTask;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.NodeHandleSet;
import rice.p2p.multiring.MultiringIdRange;
import rice.p2p.multiring.MultiringNode;
import rice.p2p.multiring.MultiringNodeHandle;
import rice.p2p.multiring.MultiringNodeHandleSet;
import rice.p2p.multiring.RingId;

public class MultiringEndpoint
implements Endpoint {
    protected MultiringNode node;
    protected Application application;
    protected Endpoint endpoint;

    protected MultiringEndpoint(MultiringNode node, Endpoint endpoint, Application application) {
        this.node = node;
        this.endpoint = endpoint;
        this.application = application;
    }

    public Id getId() {
        return RingId.build(this.node.getRingId(), this.endpoint.getId());
    }

    public NodeHandle getLocalNodeHandle() {
        return new MultiringNodeHandle(this.node.getRingId(), this.endpoint.getLocalNodeHandle());
    }

    public String getInstance() {
        return "multiring" + this.endpoint.getInstance();
    }

    public void route(Id id, Message message, NodeHandle hint) {
        RingId mId = (RingId)id;
        MultiringNodeHandle mHint = (MultiringNodeHandle)hint;
        if (mId == null) {
            if (mHint.getRingId().equals(this.node.getRingId())) {
                this.endpoint.route(null, message, mHint.getHandle());
            } else {
                this.route(mHint.getId(), message, null);
            }
        } else if (mId.getRingId().equals(this.node.getRingId())) {
            if (mHint != null && mHint.getRingId().equals(this.node.getRingId())) {
                this.endpoint.route(mId.getId(), message, mHint.getHandle());
            } else {
                this.endpoint.route(mId.getId(), message, null);
            }
        } else {
            this.node.getCollection().route(mId, message, this.getInstance());
        }
    }

    public NodeHandleSet localLookup(Id id, int num, boolean safe) {
        return new MultiringNodeHandleSet(this.node.getRingId(), this.endpoint.localLookup(((RingId)id).getId(), num, safe));
    }

    public NodeHandleSet neighborSet(int num) {
        return new MultiringNodeHandleSet(this.node.getRingId(), this.endpoint.neighborSet(num));
    }

    public NodeHandleSet replicaSet(Id id, int maxRank) {
        if (((RingId)id).getRingId().equals(this.node.getRingId())) {
            return new MultiringNodeHandleSet(this.node.getRingId(), this.endpoint.replicaSet(((RingId)id).getId(), maxRank));
        }
        return new MultiringNodeHandleSet(((RingId)id).getRingId(), this.node.getNode().getIdFactory().buildNodeHandleSet());
    }

    public NodeHandleSet replicaSet(Id id, int maxRank, NodeHandle root, NodeHandleSet set) {
        if (((RingId)id).getRingId().equals(this.node.getRingId())) {
            return new MultiringNodeHandleSet(this.node.getRingId(), this.endpoint.replicaSet(((RingId)id).getId(), maxRank, ((MultiringNodeHandle)root).getHandle(), ((MultiringNodeHandleSet)set).getSet()));
        }
        return new MultiringNodeHandleSet(((RingId)id).getRingId(), this.node.getNode().getIdFactory().buildNodeHandleSet());
    }

    public IdRange range(NodeHandle handle, int rank, Id lkey) {
        IdRange result;
        if (lkey != null) {
            lkey = ((RingId)lkey).getId();
        }
        if ((result = this.endpoint.range(((MultiringNodeHandle)handle).getHandle(), rank, lkey)) != null) {
            return new MultiringIdRange(this.node.getRingId(), result);
        }
        return null;
    }

    public IdRange range(NodeHandle handle, int rank, Id lkey, boolean cumulative) {
        IdRange result;
        if (lkey != null) {
            lkey = ((RingId)lkey).getId();
        }
        if ((result = this.endpoint.range(((MultiringNodeHandle)handle).getHandle(), rank, lkey, cumulative)) != null) {
            return new MultiringIdRange(this.node.getRingId(), result);
        }
        return null;
    }

    public CancellableTask scheduleMessage(Message message, long delay) {
        return this.endpoint.scheduleMessage(message, delay);
    }

    public CancellableTask scheduleMessage(Message message, long delay, long period) {
        return this.endpoint.scheduleMessage(message, delay, period);
    }

    public void process(Executable task, Continuation command) {
        this.endpoint.process(task, command);
    }

    protected void deliver(RingId id, Message target) {
        this.application.deliver(id, target);
    }
}

