/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.multiring;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.IdSet;
import rice.p2p.commonapi.NodeHandleSet;
import rice.p2p.multiring.MultiringIdRange;
import rice.p2p.multiring.MultiringIdSet;
import rice.p2p.multiring.MultiringNodeHandleSet;
import rice.p2p.multiring.RingId;

public class MultiringIdFactory
implements IdFactory {
    protected Id ringId;
    protected IdFactory factory;

    public MultiringIdFactory(Id ringId, IdFactory factory) {
        this.ringId = ringId;
        this.factory = factory;
    }

    public Id getRingId() {
        return this.ringId;
    }

    public int getIdToStringLength() {
        return 4 + 2 * this.factory.getIdToStringLength();
    }

    public RingId buildRingId(Id ringId, byte[] material) {
        return RingId.build(ringId, this.factory.buildId(material));
    }

    public RingId buildRingId(Id ringId, Id id) {
        return RingId.build(ringId, id);
    }

    public Id buildNormalId(byte[] material) {
        return this.factory.buildId(material);
    }

    public Id buildNormalId(String material) {
        return this.factory.buildId(material);
    }

    public Id buildId(byte[] material) {
        return RingId.build(this.getRingId(), this.factory.buildId(material));
    }

    public Id buildId(int[] material) {
        return RingId.build(this.getRingId(), this.factory.buildId(material));
    }

    public Id buildId(String string) {
        return RingId.build(this.getRingId(), this.factory.buildId(string));
    }

    public Id buildRandomId(Random rng) {
        return RingId.build(this.getRingId(), this.factory.buildRandomId(rng));
    }

    public Id buildIdFromToString(String string) {
        string = string.substring(1);
        Id ring = this.factory.buildIdFromToString(string.substring(0, string.indexOf(",")));
        string = string.substring(string.indexOf(", ") + 2);
        Id normal = this.factory.buildIdFromToString(string.substring(0, string.length() - 1));
        return RingId.build(ring, normal);
    }

    public Id buildIdFromToString(char[] chars, int offset, int length) {
        Id ring = this.factory.buildIdFromToString(chars, 1, MultiringIdFactory.find(chars, ',') - 1);
        Id normal = this.factory.buildIdFromToString(chars, 2 + MultiringIdFactory.find(chars, ','), MultiringIdFactory.find(chars, ')') - (2 + MultiringIdFactory.find(chars, ',')));
        return RingId.build(ring, normal);
    }

    public IdRange buildIdRangeFromPrefix(String string) {
        if (string.indexOf(", ") < 0) {
            return new MultiringIdRange(this.ringId, this.factory.buildIdRangeFromPrefix(string));
        }
        string = string.substring(1);
        Id ring = this.factory.buildIdFromToString(string.substring(0, string.indexOf(", ")));
        string = string.substring(string.indexOf(", ") + 2);
        IdRange range = this.factory.buildIdRangeFromPrefix(string);
        return new MultiringIdRange(ring, range);
    }

    public Id.Distance buildIdDistance(byte[] material) {
        return this.factory.buildIdDistance(material);
    }

    public IdRange buildIdRange(Id cw, Id ccw) {
        return new MultiringIdRange(this.getRingId(), this.factory.buildIdRange(((RingId)cw).getId(), ((RingId)ccw).getId()));
    }

    public IdSet buildIdSet() {
        return new MultiringIdSet(this.getRingId(), this.factory.buildIdSet());
    }

    public IdSet buildIdSet(SortedMap map) {
        return new MultiringIdSet(this.getRingId(), this.factory.buildIdSet(new MultiringSortedMap(map)));
    }

    public NodeHandleSet buildNodeHandleSet() {
        return new MultiringNodeHandleSet(this.getRingId(), this.factory.buildNodeHandleSet());
    }

    protected static int find(char[] chars, char value) {
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != value) continue;
            return i;
        }
        return chars.length;
    }

    protected class MultiringMapEntry
    implements Map.Entry {
        protected Map.Entry entry;

        public MultiringMapEntry(Map.Entry entry) {
            this.entry = entry;
        }

        public Object getKey() {
            return ((RingId)this.entry.getKey()).getId();
        }

        public Object getValue() {
            return this.entry.getValue();
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException("setValue not supported!");
        }

        public boolean equals(Object o) {
            throw new UnsupportedOperationException("equals not supported!");
        }

        public int hashCode() {
            throw new UnsupportedOperationException("hashCode not supported!");
        }
    }

    protected class MultiringKeySet
    implements Set {
        protected Set set;

        public MultiringKeySet(Set set) {
            this.set = set;
        }

        public boolean isEmpty() {
            throw new UnsupportedOperationException("isEmpty not supported!");
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException("add not supported!");
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException("addAll not supported!");
        }

        public void clear() {
            throw new UnsupportedOperationException("clear not supported!");
        }

        public boolean contains(Object o) {
            throw new UnsupportedOperationException("contains not supported!");
        }

        public boolean containsAll(Collection c) {
            throw new UnsupportedOperationException("containsAll not supported!");
        }

        public boolean equals(Object o) {
            throw new UnsupportedOperationException("equals not supported!");
        }

        public int hashCode() {
            throw new UnsupportedOperationException("hashCode not supported!");
        }

        public Iterator iterator() {
            return new Iterator(this){
                protected Iterator i;
                private final /* synthetic */ MultiringKeySet this$1;
                {
                    this.this$1 = this$1;
                    this.i = this.this$1.set.iterator();
                }

                public boolean hasNext() {
                    return this.i.hasNext();
                }

                public Object next() {
                    return ((RingId)this.i.next()).getId();
                }

                public void remove() {
                    this.i.remove();
                }
            };
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException("remove not supported!");
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException("removeAll not supported!");
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException("retainAll not supported!");
        }

        public int size() {
            throw new UnsupportedOperationException("size not supported!");
        }

        public Object[] toArray() {
            Object[] result = new Object[this.set.size()];
            Iterator i = this.set.iterator();
            int j = 0;
            while (i.hasNext()) {
                result[j++] = ((RingId)i.next()).getId();
            }
            return result;
        }

        public Object[] toArray(Object[] a) {
            Object[] result = (Object[])Array.newInstance(a.getClass().getComponentType(), this.set.size());
            Iterator i = this.set.iterator();
            int j = 0;
            while (i.hasNext()) {
                result[j++] = ((RingId)i.next()).getId();
            }
            return result;
        }
    }

    protected class MultiringEntrySet
    implements Set {
        protected Set set;

        public MultiringEntrySet(Set set) {
            this.set = set;
        }

        public boolean isEmpty() {
            throw new UnsupportedOperationException("isEmpty not supported!");
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException("add not supported!");
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException("addAll not supported!");
        }

        public void clear() {
            throw new UnsupportedOperationException("clear not supported!");
        }

        public boolean contains(Object o) {
            throw new UnsupportedOperationException("contains not supported!");
        }

        public boolean containsAll(Collection c) {
            throw new UnsupportedOperationException("containsAll not supported!");
        }

        public boolean equals(Object o) {
            throw new UnsupportedOperationException("equals not supported!");
        }

        public int hashCode() {
            throw new UnsupportedOperationException("hashCode not supported!");
        }

        public Iterator iterator() {
            return new Iterator(this){
                protected Iterator i;
                private final /* synthetic */ MultiringEntrySet this$1;
                {
                    this.this$1 = this$1;
                    this.i = this.this$1.set.iterator();
                }

                public boolean hasNext() {
                    return this.i.hasNext();
                }

                public Object next() {
                    return MultiringEntrySet.access$000(this.this$1).new MultiringMapEntry((Map.Entry)this.i.next());
                }

                public void remove() {
                    this.i.remove();
                }
            };
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException("remove not supported!");
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException("removeAll not supported!");
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException("retainAll not supported!");
        }

        public int size() {
            throw new UnsupportedOperationException("size not supported!");
        }

        public Object[] toArray() {
            throw new UnsupportedOperationException("toArray not supported!");
        }

        public Object[] toArray(Object[] a) {
            throw new UnsupportedOperationException("toArray not supported!");
        }

        static /* synthetic */ MultiringIdFactory access$000(MultiringEntrySet x0) {
            return x0.MultiringIdFactory.this;
        }
    }

    protected class MultiringSortedMap
    implements SortedMap {
        protected SortedMap map;

        public MultiringSortedMap(SortedMap map) {
            this.map = map;
        }

        public Object get(Object key) {
            throw new UnsupportedOperationException("get not supported!");
        }

        public boolean isEmpty() {
            throw new UnsupportedOperationException("isEmpty not supported!");
        }

        public Comparator comparator() {
            return null;
        }

        public Object firstKey() {
            return this.map.firstKey() == null ? null : ((RingId)this.map.firstKey()).getId();
        }

        public SortedMap headMap(Object toKey) {
            return this.map.headMap(RingId.build(MultiringIdFactory.this.ringId, (Id)toKey));
        }

        public Object lastKey() {
            return this.map.lastKey() == null ? null : ((RingId)this.map.lastKey()).getId();
        }

        public SortedMap subMap(Object fromKey, Object toKey) {
            return this.map.subMap(RingId.build(MultiringIdFactory.this.ringId, (Id)fromKey), RingId.build(MultiringIdFactory.this.ringId, (Id)toKey));
        }

        public SortedMap tailMap(Object fromKey) {
            return this.map.tailMap(RingId.build(MultiringIdFactory.this.ringId, (Id)fromKey));
        }

        public void clear() {
            throw new UnsupportedOperationException("clear not supported!");
        }

        public boolean containsKey(Object key) {
            return this.map.containsKey(RingId.build(MultiringIdFactory.this.ringId, (Id)key));
        }

        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException("containsValue not supported!");
        }

        public Set entrySet() {
            return new MultiringEntrySet(this.map.entrySet());
        }

        public boolean equals(Object o) {
            throw new UnsupportedOperationException("equals not supported!");
        }

        public int hashCode() {
            throw new UnsupportedOperationException("hashCode not supported!");
        }

        public Set keySet() {
            return new MultiringKeySet(this.map.keySet());
        }

        public Object put(Object key, Object value) {
            return this.map.put(RingId.build(MultiringIdFactory.this.ringId, (Id)key), value);
        }

        public void putAll(Map t) {
            throw new UnsupportedOperationException("putAll not supported!");
        }

        public Object remove(Object key) {
            return this.map.remove(RingId.build(MultiringIdFactory.this.ringId, (Id)key));
        }

        public int size() {
            return this.map.size();
        }

        public Collection values() {
            throw new UnsupportedOperationException("values not supported!");
        }
    }
}

