/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.multiring;

import java.util.NoSuchElementException;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.NodeHandleSet;
import rice.p2p.multiring.MultiringNodeHandle;
import rice.p2p.multiring.RingId;

public class MultiringNodeHandleSet
implements NodeHandleSet {
    protected NodeHandleSet set;
    protected Id ringId;

    protected MultiringNodeHandleSet(Id ringId, NodeHandleSet set) {
        this.ringId = ringId;
        this.set = set;
        if (ringId instanceof RingId || set instanceof MultiringNodeHandleSet) {
            throw new IllegalArgumentException("Illegal creation of MRNodeHandleSet: " + ringId.getClass() + ", " + set.getClass());
        }
    }

    protected NodeHandleSet getSet() {
        return this.set;
    }

    public NodeHandle getHandle(Id id) {
        NodeHandle handle = this.set.getHandle(((RingId)id).getId());
        if (handle != null) {
            return new MultiringNodeHandle(this.ringId, handle);
        }
        return null;
    }

    public NodeHandle getHandle(int i) {
        NodeHandle handle = this.set.getHandle(i);
        if (handle != null) {
            return new MultiringNodeHandle(this.ringId, handle);
        }
        return null;
    }

    public int getIndexHandle(Id id) throws NoSuchElementException {
        return this.set.getIndexHandle(((RingId)id).getId());
    }

    public boolean putHandle(NodeHandle handle) {
        return this.set.putHandle(((MultiringNodeHandle)handle).getHandle());
    }

    public boolean memberHandle(Id id) {
        return this.set.memberHandle(((RingId)id).getId());
    }

    public NodeHandle removeHandle(Id id) {
        NodeHandle handle = this.set.removeHandle(((RingId)id).getId());
        if (handle != null) {
            return new MultiringNodeHandle(this.ringId, handle);
        }
        return null;
    }

    public int size() {
        return this.set.size();
    }

    public boolean equals(Object o) {
        MultiringNodeHandleSet other = (MultiringNodeHandleSet)o;
        return other.getSet().equals(this.set) && other.ringId.equals(this.ringId);
    }

    public int hashCode() {
        return this.set.hashCode() + this.ringId.hashCode();
    }

    public String toString() {
        return "{RingId " + this.ringId + " " + this.set.toString() + "}";
    }
}

