/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.multiring.testing;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Random;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.RouteMessage;
import rice.p2p.multiring.MultiringNode;
import rice.pastry.NodeId;
import rice.pastry.PastryNodeFactory;
import rice.pastry.commonapi.PastryIdFactory;
import rice.pastry.direct.DirectPastryNode;
import rice.pastry.direct.DirectPastryNodeFactory;
import rice.pastry.direct.EuclideanNetwork;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.direct.SphereNetwork;
import rice.pastry.dist.DistNodeHandle;
import rice.pastry.dist.DistPastryNode;
import rice.pastry.dist.DistPastryNodeFactory;
import rice.pastry.standard.RandomNodeIdFactory;

public class MultiringRegrTest {
    protected MultiringNode[] globalNodes;
    protected MultiringNode[][] organizationalNodes;
    protected MultiringTestApp[] globalApps;
    protected MultiringTestApp[][] organizationalApps;
    protected Id globalRingId;
    protected Id[] ringIds;
    protected Random rng;
    protected PastryNodeFactory factory;
    protected IdFactory idFactory;
    protected NetworkSimulator simulator = SIMULATOR == -1 ? new SphereNetwork() : new EuclideanNetwork();
    public static int NUM_GLOBAL_NODES = 20;
    public static int NUM_ORGANIZATIONS = 5;
    public static int NUM_INTERNAL_NODES = 3;
    public static int NUM_GATEWAY_NODES = NUM_GLOBAL_NODES / NUM_ORGANIZATIONS;
    public static int NUM_ORGANIZATIONAL_NODES = NUM_GATEWAY_NODES + NUM_INTERNAL_NODES;
    public static IdFactory FACTORY = new PastryIdFactory();
    public static final String SUCCESS = "SUCCESS";
    public static final String FAILURE = "FAILURE";
    protected static final int PAD_SIZE = 60;
    public static final int PROTOCOL_DIRECT = -138;
    public static final int SIMULATOR_SPHERE = -1;
    public static final int SIMULATOR_EUCLIDEAN = -2;
    public static int PORT = 5009;
    public static String BOOTSTRAP_HOST = "localhost";
    public static int BOOTSTRAP_PORT = 5009;
    public static int PROTOCOL = DistPastryNodeFactory.PROTOCOL_DEFAULT;
    public static int SIMULATOR = -1;
    public static String INSTANCE_NAME = "MultiringRegrTest";

    public MultiringRegrTest() {
        this.factory = PROTOCOL == -138 ? new DirectPastryNodeFactory(new RandomNodeIdFactory(), this.simulator) : DistPastryNodeFactory.getFactory(new RandomNodeIdFactory(), PROTOCOL, PORT);
        NUM_GATEWAY_NODES = NUM_GLOBAL_NODES / NUM_ORGANIZATIONS;
        NUM_ORGANIZATIONAL_NODES = NUM_GATEWAY_NODES + NUM_INTERNAL_NODES;
        this.rng = new Random();
        this.idFactory = new PastryIdFactory();
        this.globalRingId = this.idFactory.buildId(new byte[20]);
        this.ringIds = new Id[NUM_ORGANIZATIONS];
        this.globalNodes = new MultiringNode[NUM_GLOBAL_NODES];
        this.organizationalNodes = new MultiringNode[NUM_ORGANIZATIONS][NUM_ORGANIZATIONAL_NODES];
        this.globalApps = new MultiringTestApp[NUM_GLOBAL_NODES];
        this.organizationalApps = new MultiringTestApp[NUM_ORGANIZATIONS][NUM_ORGANIZATIONAL_NODES];
    }

    protected rice.pastry.NodeHandle getBootstrap(Node bootstrap) {
        if (PROTOCOL == -138) {
            return ((DirectPastryNode)bootstrap).getLocalHandle();
        }
        InetSocketAddress address = new InetSocketAddress(BOOTSTRAP_HOST, BOOTSTRAP_PORT);
        return ((DistPastryNodeFactory)this.factory).getNodeHandle(((DistNodeHandle)((DistPastryNode)bootstrap).getLocalHandle()).getAddress());
    }

    public void createNodes() {
        int i;
        for (i = 0; i < NUM_GLOBAL_NODES; ++i) {
            this.globalNodes[i] = this.createNode(this.globalRingId, this.globalNodes[0]);
            this.simulate();
            this.globalApps[i] = new MultiringTestApp(this.globalNodes[i]);
            this.simulate();
            System.out.println("Created node " + i + " in the global ring with id " + this.globalNodes[i].getId());
        }
        for (i = 0; i < NUM_ORGANIZATIONS; ++i) {
            int j;
            this.ringIds[i] = this.generateId(16 * (i + 1));
            for (j = 0; j < NUM_GATEWAY_NODES; ++j) {
                this.organizationalNodes[i][j] = this.createNode(this.globalNodes[i * NUM_GATEWAY_NODES + j], this.ringIds[i], this.organizationalNodes[i][0]);
                this.simulate();
                this.organizationalApps[i][j] = new MultiringTestApp(this.organizationalNodes[i][j]);
                this.simulate();
                System.out.println("Created gateway node " + j + " in ring " + this.ringIds[i] + " with id " + this.organizationalNodes[i][j].getId());
            }
            for (j = NUM_GATEWAY_NODES; j < NUM_ORGANIZATIONAL_NODES; ++j) {
                this.organizationalNodes[i][j] = this.createNode(this.ringIds[i], this.organizationalNodes[i][0]);
                this.simulate();
                this.organizationalApps[i][j] = new MultiringTestApp(this.organizationalNodes[i][j]);
                this.simulate();
                System.out.println("Created internal node " + (j - NUM_GATEWAY_NODES) + " in ring " + this.ringIds[i] + " with id " + this.organizationalNodes[i][j].getId());
            }
        }
    }

    public void start() {
        this.createNodes();
        System.out.println("\nTest Beginning\n");
        this.runTest();
    }

    protected void simulate() {
        if (PROTOCOL == -138) {
            while (this.simulator.simulate()) {
            }
        } else {
            this.pause(500);
        }
    }

    protected MultiringNode createNode(Id ringId, MultiringNode bootstrap) {
        if (bootstrap == null) {
            return new MultiringNode(ringId, this.factory.newNode(null));
        }
        return new MultiringNode(ringId, this.factory.newNode(this.getBootstrap(bootstrap.getNode())));
    }

    protected MultiringNode createNode(MultiringNode existing, Id ringId, MultiringNode bootstrap) {
        if (existing == null) {
            throw new IllegalArgumentException("EXISTING WAS NULL! " + ringId + " " + bootstrap);
        }
        if (bootstrap == null) {
            return new MultiringNode(ringId, this.factory.newNode(null, (NodeId)existing.getNodeId()), existing);
        }
        return new MultiringNode(ringId, this.factory.newNode(this.getBootstrap(bootstrap.getNode()), (NodeId)existing.getNodeId()), existing);
    }

    protected synchronized void pause(int ms) {
        if (PROTOCOL != -138) {
            try {
                this.wait(ms);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void kill(int n) {
    }

    private Id generateId() {
        byte[] data = new byte[20];
        this.rng.nextBytes(data);
        return this.idFactory.buildId(data);
    }

    private Id generateId(int i) {
        byte[] data = new byte[20];
        data[data.length - 1] = 2;
        data[data.length - 2] = (byte)i;
        return this.idFactory.buildId(data);
    }

    protected void runTest() {
        for (int i = 0; i < 20; ++i) {
            int si = this.rng.nextInt(NUM_ORGANIZATIONS);
            int sj = this.rng.nextInt(NUM_ORGANIZATIONAL_NODES);
            int di = this.rng.nextInt(NUM_ORGANIZATIONS);
            int dj = this.rng.nextInt(NUM_ORGANIZATIONAL_NODES);
            MultiringTestApp sourceApp = this.organizationalApps[si][sj];
            Id source = this.organizationalNodes[si][sj].getId();
            Id dest = this.organizationalNodes[di][dj].getId();
            System.out.println("SENDING FROM " + source + " TO " + dest);
            sourceApp.send(dest);
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected final void sectionStart(String name) {
        System.out.println(name);
    }

    protected final void sectionDone() {
        System.out.println();
    }

    protected final void stepStart(String name) {
        System.out.print(this.pad("  " + name));
    }

    protected final void stepDone() {
        this.stepDone(SUCCESS);
    }

    protected final void stepDone(String status) {
        this.stepDone(status, "");
    }

    protected final void stepDone(String status, String message) {
        System.out.println("[" + status + "]");
        if (message != null && !message.equals("")) {
            System.out.println("     " + message);
        }
        if (status.equals(FAILURE)) {
            System.exit(0);
        }
    }

    protected final void stepException(Exception e) {
        System.out.println("\nException " + e + " occurred during testing.");
        e.printStackTrace();
        System.exit(0);
    }

    private final String pad(String start) {
        if (start.length() >= 60) {
            return start.substring(0, 60);
        }
        int spaceLength = 60 - start.length();
        char[] spaces = new char[spaceLength];
        Arrays.fill(spaces, '.');
        return start.concat(new String(spaces));
    }

    protected final void assertTrue(String intention, boolean test) {
        if (!test) {
            this.stepDone(FAILURE, "Assertion '" + intention + "' failed.");
        }
    }

    protected final void assertEquals(String description, Object expected, Object actual) {
        if (!expected.equals(actual)) {
            this.stepDone(FAILURE, "Assertion '" + description + "' failed, expected: '" + expected + "' got: " + actual + "'");
        }
    }

    protected static void parseArgs(String[] args) {
        int p;
        int i;
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-help")) continue;
            System.out.println("Usage: DistCommonAPITest [-port p] [-protocol (rmi|wire)] [-bootstrap host[:port]] [-help]");
            System.exit(1);
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-globalNodes") || i + 1 >= args.length) continue;
            p = Integer.parseInt(args[i + 1]);
            if (p <= 0) break;
            NUM_GLOBAL_NODES = p;
            break;
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-organizations") || i + 1 >= args.length) continue;
            p = Integer.parseInt(args[i + 1]);
            if (p <= 0) break;
            NUM_ORGANIZATIONS = p;
            break;
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-internalNodes") || i + 1 >= args.length) continue;
            p = Integer.parseInt(args[i + 1]);
            if (p <= 0) break;
            NUM_INTERNAL_NODES = p;
            break;
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-port") || i + 1 >= args.length) continue;
            p = Integer.parseInt(args[i + 1]);
            if (p <= 0) break;
            PORT = p;
            break;
        }
        BOOTSTRAP_PORT = PORT;
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-bootstrap") || i + 1 >= args.length) continue;
            String str = args[i + 1];
            int index = str.indexOf(58);
            if (index == -1) {
                BOOTSTRAP_HOST = str;
                BOOTSTRAP_PORT = PORT;
                break;
            }
            BOOTSTRAP_HOST = str.substring(0, index);
            BOOTSTRAP_PORT = Integer.parseInt(str.substring(index + 1));
            if (BOOTSTRAP_PORT > 0) break;
            BOOTSTRAP_PORT = PORT;
            break;
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-protocol") || i + 1 >= args.length) continue;
            String s = args[i + 1];
            if (s.equalsIgnoreCase("socket")) {
                PROTOCOL = DistPastryNodeFactory.PROTOCOL_SOCKET;
                break;
            }
            if (s.equalsIgnoreCase("direct")) {
                PROTOCOL = -138;
                break;
            }
            System.out.println("ERROR: Unsupported protocol: " + s);
            break;
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-simulator") || i + 1 >= args.length) continue;
            String s = args[i + 1];
            if (s.equalsIgnoreCase("sphere")) {
                SIMULATOR = -1;
                break;
            }
            if (s.equalsIgnoreCase("euclidean")) {
                PROTOCOL = -2;
                break;
            }
            System.out.println("ERROR: Unsupported simulator: " + s);
            break;
        }
    }

    public static void main(String[] args) {
        MultiringRegrTest.parseArgs(args);
        MultiringRegrTest test = new MultiringRegrTest();
        test.start();
    }

    static {
        try {
            BOOTSTRAP_HOST = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            System.out.println("Error determining local host: " + e);
        }
    }

    public static class MultiringTestMessage
    implements Message {
        public Id source;

        public MultiringTestMessage(Id source) {
            this.source = source;
        }

        public int getPriority() {
            return 15;
        }
    }

    public class MultiringTestApp
    implements Application {
        protected Endpoint endpoint;

        public MultiringTestApp(Node node) {
            this.endpoint = node.registerApplication(this, "BLAH");
        }

        public void send(Id target) {
            this.endpoint.route(target, new MultiringTestMessage(this.endpoint.getId()), null);
        }

        public boolean forward(RouteMessage message) {
            return true;
        }

        public void deliver(Id id, Message message) {
            System.out.println("RECEIVED MESSSAGE FROM " + ((MultiringTestMessage)message).source + " FOR TARGET " + id + " AT NODE " + this.endpoint.getId());
        }

        public void update(NodeHandle handle, boolean joined) {
        }
    }
}

