/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.past;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import rice.Continuation;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.CancellableTask;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.IdSet;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.NodeHandleSet;
import rice.p2p.commonapi.RouteMessage;
import rice.p2p.past.Past;
import rice.p2p.past.PastContent;
import rice.p2p.past.PastContentHandle;
import rice.p2p.past.PastException;
import rice.p2p.past.PastImpl;
import rice.p2p.past.PastPolicy;
import rice.p2p.past.messaging.CacheMessage;
import rice.p2p.past.messaging.ContinuationMessage;
import rice.p2p.past.messaging.FetchHandleMessage;
import rice.p2p.past.messaging.FetchMessage;
import rice.p2p.past.messaging.InsertMessage;
import rice.p2p.past.messaging.LookupHandlesMessage;
import rice.p2p.past.messaging.LookupMessage;
import rice.p2p.past.messaging.MessageLostMessage;
import rice.p2p.past.messaging.PastMessage;
import rice.p2p.replication.Replication;
import rice.p2p.replication.manager.ReplicationManager;
import rice.p2p.replication.manager.ReplicationManagerClient;
import rice.p2p.replication.manager.ReplicationManagerImpl;
import rice.persistence.Cache;
import rice.persistence.StorageManager;

public class PastImpl
implements Past,
Application,
ReplicationManagerClient {
    protected Endpoint endpoint;
    protected StorageManager storage;
    protected StorageManager trash;
    protected Cache backup;
    protected int replicationFactor;
    protected ReplicationManager replicaManager;
    protected PastPolicy policy;
    private int id;
    private Hashtable outstanding;
    private Hashtable timers;
    protected IdFactory factory;
    protected Logger log = Logger.getLogger(this.getClass().getName());
    protected String instance;
    public int inserts = 0;
    public int lookups = 0;
    public int fetchHandles = 0;
    public int other = 0;
    public static final boolean verbose = false;
    public static int MESSAGE_TIMEOUT = 30000;
    public static double SUCCESSFUL_INSERT_THRESHOLD = 0.5;

    public PastImpl(Node node, StorageManager manager, int replicas, String instance) {
        this(node, manager, replicas, instance, new PastPolicy.DefaultPastPolicy());
    }

    public PastImpl(Node node, StorageManager manager, int replicas, String instance, PastPolicy policy) {
        this(node, manager, null, replicas, instance, policy, null);
    }

    public PastImpl(Node node, StorageManager manager, Cache backup, int replicas, String instance, PastPolicy policy, StorageManager trash) {
        this.log.setLevel(Level.WARNING);
        this.storage = manager;
        this.backup = backup;
        this.endpoint = node.registerApplication(this, instance);
        this.factory = node.getIdFactory();
        this.policy = policy;
        this.instance = instance;
        this.trash = trash;
        this.id = Integer.MIN_VALUE;
        this.outstanding = new Hashtable();
        this.timers = new Hashtable();
        this.replicationFactor = replicas;
        this.replicaManager = this.buildReplicationManager(node, instance);
    }

    public Continuation[] getOutstandingMessages() {
        return this.outstanding.values().toArray(new Continuation[0]);
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    protected synchronized int getUID() {
        return this.id++;
    }

    protected Continuation getResponseContinuation(final PastMessage msg) {
        this.log.finer("Getting the Continuation to respond to the message " + msg);
        final ContinuationMessage cmsg = (ContinuationMessage)msg;
        return new Continuation(){

            public void receiveResult(Object o) {
                cmsg.receiveResult(o);
                PastImpl.this.endpoint.route(null, cmsg, msg.getSource());
            }

            public void receiveException(Exception e) {
                cmsg.receiveException(e);
                PastImpl.this.endpoint.route(null, cmsg, msg.getSource());
            }
        };
    }

    protected void getHandles(Id id, int max, Continuation command) {
        NodeHandleSet set = this.endpoint.replicaSet(id, max);
        if (set.size() == max) {
            command.receiveResult(set);
        } else {
            this.sendRequest(id, (PastMessage)new LookupHandlesMessage(this.getUID(), id, max, this.getLocalNodeHandle(), id), (Continuation)new Continuation.NamedContinuation("LookupHandlesMessage for " + id, command));
        }
    }

    public NodeHandle getLocalNodeHandle() {
        return this.endpoint.getLocalNodeHandle();
    }

    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    public Replication getReplication() {
        return this.replicaManager.getReplication();
    }

    public StorageManager getStorageManager() {
        return this.storage;
    }

    protected ReplicationManager buildReplicationManager(Node node, String instance) {
        return new ReplicationManagerImpl(node, this, this.replicationFactor, instance);
    }

    protected void sendRequest(Id id, PastMessage message, Continuation command) {
        this.sendRequest(id, message, null, command);
    }

    protected void sendRequest(NodeHandle handle, PastMessage message, Continuation command) {
        this.sendRequest(null, message, handle, command);
    }

    protected void sendRequest(Id id, PastMessage message, NodeHandle hint, Continuation command) {
        this.log.finer("Sending request message " + message + " to id " + id + " via " + hint);
        CancellableTask timer = this.endpoint.scheduleMessage(new MessageLostMessage(message.getUID(), this.getLocalNodeHandle(), id, message, hint), MESSAGE_TIMEOUT);
        this.insertPending(message.getUID(), timer, command);
        this.endpoint.route(id, message, hint);
    }

    private void insertPending(int uid, CancellableTask timer, Continuation command) {
        this.log.finer("Loading continuation " + uid + " into pending table");
        this.timers.put(new Integer(uid), timer);
        this.outstanding.put(new Integer(uid), command);
    }

    private Continuation removePending(int uid) {
        this.log.finer("Removing and returning continuation " + uid + " from pending table");
        CancellableTask timer = (CancellableTask)this.timers.remove(new Integer(uid));
        if (timer != null) {
            timer.cancel();
        }
        return (Continuation)this.outstanding.remove(new Integer(uid));
    }

    private void handleResponse(PastMessage message) {
        this.log.fine("handling reponse message " + message + " from the request");
        Continuation command = this.removePending(message.getUID());
        if (command != null) {
            message.returnResponse(command);
        }
    }

    private void cache(PastContent content) {
        this.cache(content, new Continuation.ListenerContinuation("Caching of " + content));
    }

    public void cache(PastContent content, Continuation command) {
        this.log.finer("Inserting PastContent object " + content + " into cache");
        if (content != null && !content.isMutable()) {
            this.storage.cache(content.getId(), null, content, command);
        } else {
            command.receiveResult(new Boolean(true));
        }
    }

    protected void doInsert(final Id id, final MessageBuilder builder, Continuation command) {
        this.getHandles(id, this.replicationFactor + 1, new Continuation.StandardContinuation(command){

            public void receiveResult(Object o) {
                NodeHandleSet replicas = (NodeHandleSet)o;
                PastImpl.this.log.finer("Received replicas " + replicas + " for id " + id);
                Continuation.MultiContinuation multi = new Continuation.MultiContinuation(this, this.parent, replicas.size()){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public boolean isDone() throws Exception {
                        int numSuccess = 0;
                        for (int i = 0; i < this.haveResult.length; ++i) {
                            if (!this.haveResult[i] || !Boolean.TRUE.equals(this.result[i])) continue;
                            ++numSuccess;
                        }
                        if ((double)numSuccess >= SUCCESSFUL_INSERT_THRESHOLD * (double)this.haveResult.length) {
                            return true;
                        }
                        if (super.isDone()) {
                            throw new PastException("Had only " + numSuccess + " successful inserts out of " + this.result.length + " - aborting.");
                        }
                        return false;
                    }

                    public Object getResult() {
                        Boolean[] b = new Boolean[this.result.length];
                        for (int i = 0; i < b.length; ++i) {
                            b[i] = new Boolean(this.result[i] == null || Boolean.TRUE.equals(this.result[i]));
                        }
                        return b;
                    }
                };
                for (int i = 0; i < replicas.size(); ++i) {
                    PastImpl.this.sendRequest(replicas.getHandle(i), builder.buildMessage(), (Continuation)new Continuation.NamedContinuation("InsertMessage to " + replicas.getHandle(i) + " for " + id, multi.getSubContinuation(i)));
                }
            }
        });
    }

    public void insert(final PastContent obj, Continuation command) {
        this.log.fine("Inserting the object " + obj + " with the id " + obj.getId());
        this.doInsert(obj.getId(), new MessageBuilder(){

            public PastMessage buildMessage() {
                return new InsertMessage(PastImpl.this.getUID(), obj, PastImpl.this.getLocalNodeHandle(), obj.getId());
            }
        }, new Continuation.StandardContinuation(command){

            public void receiveResult(Object array) {
                PastImpl.this.cache(obj, new Continuation.SimpleContinuation(this, array){
                    private final /* synthetic */ Object val$array;
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$array = val$array;
                    }

                    public void receiveResult(Object o) {
                        5.access$000(this.this$1).receiveResult(this.val$array);
                    }
                });
            }

            static /* synthetic */ Continuation access$000(5 x0) {
                return x0.parent;
            }
        });
    }

    public void lookup(Id id, Continuation command) {
        this.lookup(id, true, command);
    }

    public void lookup(final Id id, final boolean cache, final Continuation command) {
        this.storage.getObject(id, new Continuation.StandardContinuation(command){

            public void receiveResult(Object o) {
                if (o != null) {
                    command.receiveResult(o);
                } else {
                    PastImpl.this.sendRequest(id, (PastMessage)new LookupMessage(PastImpl.this.getUID(), id, PastImpl.this.getLocalNodeHandle(), id), (Continuation)new Continuation.NamedContinuation(this, "LookupMessage for " + id, this){
                        private final /* synthetic */ 7 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void receiveResult(Object o) {
                            if (o != null) {
                                if (7.access$100(this.this$1)) {
                                    7.access$400(this.this$1).cache((PastContent)o, new Continuation.SimpleContinuation(this, o){
                                        private final /* synthetic */ Object val$o;
                                        private final /* synthetic */ 8 this$2;
                                        {
                                            this.this$2 = this$2;
                                            this.val$o = val$o;
                                        }

                                        public void receiveResult(Object object) {
                                            7.access$300(8.access$200(this.this$2)).receiveResult(this.val$o);
                                        }
                                    });
                                } else {
                                    7.access$300(this.this$1).receiveResult(o);
                                }
                            } else {
                                7.access$400(this.this$1).lookupHandles(7.access$500(this.this$1), 7.access$400(this.this$1).replicationFactor + 1, new Continuation(this){
                                    private final /* synthetic */ 8 this$2;
                                    {
                                        this.this$2 = this$2;
                                    }

                                    public void receiveResult(Object o) {
                                        PastContentHandle[] handles = (PastContentHandle[])o;
                                        for (int i = 0; i < handles.length; ++i) {
                                            if (handles[i] == null) continue;
                                            7.access$400(8.access$200(this.this$2)).fetch(handles[i], new Continuation.StandardContinuation(this, 8.access$600(this.this$2)){
                                                private final /* synthetic */ 10 this$3;
                                                {
                                                    super(x0);
                                                    this.this$3 = this$3;
                                                }

                                                public void receiveResult(Object o) {
                                                    if (7.access$100(8.access$200(10.access$700(this.this$3)))) {
                                                        7.access$400(8.access$200(10.access$700(this.this$3))).cache((PastContent)o, new Continuation.SimpleContinuation(this, o){
                                                            private final /* synthetic */ Object val$o;
                                                            private final /* synthetic */ 11 this$4;
                                                            {
                                                                this.this$4 = this$4;
                                                                this.val$o = val$o;
                                                            }

                                                            public void receiveResult(Object object) {
                                                                7.access$300(8.access$200(10.access$700(11.access$800(this.this$4)))).receiveResult(this.val$o);
                                                            }
                                                        });
                                                    } else {
                                                        7.access$300(8.access$200(10.access$700(this.this$3))).receiveResult(o);
                                                    }
                                                }

                                                static /* synthetic */ 10 access$800(11 x0) {
                                                    return x0.this$3;
                                                }
                                            });
                                            return;
                                        }
                                        7.access$300(8.access$200(this.this$2)).receiveResult(null);
                                    }

                                    public void receiveException(Exception e) {
                                        7.access$300(8.access$200(this.this$2)).receiveException(e);
                                    }

                                    static /* synthetic */ 8 access$700(10 x0) {
                                        return x0.this$2;
                                    }
                                });
                            }
                        }

                        public void receiveException(Exception e) {
                            this.receiveResult(null);
                        }

                        static /* synthetic */ 7 access$200(8 x0) {
                            return x0.this$1;
                        }

                        static /* synthetic */ Continuation access$600(8 x0) {
                            return x0.parent;
                        }
                    });
                }
            }

            static /* synthetic */ boolean access$100(7 x0) {
                return x0.cache;
            }

            static /* synthetic */ Continuation access$300(7 x0) {
                return x0.command;
            }

            static /* synthetic */ PastImpl access$400(7 x0) {
                return x0.PastImpl.this;
            }

            static /* synthetic */ Id access$500(7 x0) {
                return x0.id;
            }
        });
    }

    public void lookupHandles(final Id id, int max, Continuation command) {
        this.log.fine("Retrieving handles of up to " + max + " replicas of the object stored in Past with id " + id);
        this.getHandles(id, max, new Continuation.StandardContinuation(command){

            public void receiveResult(Object o) {
                NodeHandleSet replicas = (NodeHandleSet)o;
                PastImpl.this.log.finer("Receiving replicas " + replicas + " for lookup Id " + id);
                Continuation.MultiContinuation multi = new Continuation.MultiContinuation(this, this.parent, replicas.size()){
                    private final /* synthetic */ 13 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Object getResult() {
                        PastContentHandle[] p = new PastContentHandle[this.result.length];
                        for (int i = 0; i < this.result.length; ++i) {
                            if (!(this.result[i] instanceof PastContentHandle)) continue;
                            p[i] = (PastContentHandle)this.result[i];
                        }
                        return p;
                    }
                };
                for (int i = 0; i < replicas.size(); ++i) {
                    PastImpl.this.lookupHandle(id, replicas.getHandle(i), multi.getSubContinuation(i));
                }
            }
        });
    }

    public void lookupHandle(Id id, NodeHandle handle, Continuation command) {
        this.log.fine("Retrieving handle for id " + id + " from node " + handle);
        this.sendRequest(handle, (PastMessage)new FetchHandleMessage(this.getUID(), id, this.getLocalNodeHandle(), handle.getId()), (Continuation)new Continuation.NamedContinuation("FetchHandleMessage to " + handle + " for " + id, command));
    }

    public void fetch(PastContentHandle handle, Continuation command) {
        this.log.fine("Retrieving object associated with content handle " + handle);
        NodeHandle han = handle.getNodeHandle();
        this.sendRequest(han, (PastMessage)new FetchMessage(this.getUID(), handle, this.getLocalNodeHandle(), han.getId()), (Continuation)new Continuation.NamedContinuation("FetchMessage to " + handle.getNodeHandle() + " for " + handle.getId(), command));
    }

    public boolean forward(RouteMessage message) {
        LookupHandlesMessage lmsg;
        if (message.getMessage() instanceof LookupMessage) {
            LookupMessage lmsg2 = (LookupMessage)message.getMessage();
            Id id = lmsg2.getId();
            if (!lmsg2.isResponse()) {
                this.log.finer("Lookup message " + lmsg2 + " is a request; look in the cache");
                if (this.storage.exists(id)) {
                    this.log.fine("Request for " + id + " satisfied locally - responding");
                    this.deliver(this.endpoint.getId(), lmsg2);
                    return false;
                }
            }
        } else if (message.getMessage() instanceof LookupHandlesMessage && !(lmsg = (LookupHandlesMessage)message.getMessage()).isResponse() && this.endpoint.replicaSet(lmsg.getId(), lmsg.getMax()).size() == lmsg.getMax()) {
            this.log.fine("Hijacking lookup handles request for " + lmsg.getId());
            this.deliver(this.endpoint.getId(), lmsg);
            return false;
        }
        return true;
    }

    public void deliver(Id id, Message message) {
        PastMessage msg = (PastMessage)message;
        if (msg.isResponse()) {
            this.handleResponse((PastMessage)message);
        } else {
            this.log.info("Received message " + message + " with destination " + id);
            if (msg instanceof InsertMessage) {
                final InsertMessage imsg = (InsertMessage)msg;
                if (this.policy.allowInsert(imsg.getContent())) {
                    ++this.inserts;
                    this.storage.getObject(imsg.getContent().getId(), new Continuation.StandardContinuation(this.getResponseContinuation(msg)){

                        public void receiveResult(Object o) {
                            try {
                                PastContent content = imsg.getContent().checkInsert(imsg.getContent().getId(), (PastContent)o);
                                PastImpl.this.storage.store(imsg.getContent().getId(), null, content, this.parent);
                            }
                            catch (PastException e) {
                                this.parent.receiveException(e);
                            }
                        }
                    });
                } else {
                    this.getResponseContinuation(msg).receiveResult(new Boolean(false));
                }
            } else if (msg instanceof LookupMessage) {
                final LookupMessage lmsg = (LookupMessage)msg;
                ++this.lookups;
                this.storage.getObject(lmsg.getId(), new Continuation.StandardContinuation(this.getResponseContinuation(lmsg)){

                    public void receiveResult(Object o) {
                        PastImpl.this.log.fine("Received object " + o + " for id " + lmsg.getId());
                        this.parent.receiveResult(o);
                        if (lmsg.getPreviousNodeHandle() != null && o != null && !((PastContent)o).isMutable()) {
                            NodeHandle handle = lmsg.getPreviousNodeHandle();
                            PastImpl.this.log.fine("Pushing cached copy of " + ((PastContent)o).getId() + " to " + handle);
                            CacheMessage cacheMessage = new CacheMessage(PastImpl.this.getUID(), (PastContent)o, PastImpl.this.getLocalNodeHandle(), handle.getId());
                        }
                    }
                });
            } else if (msg instanceof LookupHandlesMessage) {
                LookupHandlesMessage lmsg = (LookupHandlesMessage)msg;
                NodeHandleSet set = this.endpoint.replicaSet(lmsg.getId(), lmsg.getMax());
                this.log.finer("Returning replica set " + set + " for lookup handles of id " + lmsg.getId() + " max " + lmsg.getMax() + " at " + this.endpoint.getId());
                this.getResponseContinuation(msg).receiveResult(set);
            } else if (msg instanceof FetchMessage) {
                FetchMessage fmsg = (FetchMessage)msg;
                ++this.lookups;
                this.storage.getObject(fmsg.getHandle().getId(), this.getResponseContinuation(msg));
            } else if (msg instanceof FetchHandleMessage) {
                final FetchHandleMessage fmsg = (FetchHandleMessage)msg;
                ++this.fetchHandles;
                this.storage.getObject(fmsg.getId(), new Continuation.StandardContinuation(this.getResponseContinuation(msg)){

                    public void receiveResult(Object o) {
                        PastContent content = (PastContent)o;
                        if (content != null) {
                            PastImpl.this.log.fine("Retrieved data for fetch handles of id " + fmsg.getId());
                            this.parent.receiveResult(content.getHandle(PastImpl.this));
                        } else {
                            this.parent.receiveResult(null);
                        }
                    }
                });
            } else if (msg instanceof CacheMessage) {
                this.cache(((CacheMessage)msg).getContent());
            } else {
                this.log.severe("ERROR - Received message " + msg + "of unknown type.");
            }
        }
    }

    public void update(NodeHandle handle, boolean joined) {
    }

    public void fetch(final Id id, NodeHandle hint, Continuation command) {
        this.log.finer("Sending out replication fetch request for the id " + id);
        this.policy.fetch(id, hint, this.backup, this, new Continuation.StandardContinuation(command){

            public void receiveResult(Object o) {
                if (o == null) {
                    PastImpl.this.log.warning("Could not fetch id " + id + " - policy returned null in namespace " + PastImpl.this.instance);
                    this.parent.receiveResult(new Boolean(false));
                } else {
                    PastImpl.this.log.finest("inserting replica of id " + id);
                    if (!(o instanceof PastContent)) {
                        System.err.println("ERROR! Not PastContent " + o.getClass().getName() + " " + o);
                    }
                    PastImpl.this.storage.getStorage().store(((PastContent)o).getId(), null, (PastContent)o, this.parent);
                }
            }
        });
    }

    public void remove(final Id id, Continuation command) {
        if (this.backup != null) {
            this.storage.getObject(id, new Continuation.StandardContinuation(command){

                public void receiveResult(Object o) {
                    PastImpl.this.backup.cache(id, PastImpl.this.storage.getMetadata(id), (Serializable)o, new Continuation.StandardContinuation(this, this.parent){
                        private final /* synthetic */ 19 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void receiveResult(Object o) {
                            19.access$1000(this.this$1).storage.unstore(19.access$900(this.this$1), this.parent);
                        }
                    });
                }

                static /* synthetic */ Id access$900(19 x0) {
                    return x0.id;
                }

                static /* synthetic */ PastImpl access$1000(19 x0) {
                    return x0.PastImpl.this;
                }
            });
        } else {
            this.storage.unstore(id, command);
        }
    }

    public IdSet scan(IdRange range) {
        return this.storage.getStorage().scan(range);
    }

    public IdSet scan() {
        return this.storage.getStorage().scan();
    }

    public boolean exists(Id id) {
        return this.storage.getStorage().exists(id);
    }

    public static interface MessageBuilder {
        public PastMessage buildMessage();
    }
}

