/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.past.gc;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.Vector;
import rice.Continuation;
import rice.Executable;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.IdSet;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.NodeHandleSet;
import rice.p2p.commonapi.RouteMessage;
import rice.p2p.past.PastContent;
import rice.p2p.past.PastException;
import rice.p2p.past.PastImpl;
import rice.p2p.past.PastPolicy;
import rice.p2p.past.gc.GCId;
import rice.p2p.past.gc.GCIdRange;
import rice.p2p.past.gc.GCIdSet;
import rice.p2p.past.gc.GCNode;
import rice.p2p.past.gc.GCPast;
import rice.p2p.past.gc.GCPastContent;
import rice.p2p.past.gc.GCPastImpl;
import rice.p2p.past.gc.GCPastMetadata;
import rice.p2p.past.gc.messaging.GCCollectMessage;
import rice.p2p.past.gc.messaging.GCInsertMessage;
import rice.p2p.past.gc.messaging.GCLookupHandlesMessage;
import rice.p2p.past.gc.messaging.GCRefreshMessage;
import rice.p2p.past.messaging.FetchHandleMessage;
import rice.p2p.past.messaging.PastMessage;
import rice.persistence.Cache;
import rice.persistence.StorageManager;

public class GCPastImpl
extends PastImpl
implements GCPast {
    protected IdFactory realFactory;
    public int collected = 0;
    public int refreshed = 0;
    public static final boolean verbose = false;
    public static final long DEFAULT_EXPIRATION = Long.MAX_VALUE;

    public GCPastImpl(Node node, StorageManager manager, int replicas, String instance, PastPolicy policy, long collectionInterval) {
        this(node, manager, null, replicas, instance, policy, collectionInterval, null);
    }

    public GCPastImpl(Node node, StorageManager manager, Cache backup, int replicas, String instance, PastPolicy policy, long collectionInterval, StorageManager trash) {
        super(new GCNode(node), manager, backup, replicas, instance, policy, trash);
        this.realFactory = node.getIdFactory();
        this.endpoint.scheduleMessage(new GCCollectMessage(0, this.getLocalNodeHandle(), node.getId()), collectionInterval, collectionInterval);
    }

    public void insert(PastContent obj, Continuation command) {
        this.insert(obj, Long.MAX_VALUE, command);
    }

    public void insert(final PastContent obj, final long expiration, Continuation command) {
        this.doInsert(obj.getId(), new PastImpl.MessageBuilder(){

            public PastMessage buildMessage() {
                return new GCInsertMessage(GCPastImpl.this.getUID(), obj, expiration, GCPastImpl.this.getLocalNodeHandle(), obj.getId());
            }
        }, command);
    }

    public void refresh(Id[] array, long expiration, Continuation command) {
        long[] expirations = new long[array.length];
        Arrays.fill(expirations, expiration);
        this.refresh(array, expirations, command);
    }

    public void refresh(final Id[] array, long[] expirations, Continuation command) {
        GCIdSet set = new GCIdSet(this.realFactory);
        for (int i = 0; i < array.length; ++i) {
            set.addId(new GCId(array[i], expirations[i]));
        }
        this.refresh(set, new Continuation.StandardContinuation(command){

            public void receiveResult(Object o) {
                Object[] result = new Object[array.length];
                Arrays.fill(result, Boolean.TRUE);
                this.parent.receiveResult(result);
            }
        });
    }

    protected void refresh(final GCIdSet ids, Continuation command) {
        System.out.println("REFRESH: CALLED WITH " + ids.numElements() + " ELEMENTS");
        if (ids.numElements() == 0) {
            command.receiveResult(new Object[0]);
            return;
        }
        final Id[] array = ids.asArray();
        GCId start = (GCId)array[0];
        System.out.println("REFRESH: GETTINGS ALL HANDLES OF " + start);
        this.sendRequest(start.getId(), (PastMessage)new GCLookupHandlesMessage(this.getUID(), start.getId(), this.getLocalNodeHandle(), start.getId()), (Continuation)new Continuation.NamedContinuation("GCLookupHandles for " + start.getId(), command){

            public void receiveResult(Object o) {
                NodeHandleSet set = (NodeHandleSet)o;
                ReplicaMap map = new ReplicaMap();
                System.out.println("REFRESH: GOT " + set + " SET OF HANDLES!");
                GCPastImpl.this.endpoint.process(new Executable(this, set, map){
                    private final /* synthetic */ NodeHandleSet val$set;
                    private final /* synthetic */ ReplicaMap val$map;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$set = val$set;
                        this.val$map = val$map;
                    }

                    public Object execute() {
                        System.out.println("REFRESH: ON PROCESSING THREAD!");
                        for (int i = 0; i < 3.access$100(this.this$1).length; ++i) {
                            GCId id = (GCId)3.access$100(this.this$1)[i];
                            NodeHandleSet replicas = GCPastImpl.access$400(3.access$200(this.this$1)).replicaSet(id.getId(), GCPastImpl.access$300(3.access$200(this.this$1)) + 1, this.val$set.getHandle(this.val$set.size() - 1), this.val$set);
                            if (replicas == null || replicas.size() != this.val$set.size() && replicas.size() != GCPastImpl.access$500(3.access$200(this.this$1)) + 1) continue;
                            for (int j = 0; j < replicas.size(); ++j) {
                                this.val$map.addReplica(replicas.getHandle(j), id);
                            }
                            ++3.access$200(this.this$1).refreshed;
                            3.access$600(this.this$1).removeId(id);
                        }
                        System.out.println("REFRESH: DONE WITH PROCESSING THREAD - MOVING TO NORMAL THREAD!");
                        return null;
                    }
                }, new Continuation.StandardContinuation(this, this.parent, map){
                    private final /* synthetic */ ReplicaMap val$map;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$map = val$map;
                    }

                    public void receiveResult(Object o) {
                        System.out.println("REFRESH: BACK ON NORMAL THREAD!");
                        Iterator iterator = this.val$map.getReplicas();
                        Continuation.StandardContinuation send = new Continuation.StandardContinuation(this, this.parent, iterator){
                            private final /* synthetic */ Iterator val$iterator;
                            private final /* synthetic */ 5 this$2;
                            {
                                super(x0);
                                this.this$2 = this$2;
                                this.val$iterator = val$iterator;
                            }

                            public void receiveResult(Object o) {
                                if (this.val$iterator.hasNext()) {
                                    NodeHandle next = (NodeHandle)this.val$iterator.next();
                                    GCIdSet ids = 5.access$700(this.this$2).getIds(next);
                                    System.out.println("REFRESH: SENDING REQUEST TO " + next + " FOR IDSET " + ids);
                                    GCPastImpl.access$1000(3.access$200(5.access$800(this.this$2)), next, new GCRefreshMessage(GCPastImpl.access$900(3.access$200(5.access$800(this.this$2))), ids, 3.access$200(5.access$800(this.this$2)).getLocalNodeHandle(), next.getId()), new Continuation.NamedContinuation("GCRefresh to " + next, this));
                                } else {
                                    System.out.println("REFRESH: DONE SENDING REQUESTS, RECURSING");
                                    3.access$200(5.access$800(this.this$2)).refresh(3.access$600(5.access$800(this.this$2)), this.parent);
                                }
                            }

                            public void receiveException(Exception e) {
                                System.out.println("GOT EXCEPTION " + e + " REFRESHING ITEMS - CONTINUING");
                                this.receiveResult(null);
                            }
                        };
                        send.receiveResult(null);
                    }

                    static /* synthetic */ ReplicaMap access$700(5 x0) {
                        return x0.val$map;
                    }

                    static /* synthetic */ 3 access$800(5 x0) {
                        return x0.this$1;
                    }
                });
            }

            static /* synthetic */ Id[] access$100(3 x0) {
                return x0.array;
            }

            static /* synthetic */ GCPastImpl access$200(3 x0) {
                return x0.GCPastImpl.this;
            }

            static /* synthetic */ GCIdSet access$600(3 x0) {
                return x0.ids;
            }
        });
    }

    public boolean forward(RouteMessage message) {
        if (message.getMessage() instanceof GCLookupHandlesMessage) {
            return true;
        }
        return super.forward(message);
    }

    public void deliver(Id id, Message message) {
        PastMessage msg = (PastMessage)message;
        if (msg.isResponse()) {
            super.deliver(id, message);
        } else if (msg instanceof GCInsertMessage) {
            final GCInsertMessage imsg = (GCInsertMessage)msg;
            ++this.inserts;
            if (this.policy.allowInsert(imsg.getContent())) {
                this.storage.getObject(imsg.getContent().getId(), new Continuation.StandardContinuation(this.getResponseContinuation(msg)){

                    public void receiveResult(Object o) {
                        try {
                            GCPastContent content = (GCPastContent)imsg.getContent().checkInsert(imsg.getContent().getId(), (PastContent)o);
                            GCPastImpl.this.storage.store(content.getId(), content.getMetadata(imsg.getExpiration()), content, this.parent);
                        }
                        catch (PastException e) {
                            this.parent.receiveException(e);
                        }
                    }
                });
            } else {
                this.getResponseContinuation(msg).receiveResult(new Boolean(false));
            }
        } else if (msg instanceof GCRefreshMessage) {
            GCRefreshMessage rmsg = (GCRefreshMessage)msg;
            final Iterator i = rmsg.getKeys().getIterator();
            final Vector result = new Vector();
            this.other += rmsg.getKeys().numElements();
            Continuation.StandardContinuation process = new Continuation.StandardContinuation(this.getResponseContinuation(msg)){

                public void receiveResult(Object o) {
                    if (o != null) {
                        result.addElement(o);
                    }
                    if (i.hasNext()) {
                        GCId id = (GCId)i.next();
                        if (GCPastImpl.this.storage.exists(id.getId())) {
                            GCPastMetadata metadata = (GCPastMetadata)GCPastImpl.this.storage.getMetadata(id.getId());
                            if (metadata != null) {
                                GCPastImpl.this.storage.setMetadata(id.getId(), metadata.setExpiration(id.getExpiration()), this);
                            } else {
                                GCPastImpl.this.storage.getObject(id.getId(), new Continuation.StandardContinuation(this, this, id){
                                    private final /* synthetic */ GCId val$id;
                                    private final /* synthetic */ 8 this$1;
                                    {
                                        this.this$1 = this$1;
                                        this.val$id = val$id;
                                    }

                                    public void receiveResult(Object o) {
                                        GCPastImpl.access$1700(8.access$1600(this.this$1)).setMetadata(this.val$id.getId(), ((GCPastContent)o).getMetadata(this.val$id.getExpiration()), this.parent);
                                    }
                                });
                            }
                        } else if (GCPastImpl.this.trash != null) {
                            GCPastImpl.this.trash.getObject(id.getId(), new Continuation.StandardContinuation(this, this, id){
                                private final /* synthetic */ GCId val$id;
                                private final /* synthetic */ 8 this$1;
                                {
                                    this.this$1 = this$1;
                                    this.val$id = val$id;
                                }

                                public void receiveResult(Object o) {
                                    if (o != null && o instanceof GCPastContent) {
                                        System.out.println("GCREFRESH: Restoring object " + this.val$id + " from trash!");
                                        GCPastContent content = (GCPastContent)o;
                                        GCPastImpl.access$2300(8.access$1600(this.this$1)).store(this.val$id.getId(), content.getMetadata(this.val$id.getExpiration()), content, new Continuation.StandardContinuation(this, this.parent){
                                            private final /* synthetic */ 10 this$2;
                                            {
                                                super(x0);
                                                this.this$2 = this$2;
                                            }

                                            public void receiveResult(Object o) {
                                                GCPastImpl.access$2200(8.access$1600(10.access$2100(this.this$2))).unstore(10.access$2000(this.this$2).getId(), this.parent);
                                            }
                                        });
                                    } else {
                                        this.parent.receiveResult(Boolean.FALSE);
                                    }
                                }

                                static /* synthetic */ GCId access$2000(10 x0) {
                                    return x0.val$id;
                                }

                                static /* synthetic */ 8 access$2100(10 x0) {
                                    return x0.this$1;
                                }
                            });
                        } else {
                            this.receiveResult(Boolean.FALSE);
                        }
                    } else {
                        this.parent.receiveResult(result.toArray(new Boolean[0]));
                    }
                }

                static /* synthetic */ GCPastImpl access$1600(8 x0) {
                    return x0.GCPastImpl.this;
                }
            };
            process.receiveResult(null);
        } else if (msg instanceof GCLookupHandlesMessage) {
            GCLookupHandlesMessage lmsg = (GCLookupHandlesMessage)msg;
            NodeHandleSet set = this.endpoint.neighborSet(lmsg.getMax());
            set.removeHandle(this.getLocalNodeHandle().getId());
            set.putHandle(this.getLocalNodeHandle());
            this.log.finer("Returning neighbor set " + set + " for lookup handles of id " + lmsg.getId() + " max " + lmsg.getMax() + " at " + this.endpoint.getId());
            this.getResponseContinuation(msg).receiveResult(set);
        } else if (msg instanceof GCCollectMessage) {
            this.collect(this.storage.scanMetadataValuesHead(new GCPastMetadata(System.currentTimeMillis())), new Continuation.ListenerContinuation("Removal of expired ids"){

                public void receiveResult(Object o) {
                    if (System.currentTimeMillis() > Long.MAX_VALUE) {
                        GCPastImpl.this.collect(GCPastImpl.this.storage.scanMetadataValuesNull(), new Continuation.ListenerContinuation("Removal of default expired ids"));
                    }
                }
            });
        } else if (msg instanceof FetchHandleMessage) {
            final FetchHandleMessage fmsg = (FetchHandleMessage)msg;
            ++this.fetchHandles;
            this.storage.getObject(fmsg.getId(), new Continuation.StandardContinuation(this.getResponseContinuation(msg)){

                public void receiveResult(Object o) {
                    GCPastContent content = (GCPastContent)o;
                    if (content != null) {
                        GCPastImpl.this.log.fine("Retrieved data for fetch handles of id " + fmsg.getId());
                        GCPastMetadata metadata = (GCPastMetadata)GCPastImpl.this.storage.getMetadata(fmsg.getId());
                        if (metadata != null) {
                            this.parent.receiveResult(content.getHandle(GCPastImpl.this, metadata.getExpiration()));
                        } else {
                            this.parent.receiveResult(content.getHandle(GCPastImpl.this, Long.MAX_VALUE));
                        }
                    } else {
                        this.parent.receiveResult(null);
                    }
                }
            });
        } else {
            super.deliver(id, message);
        }
    }

    protected void collect(SortedMap map, Continuation command) {
        final Iterator i = map.keySet().iterator();
        Continuation.StandardContinuation remove = new Continuation.StandardContinuation(command){

            public void receiveResult(Object o) {
                if (i.hasNext()) {
                    Id gid = (Id)i.next();
                    GCPastMetadata metadata = (GCPastMetadata)GCPastImpl.this.storage.getMetadata(gid);
                    ++GCPastImpl.this.collected;
                    if (GCPastImpl.this.trash != null) {
                        GCPastImpl.this.storage.getObject(gid, new Continuation.StandardContinuation(this, this, gid){
                            private final /* synthetic */ Id val$gid;
                            private final /* synthetic */ 14 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$gid = val$gid;
                            }

                            public void receiveResult(Object o) {
                                if (o != null) {
                                    GCPastImpl.access$3500(14.access$3000(this.this$1)).store(this.val$gid, GCPastImpl.access$3100(14.access$3000(this.this$1)).getMetadata(this.val$gid), (Serializable)o, new Continuation.StandardContinuation(this, this.parent){
                                        private final /* synthetic */ 15 this$2;
                                        {
                                            super(x0);
                                            this.this$2 = this$2;
                                        }

                                        public void receiveResult(Object o) {
                                            GCPastImpl.access$3400(14.access$3000(15.access$3300(this.this$2))).unstore(15.access$3200(this.this$2), this.parent);
                                        }
                                    });
                                } else {
                                    GCPastImpl.access$3600(14.access$3000(this.this$1)).unstore(this.val$gid, this);
                                }
                            }

                            static /* synthetic */ Id access$3200(15 x0) {
                                return x0.val$gid;
                            }

                            static /* synthetic */ 14 access$3300(15 x0) {
                                return x0.this$1;
                            }
                        });
                    } else {
                        GCPastImpl.this.storage.unstore(gid, this);
                    }
                } else {
                    this.parent.receiveResult(Boolean.TRUE);
                }
            }

            static /* synthetic */ GCPastImpl access$3000(14 x0) {
                return x0.GCPastImpl.this;
            }
        };
        remove.receiveResult(null);
    }

    public void fetch(final Id id, NodeHandle hint, Continuation command) {
        this.log.finer("Sending out replication fetch request for the id " + id);
        final GCId gcid = (GCId)id;
        if (gcid.getExpiration() < System.currentTimeMillis()) {
            command.receiveResult(Boolean.TRUE);
        } else if (this.storage.exists(gcid.getId())) {
            GCPastMetadata metadata = (GCPastMetadata)this.storage.getMetadata(gcid.getId());
            if (metadata == null) {
                this.storage.getObject(gcid.getId(), new Continuation.StandardContinuation(command){

                    public void receiveResult(Object o) {
                        GCPastContent content = (GCPastContent)o;
                        GCPastImpl.this.storage.setMetadata(content.getId(), content.getMetadata(gcid.getExpiration()), this.parent);
                    }
                });
            } else if (metadata.getExpiration() < gcid.getExpiration()) {
                this.storage.setMetadata(gcid.getId(), metadata.setExpiration(gcid.getExpiration()), command);
            } else {
                command.receiveResult(Boolean.TRUE);
            }
        } else {
            this.policy.fetch(gcid.getId(), hint, this.backup, this, new Continuation.StandardContinuation(command){

                public void receiveResult(Object o) {
                    if (o == null) {
                        GCPastImpl.this.log.warning("Could not fetch id " + id + " - policy returned null in namespace " + GCPastImpl.this.instance);
                        this.parent.receiveResult(new Boolean(false));
                    } else {
                        GCPastContent content = (GCPastContent)o;
                        GCPastImpl.this.log.finest("inserting replica of id " + id);
                        GCPastImpl.this.storage.getStorage().store(gcid.getId(), content.getMetadata(gcid.getExpiration()), content, this.parent);
                    }
                }
            });
        }
    }

    public void remove(Id id, Continuation command) {
        super.remove(((GCId)id).getId(), command);
    }

    public IdSet scan(IdRange range) {
        GCIdRange gcRange = (GCIdRange)range;
        return new GCIdSet(this.storage.getStorage().scan(gcRange.getRange()), this.storage.getStorage().scanMetadata(gcRange.getRange()));
    }

    public IdSet scan() {
        return new GCIdSet(this.storage.getStorage().scan(), this.storage.getStorage().scanMetadata());
    }

    public boolean exists(Id id) {
        if (id instanceof GCId) {
            return this.storage.getStorage().exists(((GCId)id).getId());
        }
        return this.storage.getStorage().exists(id);
    }

    static /* synthetic */ int access$300(GCPastImpl x0) {
        return x0.replicationFactor;
    }

    static /* synthetic */ Endpoint access$400(GCPastImpl x0) {
        return x0.endpoint;
    }

    static /* synthetic */ int access$500(GCPastImpl x0) {
        return x0.replicationFactor;
    }

    static /* synthetic */ int access$900(GCPastImpl x0) {
        return x0.getUID();
    }

    static /* synthetic */ void access$1000(GCPastImpl x0, NodeHandle x1, PastMessage x2, Continuation x3) {
        x0.sendRequest(x1, x2, x3);
    }

    static /* synthetic */ StorageManager access$1700(GCPastImpl x0) {
        return x0.storage;
    }

    static /* synthetic */ StorageManager access$2200(GCPastImpl x0) {
        return x0.trash;
    }

    static /* synthetic */ StorageManager access$2300(GCPastImpl x0) {
        return x0.storage;
    }

    static /* synthetic */ StorageManager access$3100(GCPastImpl x0) {
        return x0.storage;
    }

    static /* synthetic */ StorageManager access$3400(GCPastImpl x0) {
        return x0.storage;
    }

    static /* synthetic */ StorageManager access$3500(GCPastImpl x0) {
        return x0.trash;
    }

    static /* synthetic */ StorageManager access$3600(GCPastImpl x0) {
        return x0.storage;
    }

    protected class ReplicaMap {
        protected HashMap map = new HashMap();

        protected ReplicaMap() {
        }

        public Iterator getReplicas() {
            return this.map.keySet().iterator();
        }

        public GCIdSet getIds(NodeHandle replica) {
            return (GCIdSet)this.map.get(replica);
        }

        public void addReplica(NodeHandle handle, GCId id) {
            IdSet set = (IdSet)this.map.get(handle);
            if (set == null) {
                set = new GCIdSet(GCPastImpl.this.realFactory);
                this.map.put(handle, set);
            }
            set.addId(id);
        }
    }
}

