/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.replication;

import java.util.Iterator;
import java.util.Random;
import java.util.logging.Logger;
import rice.Continuation;
import rice.Executable;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.IdSet;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.NodeHandleSet;
import rice.p2p.commonapi.RouteMessage;
import rice.p2p.replication.Replication;
import rice.p2p.replication.ReplicationClient;
import rice.p2p.replication.ReplicationPolicy;
import rice.p2p.replication.messaging.ReminderMessage;
import rice.p2p.replication.messaging.RequestMessage;
import rice.p2p.replication.messaging.ResponseMessage;
import rice.p2p.util.IdBloomFilter;

public class ReplicationImpl
implements Replication,
Application {
    protected Endpoint endpoint;
    protected Logger log = Logger.getLogger(this.getClass().getName());
    protected NodeHandle handle;
    protected IdFactory factory;
    protected ReplicationClient client;
    protected ReplicationPolicy policy;
    protected int replicationFactor;
    protected String instance;
    public static final boolean verbose = false;
    public static int MAINTENANCE_INTERVAL = 600000;
    public static int MAX_KEYS_IN_MESSAGE = 1000;

    public ReplicationImpl(Node node, ReplicationClient client, int replicationFactor, String instance) {
        this(node, client, replicationFactor, instance, new ReplicationPolicy.DefaultReplicationPolicy());
    }

    public ReplicationImpl(Node node, ReplicationClient client, int replicationFactor, String instance, ReplicationPolicy policy) {
        this.client = client;
        this.replicationFactor = replicationFactor;
        this.factory = node.getIdFactory();
        this.policy = policy;
        this.instance = instance;
        this.endpoint = node.registerApplication(this, instance);
        if (this.policy == null) {
            this.policy = new ReplicationPolicy.DefaultReplicationPolicy();
        }
        this.handle = this.endpoint.getLocalNodeHandle();
        this.log.finer(this.endpoint.getId() + ": Starting up ReplicationImpl with client " + client + " and factor " + replicationFactor);
        this.endpoint.scheduleMessage(new ReminderMessage(this.handle), new Random().nextInt(MAINTENANCE_INTERVAL), MAINTENANCE_INTERVAL);
    }

    protected IdRange getTotalRange() {
        return this.endpoint.range(this.handle, this.replicationFactor, this.handle.getId(), true);
    }

    private void updateClient() {
        this.log.fine(this.endpoint.getId() + ": Updating client with range " + this.getTotalRange());
        if (this.getTotalRange() != null) {
            this.client.setRange(this.getTotalRange());
        }
    }

    public void replicate() {
        final NodeHandleSet handles = this.endpoint.neighborSet(Integer.MAX_VALUE);
        final IdRange ourRange = this.endpoint.range(this.handle, 0, this.handle.getId());
        this.endpoint.process(new BloomFilterExecutable(ourRange), new Continuation.ListenerContinuation("Creation of our bloom filter"){
            int total = 0;

            public void receiveResult(Object o) {
                IdBloomFilter ourFilter = (IdBloomFilter)o;
                for (int i = 0; i < handles.size(); ++i) {
                    IdRange range;
                    NodeHandle handle = handles.getHandle(i);
                    IdRange handleRange = ReplicationImpl.this.endpoint.range(handle, 0, handle.getId());
                    if (handleRange == null || (range = handleRange.intersectRange(ReplicationImpl.this.getTotalRange())) == null || range.intersectRange(ReplicationImpl.this.getTotalRange()).isEmpty()) continue;
                    ReplicationImpl.this.endpoint.process(new BloomFilterExecutable(range), new Continuation.StandardContinuation(this, this, handle, range, ourFilter){
                        private final /* synthetic */ NodeHandle val$handle;
                        private final /* synthetic */ IdRange val$range;
                        private final /* synthetic */ IdBloomFilter val$ourFilter;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$handle = val$handle;
                            this.val$range = val$range;
                            this.val$ourFilter = val$ourFilter;
                        }

                        public void receiveResult(Object o) {
                            IdBloomFilter filter = (IdBloomFilter)o;
                            RequestMessage request = new RequestMessage(1.access$000(this.this$1).handle, new IdRange[]{this.val$range, 1.access$100(this.this$1)}, new IdBloomFilter[]{filter, this.val$ourFilter});
                            1.access$000(this.this$1).endpoint.route(null, request, this.val$handle);
                        }
                    });
                }
                ReplicationImpl.this.log.finer(ReplicationImpl.this.endpoint.getId() + ": Done sending out requests with " + this.total + " objects");
            }

            static /* synthetic */ ReplicationImpl access$000(1 x0) {
                return x0.ReplicationImpl.this;
            }

            static /* synthetic */ IdRange access$100(1 x0) {
                return x0.ourRange;
            }
        });
    }

    public boolean forward(RouteMessage message) {
        return true;
    }

    public void deliver(Id id, Message message) {
        if (message instanceof RequestMessage) {
            final RequestMessage rm = (RequestMessage)message;
            Continuation.MultiContinuation continuation = new Continuation.MultiContinuation(new Continuation.ListenerContinuation("Processing of RequestMessage"){

                public void receiveResult(Object o) {
                    Object[] array = (Object[])o;
                    IdSet[] result = new IdSet[array.length];
                    System.arraycopy(array, 0, result, 0, array.length);
                    ReplicationImpl.this.endpoint.route(null, new ResponseMessage(ReplicationImpl.this.handle, rm.getRanges(), result), rm.getSource());
                }
            }, rm.getRanges().length);
            for (int i = 0; i < rm.getRanges().length; ++i) {
                final int j = i;
                this.endpoint.process(new Executable(){

                    public String toString() {
                        return "process " + j + " of " + rm.getRanges().length + " namespace " + ReplicationImpl.this.instance;
                    }

                    public Object execute() {
                        IdSet set = ReplicationImpl.this.factory.buildIdSet();
                        rm.getFilters()[j].check(ReplicationImpl.this.client.scan(rm.getRanges()[j]), set, MAX_KEYS_IN_MESSAGE);
                        return set;
                    }
                }, continuation.getSubContinuation(i));
            }
        } else if (message instanceof ResponseMessage) {
            ResponseMessage rm = (ResponseMessage)message;
            for (int i = 0; i < rm.getIdSets().length; ++i) {
                IdSet fetch = this.policy.difference(this.client.scan(rm.getRanges()[i]), rm.getIdSets()[i], this.factory);
                if (fetch.numElements() <= 0) continue;
                this.client.fetch(fetch, rm.getSource());
            }
        } else if (message instanceof ReminderMessage) {
            this.replicate();
            this.updateClient();
        } else {
            this.log.warning(this.endpoint.getId() + ": Received unknown message " + message + " - dropping on floor.");
        }
    }

    public void update(NodeHandle handle, boolean joined) {
        this.updateClient();
    }

    public static IdSet merge(IdFactory factory, IdSet a, IdSet b) {
        IdSet result = factory.buildIdSet();
        Iterator i = a.getIterator();
        while (i.hasNext()) {
            result.addId((Id)i.next());
        }
        i = b.getIterator();
        while (i.hasNext()) {
            result.addId((Id)i.next());
        }
        return result;
    }

    protected class BloomFilterExecutable
    implements Executable {
        protected IdRange range;

        public BloomFilterExecutable(IdRange range) {
            this.range = range;
        }

        public String toString() {
            return "bloomfilter range " + this.range + " namespace " + ReplicationImpl.this.instance;
        }

        public Object execute() {
            return new IdBloomFilter(ReplicationImpl.this.client.scan(this.range));
        }
    }
}

