/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.replication.manager;

import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import rice.Continuation;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.CancellableTask;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.IdSet;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.RouteMessage;
import rice.p2p.replication.Replication;
import rice.p2p.replication.ReplicationClient;
import rice.p2p.replication.ReplicationImpl;
import rice.p2p.replication.ReplicationPolicy;
import rice.p2p.replication.manager.ReplicationManager;
import rice.p2p.replication.manager.ReplicationManagerClient;
import rice.p2p.replication.manager.messaging.ReminderMessage;
import rice.p2p.replication.manager.messaging.TimeoutMessage;

public class ReplicationManagerImpl
implements ReplicationManager,
ReplicationClient,
Application {
    protected IdFactory factory;
    protected Endpoint endpoint;
    protected ReplicationImpl replication;
    protected ReplicationManagerClient client;
    protected ReplicationManagerHelper helper;
    protected ReplicationManagerDeleter deleter;
    protected Logger log = Logger.getLogger(this.getClass().getName());
    protected String instance;
    public static int FETCH_DELAY = 500;
    public static int TIMEOUT_DELAY = 20000;
    public static int NUM_DELETE_AT_ONCE = 100;

    public ReplicationManagerImpl(Node node, ReplicationManagerClient client, int replicationFactor, String instance) {
        this(node, client, replicationFactor, instance, null);
    }

    public ReplicationManagerImpl(Node node, ReplicationManagerClient client, int replicationFactor, String instance, ReplicationPolicy policy) {
        this.client = client;
        this.factory = node.getIdFactory();
        this.endpoint = node.registerApplication(this, instance);
        this.helper = new ReplicationManagerHelper();
        this.deleter = new ReplicationManagerDeleter();
        this.instance = instance;
        this.log.finer(this.endpoint.getId() + ": Starting up ReplicationManagerImpl with client " + client);
        this.replication = new ReplicationImpl(node, this, replicationFactor, instance, policy);
    }

    public Replication getReplication() {
        return this.replication;
    }

    public void setRange(IdRange range) {
        this.log.finest(this.endpoint.getId() + ": Removing range " + range + " from the list of pending ids");
        this.helper.setRange(range);
        this.deleter.setRange(range);
    }

    protected IdSet clone(IdSet keySet) {
        IdSet result = this.factory.buildIdSet();
        Iterator i = keySet.getIterator();
        while (i.hasNext()) {
            result.addId((Id)i.next());
        }
        return result;
    }

    protected void informClient(final Id id, NodeHandle hint) {
        this.log.fine(this.endpoint.getId() + ": Telling client to fetch id " + id);
        final CancellableTask timer = this.endpoint.scheduleMessage(new TimeoutMessage(id), TIMEOUT_DELAY);
        this.client.fetch(id, hint, new Continuation(){

            public void receiveResult(Object o) {
                if (!new Boolean(true).equals(o)) {
                    ReplicationManagerImpl.this.log.warning(ReplicationManagerImpl.this.endpoint.getId() + ": Fetching of id " + id + " failed with " + o);
                }
                ReplicationManagerImpl.this.log.fine(ReplicationManagerImpl.this.endpoint.getId() + ": Successfully fetched id " + id);
                timer.cancel();
                ReplicationManagerImpl.this.helper.message(id);
            }

            public void receiveException(Exception e) {
                this.receiveResult(e);
            }
        });
    }

    protected void scheduleNext() {
        this.log.finer(this.endpoint.getId() + ": Scheduling next fetch in " + FETCH_DELAY + " milliseconds");
        this.endpoint.scheduleMessage(new ReminderMessage(), FETCH_DELAY);
    }

    public void fetch(IdSet keySet, NodeHandle hint) {
        this.helper.fetch(keySet, hint);
    }

    public IdSet scan(IdRange range) {
        return this.client.scan(range);
    }

    public boolean forward(RouteMessage message) {
        return true;
    }

    public void deliver(Id id, Message message) {
        if (message instanceof ReminderMessage) {
            this.log.finest(this.endpoint.getId() + ": Received reminder message");
            this.helper.wakeup();
        } else if (message instanceof TimeoutMessage) {
            this.log.finest(this.endpoint.getId() + ": Received timeout message");
            this.helper.message(((TimeoutMessage)message).getId());
        } else {
            this.log.warning(this.endpoint.getId() + ": Received unknown message " + message);
        }
    }

    public void update(NodeHandle handle, boolean joined) {
    }

    protected class ReplicationManagerDeleter
    implements Continuation {
        protected IdSet set;
        protected Id id;

        public ReplicationManagerDeleter() {
            this.set = ReplicationManagerImpl.this.factory.buildIdSet();
        }

        public synchronized void setRange(IdRange range) {
            IdRange notRange = range.getComplementRange();
            Iterator i = ReplicationManagerImpl.this.client.scan(notRange).getIterator();
            for (int count = 0; i.hasNext() && count < NUM_DELETE_AT_ONCE; ++count) {
                Id next = (Id)i.next();
                if (this.id != null && this.id.equals(next)) continue;
                this.set.addId(next);
            }
            Iterator j = this.set.subSet(range).getIterator();
            while (j.hasNext()) {
                this.set.removeId((Id)j.next());
            }
            this.go();
        }

        protected synchronized void go() {
            if (this.id == null && this.set.numElements() > 0) {
                this.id = (Id)this.set.getIterator().next();
                this.set.removeId(this.id);
                ReplicationManagerImpl.this.log.finer(ReplicationManagerImpl.this.endpoint.getId() + ": Telling client to delete id " + this.id);
                System.out.println("RMImpl.go " + ReplicationManagerImpl.this.instance + ": removing id " + this.id);
                ReplicationManagerImpl.this.client.remove(this.id, this);
            }
        }

        public synchronized void receiveResult(Object o) {
            if (this.id == null) {
                System.out.println("ERROR: RMImpl.deleter Received result " + o + " unexpectedly!");
            }
            if (!Boolean.TRUE.equals(o)) {
                System.out.println("ERROR: RMImpl.deleter Unstore of " + this.id + " did not succeed '" + o + "'!");
            }
            this.id = null;
            this.go();
        }

        public synchronized void receiveException(Exception e) {
            System.out.println("ERROR: RMImpl.deleter Unstore of " + this.id + " caused exception '" + e + "'!");
            e.printStackTrace();
            this.id = null;
            this.go();
        }
    }

    protected class ReplicationManagerHelper {
        public int STATE_NOTHING = 0;
        public int STATE_WAITING = 1;
        public int STATE_SLEEPING = 2;
        protected int state;
        protected IdSet set;
        protected Id current;
        protected HashMap hints;

        public ReplicationManagerHelper() {
            this.set = ReplicationManagerImpl.this.factory.buildIdSet();
            this.hints = new HashMap();
            this.state = this.STATE_NOTHING;
        }

        protected synchronized Id getNextId() {
            if (this.set.numElements() == 0) {
                ReplicationManagerImpl.this.log.warning(ReplicationManagerImpl.this.endpoint.getId() + ": GetNextId called without any ids available - aborting");
                return null;
            }
            this.current = (Id)this.set.getIterator().next();
            this.set.removeId(this.current);
            ReplicationManagerImpl.this.log.finer(ReplicationManagerImpl.this.endpoint.getId() + ": Returing next id to fetch " + this.current);
            if (!ReplicationManagerImpl.this.client.exists(this.current)) {
                return this.current;
            }
            return this.getNextId();
        }

        public synchronized void setRange(IdRange range) {
            IdRange notRange = range.getComplementRange();
            Iterator i = this.set.subSet(notRange).getIterator();
            while (i.hasNext()) {
                Id id = (Id)i.next();
                this.set.removeId(id);
                this.hints.remove(id);
            }
        }

        public synchronized void fetch(IdSet keySet, NodeHandle hint) {
            Iterator i = keySet.getIterator();
            while (i.hasNext()) {
                Id id = (Id)i.next();
                if (this.set.isMemberId(id) || ReplicationManagerImpl.this.client.exists(id) || this.current != null && id.equals(this.current)) continue;
                this.set.addId(id);
                this.hints.put(id, hint);
            }
            if (this.state == this.STATE_NOTHING && this.set.numElements() > 0) {
                this.send();
            }
        }

        public IdSet scan(IdRange range) {
            return this.set.subSet(range);
        }

        protected synchronized void send() {
            if (this.state != this.STATE_WAITING && this.set.numElements() > 0) {
                Id id = this.getNextId();
                NodeHandle hint = (NodeHandle)this.hints.remove(id);
                if (id != null) {
                    this.state = this.STATE_WAITING;
                    ReplicationManagerImpl.this.informClient(id, hint);
                } else {
                    this.state = this.STATE_NOTHING;
                }
            } else if (this.state != this.STATE_WAITING) {
                this.state = this.STATE_NOTHING;
            }
        }

        public synchronized void wakeup() {
            if (this.state == this.STATE_SLEEPING) {
                this.send();
            }
        }

        public synchronized void message(Id id) {
            if (this.state == this.STATE_WAITING && this.current != null && this.current.equals(id)) {
                this.state = this.STATE_SLEEPING;
                this.current = null;
                ReplicationManagerImpl.this.scheduleNext();
            }
        }
    }
}

