/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.replication.manager.testing;

import java.util.Random;
import rice.Continuation;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.IdSet;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.testing.CommonAPITest;
import rice.p2p.replication.manager.ReplicationManagerClient;
import rice.p2p.replication.manager.ReplicationManagerImpl;

public class ReplicationManagerRegrTest
extends CommonAPITest {
    protected ReplicationManagerImpl[] replications = new ReplicationManagerImpl[NUM_NODES];
    protected TestReplicationManagerClient[] clients = new TestReplicationManagerClient[NUM_NODES];
    protected Random rng = new Random();
    public static int REPLICATION_FACTOR = 3;
    public static String INSTANCE = "ReplicationRegrTest";

    protected void processNode(int num, Node node) {
        this.clients[num] = new TestReplicationManagerClient(node);
        this.replications[num] = new ReplicationManagerImpl(node, this.clients[num], REPLICATION_FACTOR, INSTANCE);
    }

    protected void runTest() {
        for (int i = 0; i < NUM_NODES; ++i) {
            this.simulate();
        }
        this.testBasic();
        this.testOverload();
        this.testStress();
        this.testMaintenance();
    }

    public void testBasic() {
        int num = this.rng.nextInt(NUM_NODES);
        Id id = this.nodes[num].getId();
        IdRange all = FACTORY.buildIdRange(FACTORY.buildId(new byte[20]), FACTORY.buildId(new byte[20]));
        this.sectionStart("Testing Basic Functionality");
        this.stepStart("Inserting Object");
        this.clients[num].insert(id);
        this.stepDone("SUCCESS");
        this.stepStart("Initiating Maintenance");
        this.runMaintenance();
        for (int i = 0; i < NUM_NODES; ++i) {
            this.simulate();
        }
        int count = 0;
        for (int i = 0; i < NUM_NODES; ++i) {
            if (!this.clients[i].scan(all).isMemberId(id)) continue;
            ++count;
        }
        this.assertTrue("Correct number of replicas should be " + (REPLICATION_FACTOR + 1) + " was " + count, count == REPLICATION_FACTOR + 1);
        this.stepDone("SUCCESS");
        this.sectionDone();
    }

    public void testMaintenance() {
        int i;
        int num = this.rng.nextInt(NUM_NODES);
        Id id = this.nodes[num].getId();
        IdRange all = FACTORY.buildIdRange(FACTORY.buildId(new byte[20]), FACTORY.buildId(new byte[20]));
        this.sectionStart("Testing Basic Functionality");
        this.stepStart("Inserting Object");
        this.clients[num].insert(id);
        this.stepDone("SUCCESS");
        this.stepStart("Initiating Maintenance");
        this.runMaintenance();
        this.simulate();
        int count = 0;
        for (i = 0; i < NUM_NODES; ++i) {
            if (!this.clients[i].scan(all).isMemberId(id)) continue;
            ++count;
        }
        this.assertTrue("Correct number of replicas should be " + (REPLICATION_FACTOR + 1) + " was " + count, count == REPLICATION_FACTOR + 1);
        this.stepDone("SUCCESS");
        this.stepStart("Killing Primary Replica");
        this.kill(num);
        this.stepDone("SUCCESS");
        this.stepStart("Initiating Maintenance");
        this.runMaintenance();
        this.simulate();
        count = 0;
        for (i = 0; i < NUM_NODES; ++i) {
            if (!this.clients[i].scan(all).isMemberId(id)) continue;
            ++count;
        }
        this.assertTrue("Correct number of replicas should be " + (REPLICATION_FACTOR + 2) + " was " + count, count == REPLICATION_FACTOR + 2);
        this.stepDone("SUCCESS");
        this.sectionDone();
    }

    public void testOverload() {
        int i;
        int NUM_TO_INSERT = 16;
        int num = this.rng.nextInt(NUM_NODES);
        Id id = this.nodes[num].getId();
        IdRange all = FACTORY.buildIdRange(FACTORY.buildId(new byte[20]), FACTORY.buildId(new byte[20]));
        this.sectionStart("Testing Overload Functionality");
        this.stepStart("Inserting " + NUM_TO_INSERT + " Objects");
        for (i = 0; i < NUM_TO_INSERT; ++i) {
            this.clients[num].insert(this.addToId(id, i));
            this.simulate();
        }
        this.stepDone("SUCCESS");
        this.stepStart("Initiating Maintenance");
        this.runMaintenance();
        this.simulate();
        for (i = 0; i < NUM_TO_INSERT + 1; ++i) {
            try {
                Thread.sleep(ReplicationManagerImpl.FETCH_DELAY);
            }
            catch (InterruptedException e) {
                System.out.println(e.toString());
            }
            this.simulate();
        }
        for (int j = 0; j < NUM_TO_INSERT; ++j) {
            int count = 0;
            Id thisId = this.addToId(id, j);
            for (int i2 = 0; i2 < NUM_NODES; ++i2) {
                if (!this.clients[i2].scan(all).isMemberId(thisId)) continue;
                ++count;
            }
            this.assertTrue("Correct number of replicas for " + thisId + " should be " + (REPLICATION_FACTOR + 1) + " was " + count, count == REPLICATION_FACTOR + 1);
        }
        this.stepDone("SUCCESS");
        this.sectionDone();
    }

    public void testStress() {
        int NUM_TO_INSERT = 45;
        Id[] ids = new Id[NUM_TO_INSERT];
        int num = this.rng.nextInt(NUM_NODES);
        Id id = this.nodes[num].getId();
        IdRange all = FACTORY.buildIdRange(FACTORY.buildId(new byte[20]), FACTORY.buildId(new byte[20]));
        this.sectionStart("Testing Stressed Functionality");
        this.stepStart("Inserting " + NUM_TO_INSERT + " Objects");
        for (int i = 0; i < NUM_TO_INSERT; ++i) {
            ids[i] = this.addToId(id, i);
            this.clients[num].insert(ids[i]);
        }
        this.stepDone("SUCCESS");
        this.stepStart("Initiating Maintenance");
        this.runMaintenance();
        this.simulate();
        try {
            Thread.sleep(25000L);
        }
        catch (InterruptedException e) {
            System.out.println(e.toString());
        }
        this.simulate();
        for (int j = 0; j < NUM_TO_INSERT; ++j) {
            int count = 0;
            Id thisId = ids[j];
            for (int i = 0; i < NUM_NODES; ++i) {
                if (!this.clients[i].scan(all).isMemberId(thisId)) continue;
                ++count;
            }
            this.assertTrue("Correct number of replicas for " + j + " " + thisId + " should be " + (REPLICATION_FACTOR + 1) + " was " + count, count == REPLICATION_FACTOR + 1);
        }
        this.stepDone("SUCCESS");
        this.sectionDone();
    }

    public void runMaintenance() {
        for (int i = 0; i < NUM_NODES; ++i) {
            this.replications[i].getReplication().replicate();
        }
        this.simulate();
    }

    private Id generateId() {
        byte[] data = new byte[20];
        this.rng.nextBytes(data);
        return FACTORY.buildId(data);
    }

    private Id addToId(Id id, int num) {
        byte[] bytes = id.toByteArray();
        bytes[0] = (byte)(bytes[0] + num);
        return FACTORY.buildId(bytes);
    }

    public static void main(String[] args) {
        ReplicationManagerRegrTest.parseArgs(args);
        ReplicationManagerRegrTest test = new ReplicationManagerRegrTest();
        test.start();
    }

    protected class TestReplicationManagerClient
    implements ReplicationManagerClient {
        public Node node;
        public IdSet set;

        public TestReplicationManagerClient(Node node) {
            this.set = node.getIdFactory().buildIdSet();
            this.node = node;
        }

        public void fetch(Id id, NodeHandle hint, Continuation command) {
            this.set.addId(id);
            command.receiveResult(new Boolean(true));
        }

        public void remove(Id id, Continuation command) {
            this.set.removeId(id);
            command.receiveResult(new Boolean(true));
        }

        public IdSet scan(IdRange range) {
            return this.set.subSet(range);
        }

        public void insert(Id id) {
            this.set.addId(id);
        }

        public boolean exists(Id id) {
            return this.set.isMemberId(id);
        }
    }
}

