/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.replication.testing;

import java.util.Iterator;
import java.util.Random;
import rice.Continuation;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.IdSet;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.testing.CommonAPITest;
import rice.p2p.replication.ReplicationClient;
import rice.p2p.replication.ReplicationImpl;
import rice.persistence.MemoryStorage;

public class ReplicationRegrTest
extends CommonAPITest {
    protected ReplicationImpl[] replications = new ReplicationImpl[NUM_NODES];
    protected TestReplicationClient[] clients = new TestReplicationClient[NUM_NODES];
    protected Random rng = new Random();
    public static int REPLICATION_FACTOR = 3;
    public static String INSTANCE = "ReplicationRegrTest";

    protected void processNode(int num, Node node) {
        this.clients[num] = new TestReplicationClient(node);
        this.replications[num] = new ReplicationImpl(node, this.clients[num], REPLICATION_FACTOR, INSTANCE);
    }

    protected void runTest() {
        this.testBasic();
        this.testMaintenance();
    }

    public void testBasic() {
        int num = this.rng.nextInt(NUM_NODES);
        Id id = this.nodes[num].getId();
        IdRange all = FACTORY.buildIdRange(FACTORY.buildId(new byte[20]), FACTORY.buildId(new byte[20]));
        this.sectionStart("Testing Basic Functionality");
        this.stepStart("Inserting Object");
        this.clients[num].insert(id);
        this.stepDone("SUCCESS");
        this.stepStart("Initiating Maintenance");
        this.runMaintenance();
        this.simulate();
        int count = 0;
        for (int i = 0; i < NUM_NODES; ++i) {
            if (!this.clients[i].scan(all).isMemberId(id)) continue;
            ++count;
        }
        this.assertTrue("Correct number of replicas should be " + (REPLICATION_FACTOR + 1) + " was " + count, count == REPLICATION_FACTOR + 1);
        this.stepDone("SUCCESS");
        this.sectionDone();
    }

    public void testMaintenance() {
        int i;
        int num = this.rng.nextInt(NUM_NODES);
        Id id = this.nodes[num].getId();
        IdRange all = FACTORY.buildIdRange(FACTORY.buildId(new byte[20]), FACTORY.buildId(new byte[20]));
        this.sectionStart("Testing Basic Functionality");
        this.stepStart("Inserting Object");
        this.clients[num].insert(id);
        this.stepDone("SUCCESS");
        this.stepStart("Initiating Maintenance");
        this.runMaintenance();
        this.simulate();
        int count = 0;
        for (i = 0; i < NUM_NODES; ++i) {
            if (!this.clients[i].scan(all).isMemberId(id)) continue;
            ++count;
        }
        this.assertTrue("Correct number of replicas should be " + (REPLICATION_FACTOR + 1) + " was " + count, count == REPLICATION_FACTOR + 1);
        this.stepDone("SUCCESS");
        this.stepStart("Killing Primary Replica");
        this.kill(num);
        this.stepDone("SUCCESS");
        this.stepStart("Initiating Maintenance");
        this.runMaintenance();
        this.simulate();
        count = 0;
        for (i = 0; i < NUM_NODES; ++i) {
            if (!this.clients[i].scan(all).isMemberId(id)) continue;
            ++count;
        }
        this.assertTrue("Correct number of replicas should be " + (REPLICATION_FACTOR + 2) + " was " + count, count == REPLICATION_FACTOR + 2);
        this.stepDone("SUCCESS");
        this.sectionDone();
    }

    public void runMaintenance() {
        for (int i = 0; i < NUM_NODES; ++i) {
            this.replications[i].replicate();
        }
        this.simulate();
    }

    private Id generateId() {
        byte[] data = new byte[20];
        this.rng.nextBytes(data);
        return FACTORY.buildId(data);
    }

    public static void main(String[] args) {
        ReplicationRegrTest.parseArgs(args);
        ReplicationRegrTest test = new ReplicationRegrTest();
        test.start();
    }

    protected class TestReplicationClient
    implements ReplicationClient {
        public MemoryStorage storage = new MemoryStorage(CommonAPITest.FACTORY);
        public Node node;

        public TestReplicationClient(Node node) {
            this.node = node;
        }

        public void setRange(IdRange range) {
            IdRange notRange = range.getComplementRange();
            IdSet set = this.storage.scan(notRange);
            Iterator i = set.getIterator();
            while (i.hasNext()) {
                Id next = (Id)i.next();
                this.storage.unstore(next, new Continuation.ListenerContinuation("Removal of " + next));
            }
        }

        public void fetch(IdSet keySet, NodeHandle hint) {
            Iterator i = keySet.getIterator();
            while (i.hasNext()) {
                Id next = (Id)i.next();
                this.storage.store(next, null, next, new Continuation.ListenerContinuation("Insertion of " + next));
            }
        }

        public IdSet scan(IdRange range) {
            return this.storage.scan(range);
        }

        public void insert(Id id) {
            this.storage.store(id, null, id, new Continuation.ListenerContinuation("Insertion of id " + id));
        }
    }
}

