/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.splitstream;

import java.math.BigInteger;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.scribe.Scribe;
import rice.p2p.splitstream.ChannelId;
import rice.p2p.splitstream.SplitStreamScribePolicy;
import rice.p2p.splitstream.Stripe;
import rice.p2p.splitstream.StripeId;

public class Channel {
    protected ChannelId channelId;
    protected Stripe[] stripes;
    protected Id localId;
    public static int STRIPE_BASE = 4;

    public Channel(ChannelId channelId, Scribe scribe, IdFactory factory, Id localId) {
        this.channelId = channelId;
        this.localId = localId;
        StripeId[] stripeIds = Channel.generateStripeIds(channelId, factory);
        this.stripes = new Stripe[stripeIds.length];
        for (int i = 0; i < stripeIds.length; ++i) {
            this.stripes[i] = new Stripe(stripeIds[i], scribe, this);
        }
    }

    public Id getLocalId() {
        return this.localId;
    }

    public ChannelId getChannelId() {
        return this.channelId;
    }

    public Stripe[] getStripes() {
        return this.stripes;
    }

    protected Stripe getPrimaryStripe() {
        for (int i = 0; i < this.stripes.length; ++i) {
            if (SplitStreamScribePolicy.getPrefixMatch(this.localId, this.stripes[i].getStripeId().getId()) <= 0) continue;
            return this.stripes[i];
        }
        return null;
    }

    protected static StripeId[] generateStripeIds(ChannelId id, IdFactory factory) {
        int num = (int)Math.pow(2.0, STRIPE_BASE);
        StripeId[] stripeIds = new StripeId[num];
        for (int i = 0; i < num; ++i) {
            byte[] array = id.getId().toByteArray();
            stripeIds[i] = new StripeId(factory.buildId(Channel.process(array, STRIPE_BASE, i)));
        }
        return stripeIds;
    }

    private static byte[] process(byte[] array, int base, int num) {
        int length = array.length * 8;
        BigInteger bNum = new BigInteger(num + "");
        bNum = bNum.shiftLeft(length - base);
        BigInteger bArray = new BigInteger(1, Channel.switchEndian(array));
        for (int i = length - 1; i > length - base - 1; --i) {
            bArray = bNum.testBit(i) ? bArray.setBit(i) : bArray.clearBit(i);
        }
        byte[] newArray = bArray.toByteArray();
        byte[] result = new byte[array.length];
        if (newArray.length <= array.length) {
            System.arraycopy(newArray, 0, result, result.length - newArray.length, newArray.length);
        } else {
            System.arraycopy(newArray, newArray.length - array.length, result, 0, array.length);
        }
        return Channel.switchEndian(result);
    }

    private static byte[] switchEndian(byte[] array) {
        byte[] result = new byte[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array[result.length - 1 - i];
        }
        return result;
    }
}

