/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.splitstream.testing;

import java.util.Random;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.testing.CommonAPITest;
import rice.p2p.splitstream.Channel;
import rice.p2p.splitstream.ChannelId;
import rice.p2p.splitstream.SplitStream;
import rice.p2p.splitstream.SplitStreamClient;
import rice.p2p.splitstream.SplitStreamImpl;
import rice.p2p.splitstream.SplitStreamScribePolicy;
import rice.p2p.splitstream.Stripe;
import rice.pastry.PastrySeed;

public class SplitStreamRegrTest
extends CommonAPITest {
    protected SplitStreamImpl[] splitstreams = new SplitStreamImpl[NUM_NODES];
    protected SplitStreamTestClient[] ssclients = new SplitStreamTestClient[NUM_NODES];
    protected Random rng = new Random(PastrySeed.getSeed() + 2);
    protected Random generateIdRng = new Random(PastrySeed.getSeed() + 3);
    public static String INSTANCE = "SplitStreamRegrTest";

    protected void processNode(int num, Node node) {
        this.splitstreams[num] = new SplitStreamImpl(node, INSTANCE);
        this.ssclients[num] = new SplitStreamTestClient(node, this.splitstreams[num]);
    }

    protected void runTest() {
        if (NUM_NODES < 2) {
            System.out.println("The DistScribeRegrTest must be run with at least 2 nodes for proper testing.  Use the '-nodes n' to specify the number of nodes.");
            return;
        }
        this.testBasic();
        this.testBandwidthUsage();
        this.testIndependence();
        this.testMaintenance(NUM_NODES / 10);
    }

    protected void testBandwidthUsage() {
        boolean result = true;
        int count = 0;
        int total = 0;
        this.sectionStart("BandwidthUsage Test");
        this.stepStart("Usage");
        this.simulate();
        for (int i = 0; i < NUM_NODES; ++i) {
            Channel channel = this.ssclients[i].getChannel();
            count = this.splitstreams[i].getPolicy().getTotalChildren(channel);
            if (count > SplitStreamScribePolicy.DEFAULT_MAXIMUM_CHILDREN) {
                result = false;
            }
            total += count;
        }
        if (result && total <= (NUM_NODES - 1) * SplitStreamScribePolicy.DEFAULT_MAXIMUM_CHILDREN) {
            this.stepDone("SUCCESS");
        } else {
            this.stepDone("FAILURE");
        }
        this.sectionDone();
    }

    protected void testIndependence() {
        int i;
        boolean result = true;
        int count = 0;
        int num = 0;
        int[] array = new int[20];
        this.sectionStart("Path Independence Test");
        this.stepStart("Usage");
        this.simulate();
        for (i = 0; i < NUM_NODES; ++i) {
            Channel channel = this.ssclients[i].getChannel();
            Stripe[] stripes = channel.getStripes();
            num = 0;
            for (int j = 0; j < stripes.length; ++j) {
                count = stripes[j].getChildren().length;
                if (count <= 0) continue;
                ++num;
            }
            int n = num;
            array[n] = array[n] + 1;
        }
        for (i = 0; i < 20; ++i) {
            System.out.println(i + "\t" + array[i]);
        }
        this.sectionDone();
    }

    protected void testMaintenance(int num) {
        this.sectionStart("Maintenance of multicast trees");
        this.stepStart("Killing Nodes");
        for (int i = 0; i < num; ++i) {
            System.out.println("Killing " + this.ssclients[i].getId());
            this.kill(i);
            this.simulate();
        }
        if (this.checkTree(num, NUM_NODES)) {
            this.stepDone("SUCCESS");
        } else {
            this.stepDone("FAILURE", "not all have parent");
        }
        this.stepStart("Tree Recovery");
        byte[] data = new byte[]{0, 1, 0, 1, 1};
        boolean pass = true;
        for (int i = 0; i < 10; ++i) {
            this.ssclients[this.rng.nextInt(NUM_NODES - num) + num].publishAll(data);
            this.simulate();
            int totalmsgs = 0;
            for (int j = 0; j < NUM_NODES - num; ++j) {
                totalmsgs += this.ssclients[j + num].getNumMesgs();
                if (this.ssclients[j + num].getNumMesgs() != 16) {
                    System.out.println(this.ssclients[i + num].getId() + " recived " + this.ssclients[i + num].getNumMesgs());
                }
                this.ssclients[j + num].reset();
            }
            if (totalmsgs == (NUM_NODES - num) * 16) continue;
            pass = false;
        }
        if (pass) {
            this.stepDone("SUCCESS");
        } else {
            this.stepDone("FAILURE");
        }
        this.sectionDone();
    }

    protected void testBasic() {
        int i;
        this.sectionStart("Basic Test");
        this.stepStart("Creating Channel");
        int creator = this.rng.nextInt(NUM_NODES);
        ChannelId id = new ChannelId(this.generateId());
        this.ssclients[creator].createChannel(id);
        this.simulate();
        this.stepDone("SUCCESS");
        this.stepStart("Attaching and Joining Stripes");
        for (i = 0; i < NUM_NODES; ++i) {
            this.ssclients[i].attachChannel(id);
            this.simulate();
        }
        for (i = 0; i < NUM_NODES; ++i) {
            this.ssclients[i].getStripes();
            this.simulate();
        }
        for (i = 0; i < NUM_NODES; ++i) {
            this.ssclients[i].subscribeStripes();
            this.simulate();
        }
        if (this.checkTree(0, NUM_NODES)) {
            this.stepDone("SUCCESS");
        } else {
            this.stepDone("FAILURE", "not all stripes have a parent");
        }
        this.stepStart("Sending Data");
        byte[] data = new byte[]{0, 1, 0, 1, 1};
        this.ssclients[creator].publishAll(data);
        this.simulate();
        this.ssclients[creator].publishAll(new byte[0]);
        this.simulate();
        int totalmsgs = 0;
        for (int i2 = 0; i2 < NUM_NODES; ++i2) {
            totalmsgs += this.ssclients[i2].getNumMesgs();
            this.ssclients[i2].reset();
        }
        if (totalmsgs == NUM_NODES * 16 * 2) {
            this.stepDone("SUCCESS");
        } else {
            this.stepDone("FAILURE", "Expected " + NUM_NODES * 16 * 2 + " messages, got " + totalmsgs);
        }
        this.sectionDone();
        this.testFailure(1);
    }

    protected boolean checkTree(int startindex, int num) {
        boolean result = true;
        for (int i = startindex; i < num; ++i) {
            Stripe[] stripes = this.ssclients[i].getStripes();
            for (int j = 0; j < stripes.length; ++j) {
                if (stripes[j].getParent() != null || stripes[j].isRoot()) continue;
                result = false;
                System.out.println("Node " + this.ssclients[i].getId() + " is parent less for topic " + stripes[j].getStripeId().getId());
            }
        }
        return result;
    }

    protected void testFailure(int numnodes) {
        this.sectionStart("Failure Test");
        this.sectionDone();
    }

    private Id generateId() {
        byte[] data = new byte[20];
        this.generateIdRng.nextBytes(data);
        return FACTORY.buildId(data);
    }

    public static void main(String[] args) {
        int seed = (int)System.currentTimeMillis();
        PastrySeed.setSeed(seed);
        System.out.println("Seed= " + PastrySeed.getSeed());
        SplitStreamRegrTest.parseArgs(args);
        SplitStreamRegrTest splitstreamTest = new SplitStreamRegrTest();
        splitstreamTest.start();
    }

    private class SplitStreamTestClient
    implements SplitStreamClient {
        private Node n = null;
        private Stripe[] stripes;
        private Channel channel;
        private SplitStream ss;
        private int numMesgsReceived = 0;
        private SplitStreamScribePolicy policy = null;

        public SplitStreamTestClient(Node n, SplitStream ss) {
            this.n = n;
            this.ss = ss;
            this.log("Client Created " + n);
        }

        public Channel getChannel() {
            return this.channel;
        }

        public Stripe[] getStripes() {
            this.log("Retrieving Stripes.");
            this.stripes = this.channel.getStripes();
            return this.stripes;
        }

        public int getNumMesgs() {
            return this.numMesgsReceived;
        }

        public Id getId() {
            return this.channel.getLocalId();
        }

        public void joinFailed(Stripe s) {
            this.log("Join Failed on " + s);
        }

        public void deliver(Stripe s, byte[] data) {
            this.log("Data recieved on " + s);
            ++this.numMesgsReceived;
        }

        public void createChannel(ChannelId cid) {
            this.log("Channel " + cid + " created.");
            this.channel = this.ss.createChannel(cid);
        }

        public void attachChannel(ChannelId cid) {
            this.log("Attaching to Channel " + cid + ".");
            if (this.channel == null) {
                this.channel = this.ss.attachChannel(cid);
            }
        }

        public void subscribeStripes() {
            this.log("Subscribing to all Stripes.");
            for (int i = 0; i < this.stripes.length; ++i) {
                this.stripes[i].subscribe(this);
            }
        }

        public void publishAll(byte[] b) {
            this.log("Publishing to all Stripes.");
            for (int i = 0; i < this.stripes.length; ++i) {
                this.publish(b, this.stripes[i]);
            }
        }

        public void publish(byte[] b, Stripe s) {
            this.log("Publishing to " + s);
            s.publish(b);
        }

        public void reset() {
            this.numMesgsReceived = 0;
        }

        private void log(String s) {
        }
    }
}

