/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.util;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PublicKey;
import rice.p2p.util.SecurityUtils;

public class EncryptedOutputStream
extends OutputStream {
    protected PublicKey publicKey;
    protected byte[] key;
    protected DataOutputStream stream;
    protected byte[] buffer;
    protected int bufferLength;
    public static final int BUFFER_SIZE = 32678;

    public EncryptedOutputStream(PublicKey publicKey, OutputStream stream) throws IOException {
        this.publicKey = publicKey;
        this.stream = new DataOutputStream(stream);
        this.key = SecurityUtils.generateKeySymmetric();
        this.buffer = new byte[32678];
        this.bufferLength = 0;
        this.writeHeader();
    }

    private void writeHeader() throws IOException {
        byte[] enckey = SecurityUtils.encryptAsymmetric(this.key, this.publicKey);
        this.stream.writeInt(enckey.length);
        this.stream.write(enckey);
    }

    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)(b & 0xFF)});
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (len <= 32678 - this.bufferLength) {
            System.arraycopy(b, off, this.buffer, this.bufferLength, len);
            this.bufferLength += len;
        } else {
            int l = 32678 - this.bufferLength;
            System.arraycopy(b, off, this.buffer, this.bufferLength, l);
            this.bufferLength += l;
            this.writeBuffer();
            this.write(b, off + l, len - l);
        }
    }

    protected void writeBuffer() throws IOException {
        byte[] encdata = SecurityUtils.encryptSymmetric(this.buffer, this.key, 0, this.bufferLength);
        this.stream.writeInt(encdata.length);
        this.stream.write(encdata);
        this.bufferLength = 0;
    }

    public void flush() throws IOException {
        this.writeBuffer();
        this.stream.flush();
    }

    public void close() throws IOException {
        this.flush();
        this.stream.close();
    }
}

