/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.util;

import java.io.Serializable;
import java.util.Iterator;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdSet;
import rice.p2p.util.BloomFilter;

public class IdBloomFilter
implements Serializable {
    protected transient byte[] array;
    protected BloomFilter filter;
    private static final long serialVersionUID = -9122948172786936161L;
    public static int NUM_BITS_PER_KEY = 4;
    public static int NUM_HASH_FUNCTIONS = 2;

    public IdBloomFilter(IdSet set) {
        this.filter = new BloomFilter(NUM_HASH_FUNCTIONS, NUM_BITS_PER_KEY * set.numElements());
        Iterator i = set.getIterator();
        while (i.hasNext()) {
            this.addId((Id)i.next());
        }
    }

    protected void checkArray(Id id) {
        if (this.array == null) {
            this.array = id.toByteArray();
        } else {
            id.toByteArray(this.array, 0);
        }
    }

    protected void addId(Id id) {
        this.checkArray(id);
        this.filter.add(this.array);
    }

    public boolean check(Id id) {
        this.checkArray(id);
        return this.filter.check(this.array);
    }

    public void check(IdSet set, IdSet result, int max) {
        Iterator it = set.getIterator();
        int count = 0;
        while (it.hasNext() && count < max) {
            Id next = (Id)it.next();
            if (this.check(next)) continue;
            result.addId(next);
            ++count;
        }
    }
}

