/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.util;

import java.util.Random;

public class MathUtils {
    public static final char[] HEX_ARRAY = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static Random random = new Random();

    private MathUtils() {
    }

    public static int mod(int a, int b) {
        return (a % b + b) % b;
    }

    public static byte[] xor(byte[] a, byte[] b) {
        byte[] result = new byte[a.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)(a[i] ^ b[i]);
        }
        return result;
    }

    public static byte[] randomBytes(int len) {
        byte[] result = new byte[len];
        random.nextBytes(result);
        return result;
    }

    public static int randomInt() {
        return random.nextInt();
    }

    public static String toHex(byte[] text) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < text.length; ++i) {
            buffer.append(HEX_ARRAY[0xF & text[i] >> 4]);
            buffer.append(HEX_ARRAY[0xF & text[i]]);
        }
        return buffer.toString();
    }

    public static byte[] intToByteArray(int input) {
        byte[] output = new byte[4];
        MathUtils.intToByteArray(input, output, 0);
        return output;
    }

    public static void intToByteArray(int input, byte[] output, int offset) {
        output[offset + 0] = (byte)(0xFF & input >> 24);
        output[offset + 1] = (byte)(0xFF & input >> 16);
        output[offset + 2] = (byte)(0xFF & input >> 8);
        output[offset + 3] = (byte)(0xFF & input);
    }

    public static int byteArrayToInt(byte[] input) {
        input = MathUtils.correctLength(input, 4);
        return input[0] << 24 | input[1] << 16 | input[2] << 8 | input[3];
    }

    public static byte[] longToByteArray(long input) {
        byte[] output = new byte[8];
        MathUtils.longToByteArray(input, output, 0);
        return output;
    }

    public static void longToByteArray(long input, byte[] output, int offset) {
        output[offset + 0] = (byte)(0xFFL & input >> 56);
        output[offset + 1] = (byte)(0xFFL & input >> 48);
        output[offset + 2] = (byte)(0xFFL & input >> 40);
        output[offset + 3] = (byte)(0xFFL & input >> 32);
        output[offset + 4] = (byte)(0xFFL & input >> 24);
        output[offset + 5] = (byte)(0xFFL & input >> 16);
        output[offset + 6] = (byte)(0xFFL & input >> 8);
        output[offset + 7] = (byte)(0xFFL & input);
    }

    public static long byteArrayToLong(byte[] input) {
        input = MathUtils.correctLength(input, 8);
        return input[0] << 56 | input[1] << 48 | input[2] << 40 | input[3] << 32 | input[4] << 24 | input[5] << 16 | input[6] << 8 | input[7];
    }

    private static byte[] correctLength(byte[] data, int length) {
        if (data.length >= length) {
            return data;
        }
        byte[] result = new byte[length];
        for (int i = 0; i < data.length && i < result.length; ++i) {
            result[i] = data[i];
        }
        return result;
    }
}

