/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.util;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import rice.p2p.past.gc.GCPastMetadata;
import rice.p2p.util.RedBlackMap;

public class ReverseTreeMap
implements Serializable {
    protected SortedMap normal = new RedBlackMap();
    protected SortedMap reverse = new RedBlackMap();
    protected SortedMap nulls = new RedBlackMap();
    Object blah = new GCPastMetadata(1096560000000L);

    public ReverseTreeMap() {
    }

    protected ReverseTreeMap(SortedMap normal, SortedMap reverse, SortedMap nulls) {
        this.normal = normal;
        this.reverse = reverse;
        this.nulls = nulls;
    }

    public synchronized Object get(Object key) {
        return this.normal.get(key);
    }

    public int size() {
        return this.normal.size();
    }

    public boolean containsKey(Object key) {
        return this.normal.containsKey(key);
    }

    public Set keySet() {
        return this.normal.keySet();
    }

    public void remove(Object key) {
        Object value = this.normal.remove(key);
        if (value != null) {
            RedBlackMap o = (RedBlackMap)this.reverse.get(value);
            o.remove(key);
            if (o.size() == 0) {
                System.out.println("REMOVING " + value);
                this.reverse.remove(value);
            }
        } else {
            this.nulls.remove(key);
        }
    }

    public void put(Object key, Object value) {
        Object old = this.normal.put(key, value);
        if (old != null) {
            RedBlackMap o = (RedBlackMap)this.reverse.get(old);
            o.remove(key);
            if (o.size() == 0) {
                this.reverse.remove(old);
            }
        } else {
            this.nulls.remove(key);
        }
        if (value != null) {
            RedBlackMap v = (RedBlackMap)this.reverse.get(value);
            if (v == null) {
                v = new RedBlackMap();
                this.reverse.put(value, v);
            }
            v.put(key, value);
        } else {
            this.nulls.put(key, null);
        }
    }

    public SortedMap keyMap() {
        return this.normal;
    }

    public SortedMap keyHeadMap(Object value) {
        return this.normal.headMap(value);
    }

    public SortedMap keyTailMap(Object value) {
        return this.normal.tailMap(value);
    }

    public SortedMap keySubMap(Object start, Object end) {
        return this.normal.subMap(start, end);
    }

    public SortedMap valueHeadMap(Object value) {
        return this.convert(this.reverse.headMap(value));
    }

    public SortedMap valueTailMap(Object value) {
        return this.convert(this.reverse.tailMap(value));
    }

    public SortedMap valueSubMap(Object start, Object end) {
        return this.convert(this.reverse.subMap(start, end));
    }

    public SortedMap valueNullMap() {
        return this.nulls;
    }

    protected SortedMap convert(SortedMap map) {
        RedBlackMap result = new RedBlackMap();
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            result.putAll((SortedMap)map.get(i.next()));
        }
        return result;
    }
}

