/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import rice.p2p.util.SoftHashMap;
import rice.p2p.util.XMLWriter;

public class XMLObjectOutputStream
extends ObjectOutputStream {
    protected XMLWriter writer;
    protected Hashtable references;
    protected int next = 0;
    protected Stack currentObjects;
    protected Stack currentClasses;
    protected Stack currentPutFields;
    protected static SoftHashMap WRITE_REPLACES = new SoftHashMap();
    protected static SoftHashMap WRITE_OBJECTS = new SoftHashMap();
    protected static SoftHashMap PERSISTENT_FIELDS = new SoftHashMap();
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$io$ObjectOutputStream;

    public XMLObjectOutputStream(OutputStream out) throws IOException {
        this.writer = new XMLWriter(out);
        this.references = new Hashtable();
        this.currentObjects = new Stack();
        this.currentClasses = new Stack();
        this.currentPutFields = new Stack();
        this.writeStreamHeader();
    }

    private Method getWriteReplace(Class cl) {
        Class defCl;
        if (WRITE_REPLACES.containsKey(cl)) {
            return (Method)WRITE_REPLACES.get(cl);
        }
        Method meth = null;
        for (defCl = cl; defCl != null; defCl = defCl.getSuperclass()) {
            try {
                meth = defCl.getDeclaredMethod("writeReplace", new Class[0]);
                break;
            }
            catch (NoSuchMethodException ex) {
                continue;
            }
        }
        if (meth == null) {
            WRITE_REPLACES.put(cl, meth);
            return null;
        }
        meth.setAccessible(true);
        int mods = meth.getModifiers();
        if ((mods & 0x408) == 0) {
            if ((mods & 5) != 0) {
                WRITE_REPLACES.put(cl, meth);
                return meth;
            }
            if ((mods & 2) != 0) {
                if (cl == defCl) {
                    WRITE_REPLACES.put(cl, meth);
                    return meth;
                }
            } else {
                WRITE_REPLACES.put(cl, meth);
                return meth;
            }
        }
        WRITE_REPLACES.put(cl, (Object)null);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Field[] getPersistentFields(Class cl) {
        SoftHashMap softHashMap = PERSISTENT_FIELDS;
        synchronized (softHashMap) {
            if (PERSISTENT_FIELDS.containsKey(cl)) {
                return (Field[])PERSISTENT_FIELDS.get(cl);
            }
            Field[] fields = this.getSerialPersistentFields(cl);
            if (fields == null) {
                fields = cl.getDeclaredFields();
            }
            PERSISTENT_FIELDS.put(cl, fields);
            return fields;
        }
    }

    protected Field[] getSerialPersistentFields(Class c) {
        try {
            Field f = c.getDeclaredField("serialPersistentFields");
            int mask = 26;
            if ((f.getModifiers() & mask) != mask) {
                return null;
            }
            f.setAccessible(true);
            ObjectStreamField[] serialPersistentFields = (ObjectStreamField[])f.get(null);
            Field[] fields = new Field[serialPersistentFields.length];
            for (int i = 0; i < serialPersistentFields.length; ++i) {
                ObjectStreamField spf = serialPersistentFields[i];
                Field thisf = c.getDeclaredField(spf.getName());
                if (thisf.getType() != spf.getType() || (thisf.getModifiers() & 8) != 0) {
                    return null;
                }
                fields[i] = thisf;
            }
            return fields;
        }
        catch (NoSuchFieldException ex) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    protected Class getComponentType(Class array) {
        if (array.isArray()) {
            return this.getComponentType(array.getComponentType());
        }
        return array;
    }

    protected int getDimension(Class array) {
        if (array.isArray()) {
            return 1 + this.getDimension(array.getComponentType());
        }
        return 0;
    }

    protected Class[] getSuperClasses(Class c) {
        Vector v = new Vector();
        while (!c.getSuperclass().equals(new Object().getClass())) {
            c = c.getSuperclass();
            v.addElement(c);
        }
        return v.toArray(new Class[0]);
    }

    protected String getReference(Object o) {
        return (String)this.references.get(new Reference(o));
    }

    protected void writeStreamHeader() throws IOException {
        this.writer.writeHeader();
        this.writer.start("jsx");
        this.writer.attribute("major", 1);
        this.writer.attribute("minor", 1);
        this.writer.attribute("format", "JSX.DataReader");
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void close() throws IOException {
        this.writer.end("jsx");
        this.writer.close();
    }

    public void reset() throws IOException {
        if (this.currentObjects.peek() != null) {
            throw new IOException("Reset called during active write!");
        }
        this.references = new Hashtable();
        this.writeReset();
    }

    public void write(byte b) throws IOException {
        this.writeByte(b);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int offset, int length) throws IOException {
        this.writer.start("base64");
        this.writer.attribute("length", length);
        this.writer.writeBase64(b, offset, length);
        this.writer.end("base64");
    }

    public void writeInt(int i) throws IOException {
        this.writePrimitive(i, (String)null);
    }

    public void writeBoolean(boolean b) throws IOException {
        this.writePrimitive(b, null);
    }

    public void writeByte(int i) throws IOException {
        this.writeByte((byte)i);
    }

    public void writeByte(byte b) throws IOException {
        this.writePrimitive(b, (String)null);
    }

    public void writeChar(int i) throws IOException {
        this.writeChar((char)i);
    }

    public void writeChar(char c) throws IOException {
        this.writePrimitive(c, (String)null);
    }

    public void writeDouble(double d) throws IOException {
        this.writePrimitive(d, null);
    }

    public void writeFloat(float f) throws IOException {
        this.writePrimitive(f, (String)null);
    }

    public void writeLong(long l) throws IOException {
        this.writePrimitive(l, (String)null);
    }

    public void writeShort(int i) throws IOException {
        this.writeShort((short)i);
    }

    public void writeShort(short s) throws IOException {
        this.writePrimitive(s, (String)null);
    }

    public void writeUTF(String s) throws IOException {
        this.writeObject(s);
    }

    public void writeChars(String s) throws IOException {
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            this.writeChar(chars[i]);
        }
    }

    public void writeBytes(String s) throws IOException {
        byte[] bytes = s.getBytes();
        for (int i = 0; i < bytes.length; ++i) {
            this.writeByte(bytes[i]);
        }
    }

    public void writeObjectOverride(Object o) throws IOException {
        this.writeObject(o, null);
    }

    public void writeUnshared(Object o) throws IOException {
        this.writeObjectUnshared(o, null, false);
    }

    public void defaultWriteObject() throws IOException {
        if (this.currentObjects.peek() == null) {
            throw new NotActiveException();
        }
        this.writeFields(this.currentObjects.peek(), (Class)this.currentClasses.peek());
    }

    public ObjectOutputStream.PutField putFields() throws IOException {
        if (this.currentPutFields.peek() != null) {
            return (PutField)this.currentPutFields.peek();
        }
        throw new NotActiveException();
    }

    public void writeFields() throws IOException {
        if (this.currentObjects.peek() == null) {
            throw new NotActiveException();
        }
        this.writePutFields((PutField)this.putFields());
    }

    protected int hash(Object o) {
        return System.identityHashCode(o) & Integer.MAX_VALUE;
    }

    protected void putReference(Object o, String reference) {
        Reference ref = new Reference(o);
        if (this.references.get(ref) == null) {
            this.references.put(ref, reference);
        } else {
            System.out.println("SERIOUS ERROR: Attempt to re-store reference: EXISTING: " + ((Reference)this.references.get(ref)).object + " " + this.references.get(ref).hashCode() + "NEW: " + o + " " + o.hashCode());
        }
    }

    protected String assignReference() {
        return "i" + this.next++;
    }

    protected void writeReset() throws IOException {
        this.writer.start("reset");
        this.writer.end("reset");
    }

    protected void writeObject(Object o, String field) throws IOException {
        if (o == null) {
            this.writeNull(field);
        } else if (this.getReference(o) != null) {
            this.writeReference(o, field);
        } else {
            this.writeObjectUnshared(o, field, true);
        }
    }

    protected void writeObjectUnshared(Object o, String field, boolean shared) throws IOException {
        Method replace = this.getWriteReplace(o.getClass());
        if (replace != null) {
            try {
                o = replace.invoke(o, new Object[0]);
                if (o == null) {
                    this.writeNull(field);
                    return;
                }
                if (this.getReference(o) != null) {
                    this.writeReference(o, field);
                    return;
                }
            }
            catch (IllegalAccessException e) {
                throw new IOException("IllegalAccessException thrown! " + e);
            }
            catch (InvocationTargetException e) {
                throw new IOException("InvocationTargetException thrown! " + e.getTargetException());
            }
        }
        if (shared) {
            this.putReference(o, this.assignReference());
        }
        if (o instanceof String) {
            this.writeString((String)o, field, shared);
        } else if (o.getClass().isArray()) {
            this.writeArray(o, field, shared);
        } else {
            this.writeOrdinaryObject(o, field, shared);
        }
    }

    protected void writeNull(String field) throws IOException {
        this.writer.start("null");
        if (field != null) {
            this.writer.attribute("field", field);
        }
        this.writer.end("null");
    }

    protected void writeString(String s, String field, boolean shared) throws IOException {
        this.writer.start("string");
        if (field != null) {
            this.writer.attribute("field", field);
        }
        if (shared && this.getReference(s) != null) {
            this.writer.attribute("id", this.getReference(s));
        }
        this.writer.attribute("value", s);
        this.writer.end("string");
    }

    protected void writeArray(Object o, String field, boolean shared) throws IOException {
        this.writer.start("array");
        if (field != null) {
            this.writer.attribute("field", field);
        }
        if (shared && this.getReference(o) != null) {
            this.writer.attribute("id", this.getReference(o));
        }
        this.writer.attribute("base", o.getClass().getComponentType().getName());
        this.writer.attribute("dim", this.getDimension(o.getClass()));
        this.writer.attribute("length", Array.getLength(o));
        if (o.getClass().getComponentType().isPrimitive()) {
            Class<?> c = o.getClass().getComponentType();
            for (int i = 0; i < Array.getLength(o); ++i) {
                if (c.equals(Integer.TYPE)) {
                    this.writePrimitive(Array.getInt(o, i), (String)null);
                    continue;
                }
                if (c.equals(Boolean.TYPE)) {
                    this.writePrimitive(Array.getBoolean(o, i), null);
                    continue;
                }
                if (c.equals(Byte.TYPE)) {
                    this.writePrimitive(Array.getByte(o, i), (String)null);
                    continue;
                }
                if (c.equals(Character.TYPE)) {
                    this.writePrimitive(Array.getChar(o, i), (String)null);
                    continue;
                }
                if (c.equals(Double.TYPE)) {
                    this.writePrimitive(Array.getDouble(o, i), null);
                    continue;
                }
                if (c.equals(Float.TYPE)) {
                    this.writePrimitive(Array.getFloat(o, i), (String)null);
                    continue;
                }
                if (c.equals(Long.TYPE)) {
                    this.writePrimitive(Array.getLong(o, i), (String)null);
                    continue;
                }
                if (c == Short.TYPE) {
                    this.writePrimitive(Array.getShort(o, i), (String)null);
                    continue;
                }
                throw new IllegalArgumentException("Class " + c + " is not primitive!");
            }
        } else {
            for (int i = 0; i < Array.getLength(o); ++i) {
                if (Array.get(o, i) instanceof Serializable) {
                    this.writeObject(Array.get(o, i), null);
                    continue;
                }
                this.writeNull(null);
            }
        }
        this.writer.end("array");
    }

    protected void writeReference(Object o, String field) throws IOException {
        this.writer.start("reference");
        if (field != null) {
            this.writer.attribute("field", field);
        }
        this.writer.attribute("idref", this.getReference(o));
        this.writer.end("reference");
    }

    protected void writeOrdinaryObject(Object o, String field, boolean shared) throws IOException {
        int i;
        if (!(class$java$io$Serializable == null ? (class$java$io$Serializable = XMLObjectOutputStream.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(o.getClass())) {
            if (field == null) {
                throw new NotSerializableException(o.getClass().getName() + " " + field + " " + shared);
            }
            return;
        }
        this.writer.start("object");
        if (shared && this.getReference(o) != null) {
            this.writer.attribute("id", this.getReference(o));
        }
        if (field != null) {
            this.writer.attribute("field", field);
        }
        this.writer.attribute("class", o.getClass().getName());
        StringBuffer classes = new StringBuffer();
        Class[] supers = this.getSuperClasses(o.getClass());
        for (i = 0; i < supers.length; ++i) {
            classes.append(supers[i].getName());
            classes.append(",");
        }
        this.writer.attribute("superclasses", classes.toString());
        if (o instanceof Externalizable) {
            ((Externalizable)o).writeExternal(this);
        } else {
            for (i = supers.length - 1; i >= 0; --i) {
                if (!(class$java$io$Serializable == null ? XMLObjectOutputStream.class$("java.io.Serializable") : class$java$io$Serializable).isAssignableFrom(supers[i])) continue;
                this.writeClass(o, supers[i]);
            }
            this.writeClass(o, o.getClass());
        }
        this.writer.end("object");
    }

    protected void writeClass(Object o, Class c) throws IOException {
        this.writer.start("declaredClass");
        this.writer.attribute("class", c.getName());
        Method method = XMLObjectOutputStream.getWriteObject(c);
        if (method != null) {
            try {
                this.currentObjects.push(o);
                this.currentClasses.push(c);
                this.currentPutFields.push(new PutField());
                method.invoke(o, this);
                this.currentObjects.pop();
                this.currentClasses.pop();
                this.currentPutFields.pop();
            }
            catch (IllegalAccessException e) {
                throw new IOException("IllegalAccessException thrown! " + e);
            }
            catch (InvocationTargetException e) {
                throw new IOException("InvocationTargetException thrown! " + e.getTargetException());
            }
        } else {
            this.writeFields(o, c);
        }
        this.writer.end("declaredClass");
    }

    protected void writeFields(Object o, Class c) throws IOException {
        this.writer.start("default");
        Field[] fields = this.getPersistentFields(c);
        for (int i = 0; i < fields.length; ++i) {
            fields[i].setAccessible(true);
            if (Modifier.isStatic(fields[i].getModifiers()) || Modifier.isTransient(fields[i].getModifiers())) continue;
            if (fields[i].getType().isPrimitive()) {
                this.writePrimitiveField(o, fields[i]);
                continue;
            }
            try {
                this.writeObject(fields[i].get(o), fields[i].getName());
                continue;
            }
            catch (IllegalAccessException e) {
                throw new IOException("IllegalAccessException thrown " + e);
            }
        }
        this.writer.end("default");
    }

    protected void writePutFields(PutField p) throws IOException {
        this.writer.start("default");
        String[] primitives = p.getPrimitives();
        for (int i = 0; i < primitives.length; ++i) {
            String name = primitives[i];
            Object primitive = p.getPrimitive(name);
            if (primitive.getClass().equals(class$java$lang$Integer == null ? XMLObjectOutputStream.class$("java.lang.Integer") : class$java$lang$Integer)) {
                this.writePrimitive(p.getInt(name), name);
                continue;
            }
            if (primitive.getClass().equals(class$java$lang$Boolean == null ? XMLObjectOutputStream.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                this.writePrimitive(p.getBoolean(name), name);
                continue;
            }
            if (primitive.getClass().equals(class$java$lang$Byte == null ? XMLObjectOutputStream.class$("java.lang.Byte") : class$java$lang$Byte)) {
                this.writePrimitive(p.getByte(name), name);
                continue;
            }
            if (primitive.getClass().equals(class$java$lang$Character == null ? XMLObjectOutputStream.class$("java.lang.Character") : class$java$lang$Character)) {
                this.writePrimitive(p.getChar(name), name);
                continue;
            }
            if (primitive.getClass().equals(class$java$lang$Double == null ? XMLObjectOutputStream.class$("java.lang.Double") : class$java$lang$Double)) {
                this.writePrimitive(p.getDouble(name), name);
                continue;
            }
            if (primitive.getClass().equals(class$java$lang$Float == null ? XMLObjectOutputStream.class$("java.lang.Float") : class$java$lang$Float)) {
                this.writePrimitive(p.getFloat(name), name);
                continue;
            }
            if (primitive.getClass().equals(class$java$lang$Long == null ? XMLObjectOutputStream.class$("java.lang.Long") : class$java$lang$Long)) {
                this.writePrimitive(p.getLong(name), name);
                continue;
            }
            if (primitive.getClass().equals(class$java$lang$Short == null ? XMLObjectOutputStream.class$("java.lang.Short") : class$java$lang$Short)) {
                this.writePrimitive(p.getShort(name), name);
                continue;
            }
            throw new IllegalArgumentException("Field " + name + " is not primitive!");
        }
        String[] objects = p.getObjects();
        for (int i = 0; i < objects.length; ++i) {
            this.writeObject(p.getObject(objects[i]), objects[i]);
        }
        this.writer.end("default");
    }

    protected void writePrimitiveField(Object o, Field f) throws IOException {
        block10: {
            try {
                if (f.getType().equals(Integer.TYPE)) {
                    this.writePrimitive(f.getInt(o), f.getName());
                    break block10;
                }
                if (f.getType().equals(Boolean.TYPE)) {
                    this.writePrimitive(f.getBoolean(o), f.getName());
                    break block10;
                }
                if (f.getType().equals(Byte.TYPE)) {
                    this.writePrimitive(f.getByte(o), f.getName());
                    break block10;
                }
                if (f.getType().equals(Character.TYPE)) {
                    this.writePrimitive(f.getChar(o), f.getName());
                    break block10;
                }
                if (f.getType().equals(Double.TYPE)) {
                    this.writePrimitive(f.getDouble(o), f.getName());
                    break block10;
                }
                if (f.getType().equals(Float.TYPE)) {
                    this.writePrimitive(f.getFloat(o), f.getName());
                    break block10;
                }
                if (f.getType().equals(Long.TYPE)) {
                    this.writePrimitive(f.getLong(o), f.getName());
                    break block10;
                }
                if (f.getType().equals(Short.TYPE)) {
                    this.writePrimitive(f.getShort(o), f.getName());
                    break block10;
                }
                throw new IllegalArgumentException("Field " + f + " is not primitive!");
            }
            catch (IllegalAccessException e) {
                throw new IOException("IllegalAccessException thrown " + e);
            }
        }
    }

    protected void writePrimitive(int i, String field) throws IOException {
        this.writer.start("primitive");
        if (field != null) {
            this.writer.attribute("field", field);
        }
        this.writer.attribute("type", "int");
        this.writer.attribute("value", i);
        this.writer.end("primitive");
    }

    protected void writePrimitive(boolean b, String field) throws IOException {
        this.writer.start("primitive");
        if (field != null) {
            this.writer.attribute("field", field);
        }
        this.writer.attribute("type", "boolean");
        this.writer.attribute("value", b);
        this.writer.end("primitive");
    }

    protected void writePrimitive(byte b, String field) throws IOException {
        this.writer.start("primitive");
        if (field != null) {
            this.writer.attribute("field", field);
        }
        this.writer.attribute("type", "byte");
        this.writer.attribute("value", b);
        this.writer.end("primitive");
    }

    protected void writePrimitive(char c, String field) throws IOException {
        this.writer.start("primitive");
        if (field != null) {
            this.writer.attribute("field", field);
        }
        this.writer.attribute("type", "char");
        this.writer.attribute("value", c);
        this.writer.end("primitive");
    }

    protected void writePrimitive(double d, String field) throws IOException {
        this.writer.start("primitive");
        if (field != null) {
            this.writer.attribute("field", field);
        }
        this.writer.attribute("type", "double");
        this.writer.attribute("value", d);
        this.writer.end("primitive");
    }

    protected void writePrimitive(float f, String field) throws IOException {
        this.writer.start("primitive");
        if (field != null) {
            this.writer.attribute("field", field);
        }
        this.writer.attribute("type", "float");
        this.writer.attribute("value", f);
        this.writer.end("primitive");
    }

    protected void writePrimitive(long l, String field) throws IOException {
        this.writer.start("primitive");
        if (field != null) {
            this.writer.attribute("field", field);
        }
        this.writer.attribute("type", "long");
        this.writer.attribute("value", l);
        this.writer.end("primitive");
    }

    protected void writePrimitive(short s, String field) throws IOException {
        this.writer.start("primitive");
        if (field != null) {
            this.writer.attribute("field", field);
        }
        this.writer.attribute("type", "short");
        this.writer.attribute("value", s);
        this.writer.end("primitive");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Method getWriteObject(Class cl) {
        SoftHashMap softHashMap = WRITE_OBJECTS;
        synchronized (softHashMap) {
            if (WRITE_OBJECTS.containsKey(cl)) {
                return (Method)WRITE_OBJECTS.get(cl);
            }
            try {
                Method method = cl.getDeclaredMethod("writeObject", class$java$io$ObjectOutputStream == null ? (class$java$io$ObjectOutputStream = XMLObjectOutputStream.class$("java.io.ObjectOutputStream")) : class$java$io$ObjectOutputStream);
                method.setAccessible(true);
                WRITE_OBJECTS.put(cl, method);
                return method;
            }
            catch (NoSuchMethodException e) {
                WRITE_OBJECTS.put(cl, (Object)null);
                return null;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Reference {
        private Object object;

        public Reference(Object object) {
            this.object = object;
        }

        public int hashCode() {
            return XMLObjectOutputStream.this.hash(this.object);
        }

        public boolean equals(Object o) {
            return ((Reference)o).object == this.object;
        }
    }

    public class PutField
    extends ObjectOutputStream.PutField {
        protected Hashtable primitives = new Hashtable();
        protected Hashtable objects = new Hashtable();

        protected String[] getPrimitives() {
            return this.primitives.keySet().toArray(new String[0]);
        }

        protected String[] getObjects() {
            return this.objects.keySet().toArray(new String[0]);
        }

        private Object getPrimitive(String name) {
            return this.primitives.get(name);
        }

        protected Object getObject(String name) {
            return this.objects.get(name);
        }

        protected boolean getBoolean(String name) {
            return (Boolean)this.getPrimitive(name);
        }

        protected byte getByte(String name) {
            return (Byte)this.getPrimitive(name);
        }

        protected char getChar(String name) {
            return ((Character)this.getPrimitive(name)).charValue();
        }

        protected double getDouble(String name) {
            return (Double)this.getPrimitive(name);
        }

        protected float getFloat(String name) {
            return ((Float)this.getPrimitive(name)).floatValue();
        }

        protected int getInt(String name) {
            return (Integer)this.getPrimitive(name);
        }

        protected long getLong(String name) {
            return (Long)this.getPrimitive(name);
        }

        protected short getShort(String name) {
            return (Short)this.getPrimitive(name);
        }

        public void put(String name, boolean value) {
            this.primitives.put(name, new Boolean(value));
        }

        public void put(String name, byte value) {
            this.primitives.put(name, new Byte(value));
        }

        public void put(String name, char value) {
            this.primitives.put(name, new Character(value));
        }

        public void put(String name, double value) {
            this.primitives.put(name, new Double(value));
        }

        public void put(String name, float value) {
            this.primitives.put(name, new Float(value));
        }

        public void put(String name, int value) {
            this.primitives.put(name, new Integer(value));
        }

        public void put(String name, long value) {
            this.primitives.put(name, new Long(value));
        }

        public void put(String name, short value) {
            this.primitives.put(name, new Short(value));
        }

        public void put(String name, Object value) {
            this.objects.put(name, value);
        }

        public void write(ObjectOutput output) throws IOException {
            XMLObjectOutputStream xoos = (XMLObjectOutputStream)output;
            xoos.writeFields();
        }
    }
}

