/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.util.testing;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import java.util.SortedMap;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.util.RedBlackMap;
import rice.pastry.commonapi.PastryIdFactory;

public class RedBlackMapUnit {
    protected static int getIndex(Id id, Id[] sorted) {
        for (int i = 0; i < sorted.length; ++i) {
            if (id.compareTo(sorted[i]) > 0) continue;
            return i;
        }
        return sorted.length;
    }

    public static void main(String[] args) {
        PastryIdFactory pFactory;
        int n = Integer.parseInt(args[0]);
        int t = Integer.parseInt(args[0]);
        Random random = new Random();
        PastryIdFactory factory = pFactory = new PastryIdFactory();
        Id[] array = new Id[n];
        Long[] values = new Long[n];
        RedBlackMap map = new RedBlackMap();
        for (int i = 0; i < array.length; ++i) {
            array[i] = factory.buildRandomId(random);
            map.put(array[i], values[i]);
        }
        System.out.print("MAIN MAP: ");
        RedBlackMapUnit.printMap(map);
        RedBlackMapUnit.testRemove(map);
        RedBlackMapUnit.testSortedMap(t, map, factory, random, 2);
    }

    protected static void testRemove(SortedMap map) {
        Object[] sorted = map.keySet().toArray(new Id[0]);
        Arrays.sort(sorted);
        for (int i = 0; i < sorted.length; ++i) {
            RedBlackMapUnit.testRemove(map, (Id[])sorted, (Id)sorted[i]);
        }
    }

    protected static void testRemove(SortedMap map, Id[] sorted, Id remove) {
        System.out.println("REMOVING " + remove);
        map.remove(remove);
        Iterator i = map.keySet().iterator();
        int count = 0;
        while (i.hasNext()) {
            Id next;
            if (sorted[count].equals(remove)) {
                ++count;
            }
            if (!(next = (Id)i.next()).equals(sorted[count])) {
                throw new RuntimeException("FAILURE: Remove did not expect element " + next + " expected " + sorted[count]);
            }
            ++count;
        }
        if (count < sorted.length && !sorted[count].equals(remove)) {
            throw new RuntimeException("FAILURE: Remove did not receive element " + sorted[count]);
        }
        map.put(remove, null);
    }

    protected static void printMap(Id[] id) {
        for (int i = 0; i < id.length; ++i) {
            System.out.print(" " + id[i] + ",");
        }
        System.out.println();
    }

    protected static void printMap(SortedMap map) {
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            System.out.print(" " + i.next() + ",");
        }
        System.out.println();
    }

    protected static void testSortedMap(int iterations, SortedMap map, IdFactory factory, Random random, int depth) {
        Object[] sorted = map.keySet().toArray(new Id[0]);
        Arrays.sort(sorted);
        for (int i = 0; i < iterations; ++i) {
            Id id1 = factory.buildRandomId(random);
            Id id2 = factory.buildRandomId(random);
            RedBlackMapUnit.testHeadMap(id1, (Id[])sorted, map.headMap(id1));
            RedBlackMapUnit.testTailMap(id2, (Id[])sorted, map.tailMap(id2));
            if (id1.compareTo(id2) <= 0) {
                RedBlackMapUnit.testNormalSubMap(id1, id2, (Id[])sorted, map.subMap(id1, id2));
                try {
                    RedBlackMapUnit.testWrappedSubMap(id2, id1, (Id[])sorted, map.subMap(id2, id1));
                }
                catch (RuntimeException e) {
                    int j;
                    for (j = 0; j < 2 - depth; ++j) {
                        System.out.print("  ");
                    }
                    System.out.print("Testing map " + map.keySet().size());
                    RedBlackMapUnit.printMap(map);
                    for (j = 0; j < 2 - depth; ++j) {
                        System.out.print("  ");
                    }
                    System.out.println("Testing  " + id1 + " " + id2);
                    throw e;
                }
            }
            RedBlackMapUnit.testNormalSubMap(id2, id1, (Id[])sorted, map.subMap(id2, id1));
            try {
                RedBlackMapUnit.testWrappedSubMap(id1, id2, (Id[])sorted, map.subMap(id1, id2));
            }
            catch (RuntimeException e) {
                int j;
                for (j = 0; j < 2 - depth; ++j) {
                    System.out.print("  ");
                }
                System.out.print("Testing map " + map.keySet().size());
                RedBlackMapUnit.printMap(map);
                for (j = 0; j < 2 - depth; ++j) {
                    System.out.print("  ");
                }
                System.out.println("Testing  " + id1 + " " + id2);
                throw e;
            }
            if (depth <= 0) continue;
            try {
                RedBlackMapUnit.testSortedMap(iterations, map.headMap(id1), factory, random, depth - 1);
            }
            catch (RuntimeException e) {
                for (int j = 0; j < 2 - depth; ++j) {
                    System.out.print("  ");
                }
                System.out.print("Testing headMap to " + id1 + " ");
                RedBlackMapUnit.printMap(map.headMap(id1));
                throw e;
            }
            try {
                RedBlackMapUnit.testSortedMap(iterations, map.tailMap(id2), factory, random, depth - 1);
            }
            catch (RuntimeException e) {
                for (int j = 0; j < 2 - depth; ++j) {
                    System.out.print("  ");
                }
                System.out.print("Testing tailMap from " + id2 + " ");
                RedBlackMapUnit.printMap(map.tailMap(id2));
                throw e;
            }
            try {
                RedBlackMapUnit.testSortedMap(iterations, map.subMap(id1, id2), factory, random, depth - 1);
            }
            catch (RuntimeException e) {
                for (int j = 0; j < 2 - depth; ++j) {
                    System.out.print("  ");
                }
                System.out.print("Testing subMap from " + id1 + " to " + id2 + " ");
                RedBlackMapUnit.printMap(map.subMap(id1, id2));
                throw e;
            }
            try {
                RedBlackMapUnit.testSortedMap(iterations, map.subMap(id2, id1), factory, random, depth - 1);
                continue;
            }
            catch (RuntimeException e) {
                for (int j = 0; j < 2 - depth; ++j) {
                    System.out.print("  ");
                }
                System.out.print("Testing subMap from " + id2 + " to " + id1 + " ");
                RedBlackMapUnit.printMap(map.subMap(id2, id1));
                throw e;
            }
        }
    }

    protected static void testHeadMap(Id head, Id[] sorted, SortedMap sub) {
        Iterator it = sub.keySet().iterator();
        int count = 0;
        while (it.hasNext()) {
            Id next = (Id)it.next();
            if (next != sorted[count]) {
                throw new RuntimeException("FAILURE: Head test expected element " + sorted[count] + " got " + next);
            }
            if (next.compareTo(head) > 0) {
                throw new RuntimeException("FAILURE: Head test did not expect element " + next);
            }
            ++count;
        }
        if (count < sorted.length && sorted[count].compareTo(head) < 0) {
            throw new RuntimeException("FAILURE: Head test did not receive element " + sorted[count]);
        }
    }

    protected static void testTailMap(Id tail, Id[] sorted, SortedMap sub) {
        Iterator it = sub.keySet().iterator();
        int count = RedBlackMapUnit.getIndex(tail, sorted);
        while (it.hasNext()) {
            Id next = (Id)it.next();
            if (next != sorted[count]) {
                throw new RuntimeException("FAILURE: Tail test expected element " + sorted[count] + " got " + next);
            }
            if (next.compareTo(tail) < 0) {
                throw new RuntimeException("FAILURE: Tail test did not expect element " + next);
            }
            ++count;
        }
        if (count < sorted.length) {
            throw new RuntimeException("FAILURE: Tail test did not receive element " + sorted[count]);
        }
    }

    protected static void testNormalSubMap(Id from, Id to, Id[] sorted, SortedMap sub) {
        Iterator it = sub.keySet().iterator();
        int count = RedBlackMapUnit.getIndex(from, sorted);
        while (it.hasNext()) {
            Id next = (Id)it.next();
            if (next != sorted[count]) {
                throw new RuntimeException("FAILURE: Normal subMap test expected element " + sorted[count] + " got " + next);
            }
            if (next.compareTo(from) < 0 || next.compareTo(to) >= 0) {
                throw new RuntimeException("FAILURE: Normal subMap test did not expect element " + next);
            }
            ++count;
        }
        if (count < sorted.length && sorted[count].compareTo(to) < 0) {
            throw new RuntimeException("FAILURE: Normal subMap test did not receive element " + sorted[count]);
        }
    }

    protected static void testWrappedSubMap(Id from, Id to, Id[] sorted, SortedMap sub) {
        try {
            int count;
            Iterator it = sub.keySet().iterator();
            int n = sorted.length > 0 ? (sorted[0].compareTo(to) < 0 ? 0 : RedBlackMapUnit.getIndex(from, sorted)) : (count = 0);
            while (it.hasNext()) {
                Id next = (Id)it.next();
                if (next != sorted[count]) {
                    throw new RuntimeException("FAILURE: Wrapped subMap test expected element " + sorted[count] + " got " + next);
                }
                if (next.compareTo(from) < 0 && next.compareTo(to) >= 0) {
                    throw new RuntimeException("FAILURE: Wrapped subMap test did not expect element " + next);
                }
                if (++count >= sorted.length || sorted[count].compareTo(to) < 0 || sorted[count].compareTo(from) >= 0) continue;
                count = RedBlackMapUnit.getIndex(from, sorted);
            }
            if (count < sorted.length) {
                throw new RuntimeException("FAILURE: Wrapped subMap test did not receive element " + sorted[count]);
            }
        }
        catch (RuntimeException e) {
            System.out.print("--> Testing wrapped from " + from + " to " + to + " in map ");
            RedBlackMapUnit.printMap(sorted);
            System.out.print("--> In map ");
            RedBlackMapUnit.printMap(sub);
            throw e;
        }
    }
}

