/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.SortedMap;
import rice.p2p.util.RedBlackMap;
import rice.pastry.Id;
import rice.pastry.IdRange;

public class IdSet
implements rice.p2p.commonapi.IdSet {
    private SortedMap idSet;
    private byte[] cachedHash;
    private boolean validHash;
    static final long serialVersionUID = -1565571743719309172L;

    public IdSet() {
        this.idSet = new RedBlackMap();
        this.validHash = false;
    }

    public IdSet(SortedMap s) {
        this.idSet = s;
        this.validHash = false;
    }

    public boolean isMember(Id id) {
        return this.idSet.containsKey(id);
    }

    public Iterator getIterator() {
        return this.idSet.keySet().iterator();
    }

    public byte[] getHash() {
        if (this.validHash) {
            return this.cachedHash;
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println("No SHA support!");
            return null;
        }
        Iterator it = this.getIterator();
        byte[] raw = new byte[20];
        while (it.hasNext()) {
            Id id = (Id)it.next();
            id.blit(raw);
            md.update(raw);
        }
        this.cachedHash = md.digest();
        this.validHash = true;
        return this.cachedHash;
    }

    public boolean isMemberId(rice.p2p.commonapi.Id id) {
        return this.isMember((Id)id);
    }

    public int numElements() {
        return this.idSet.size();
    }

    public void addMember(Id id) {
        this.idSet.put(id, null);
        this.validHash = false;
    }

    public void removeMember(Id id) {
        this.idSet.remove(id);
        this.validHash = false;
    }

    public Id minMember() {
        return (Id)this.idSet.firstKey();
    }

    public Id maxMember() {
        return (Id)this.idSet.lastKey();
    }

    public IdSet subSet(Id from, Id to) {
        return new IdSet(this.idSet.subMap(from, to));
    }

    public IdSet subSet(IdRange range) {
        if (range.isEmpty()) {
            return new IdSet();
        }
        if (range.getCCW().equals(range.getCW())) {
            return this;
        }
        return this.subSet(range.getCCW(), range.getCW());
    }

    public String toString() {
        Iterator it = this.getIterator();
        String s = "[ IdSet: ";
        while (it.hasNext()) {
            Id key = (Id)it.next();
            s = s + key + ",";
        }
        s = s + " ]";
        return s;
    }

    public void addId(rice.p2p.commonapi.Id id) {
        this.addMember((Id)id);
    }

    public void removeId(rice.p2p.commonapi.Id id) {
        this.removeMember((Id)id);
    }

    public rice.p2p.commonapi.IdSet build() {
        return new IdSet();
    }

    public rice.p2p.commonapi.IdSet subSet(rice.p2p.commonapi.IdRange range) {
        return this.subSet((IdRange)range);
    }

    public byte[] hash() {
        return this.getHash();
    }

    public rice.p2p.commonapi.Id[] asArray() {
        return this.idSet.keySet().toArray(new rice.p2p.commonapi.Id[0]);
    }

    public Object clone() {
        return new IdSet(this.idSet);
    }
}

