/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Vector;
import rice.p2p.commonapi.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.NodeSetI;

public class NodeSet
implements NodeSetI,
Serializable {
    private Vector set;

    public NodeSet() {
        this.set = new Vector();
    }

    public NodeSet(Vector s) {
        this.set = s;
    }

    public NodeSet(NodeSet o) {
        this.set = new Vector(o.set);
    }

    public NodeHandle get(NodeId nid) {
        try {
            return (NodeHandle)this.set.elementAt(this.getIndex(nid));
        }
        catch (Exception e) {
            return null;
        }
    }

    public NodeHandle get(int i) {
        NodeHandle h;
        try {
            h = (NodeHandle)this.set.elementAt(i);
        }
        catch (Exception e) {
            return null;
        }
        return h;
    }

    public int getIndex(NodeId nid) {
        return this.getIndexId(nid);
    }

    public int getIndex(NodeHandle nh) {
        for (int i = 0; i < this.set.size(); ++i) {
            try {
                NodeHandle h = (NodeHandle)this.set.elementAt(i);
                if (!h.equals(nh)) continue;
                return i;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return -1;
    }

    private int getIndexId(Id nid) {
        for (int i = 0; i < this.set.size(); ++i) {
            try {
                NodeHandle h = (NodeHandle)this.set.elementAt(i);
                if (!h.getNodeId().equals(nid)) continue;
                return i;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return -1;
    }

    public Iterator getIterator() {
        return this.set.iterator();
    }

    public rice.p2p.commonapi.NodeHandle getHandle(Id id) {
        return this.getHandle((NodeId)id);
    }

    public rice.p2p.commonapi.NodeHandle getHandle(int i) {
        return this.get(i);
    }

    public int getIndexHandle(Id id) throws NoSuchElementException {
        return this.getIndex((NodeId)id);
    }

    public boolean put(NodeHandle handle) {
        if (this.set.contains(handle)) {
            return false;
        }
        this.set.add(handle);
        return true;
    }

    public void randomize() {
        Random random = new Random();
        for (int i = 0; i < this.set.size(); ++i) {
            int a = random.nextInt(this.set.size());
            int b = random.nextInt(this.set.size());
            Object tmp = this.set.elementAt(a);
            this.set.setElementAt(this.set.elementAt(b), a);
            this.set.setElementAt(tmp, b);
        }
    }

    private boolean memberId(Id id) {
        return this.getIndexId(id) >= 0;
    }

    public NodeHandle remove(NodeId nid) {
        try {
            return (NodeHandle)this.set.remove(this.getIndex(nid));
        }
        catch (Exception e) {
            return null;
        }
    }

    public int size() {
        return this.set.size();
    }

    public boolean insert(int index, NodeHandle handle) {
        if (this.set.contains(handle)) {
            return false;
        }
        this.set.add(index, handle);
        return true;
    }

    public NodeHandle remove(NodeHandle handle) {
        if (this.set.remove(handle)) {
            return handle;
        }
        return null;
    }

    public void remove(int index) {
        this.set.remove(index);
    }

    public int indexOf(NodeHandle handle) {
        return this.set.indexOf(handle);
    }

    public boolean member(NodeHandle handle) {
        return this.set.contains(handle);
    }

    NodeSet subSet(int from, int to) {
        NodeSet res;
        try {
            res = new NodeSet(new Vector(this.set.subList(from, to)));
        }
        catch (Exception e) {
            return null;
        }
        return res;
    }

    public String toString() {
        String s = "NodeSet: ";
        for (int i = 0; i < this.size(); ++i) {
            s = s + this.get(i).getNodeId();
        }
        return s;
    }

    public boolean putHandle(rice.p2p.commonapi.NodeHandle handle) {
        return this.put((NodeHandle)handle);
    }

    public boolean memberHandle(Id id) {
        return this.memberId(id);
    }

    public rice.p2p.commonapi.NodeHandle removeHandle(Id id) {
        return this.remove((NodeId)id);
    }
}

