/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry;

import java.io.ObjectInputStream;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Observer;
import java.util.Vector;
import java.util.WeakHashMap;
import rice.Continuation;
import rice.Executable;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.Node;
import rice.pastry.LocalNodeI;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.PastryObjectInputStream;
import rice.pastry.ScheduledMessage;
import rice.pastry.client.PastryAppl;
import rice.pastry.commonapi.PastryEndpoint;
import rice.pastry.commonapi.PastryIdFactory;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Address;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.MessageDispatch;
import rice.pastry.messaging.MessageReceiver;
import rice.pastry.routing.RoutingTable;
import rice.pastry.security.Credentials;
import rice.pastry.security.PastrySecurityManager;

public abstract class PastryNode
implements MessageReceiver,
Node {
    protected NodeId myNodeId;
    private PastrySecurityManager mySecurityManager;
    private MessageDispatch myMessageDispatch;
    private LeafSet leafSet;
    private RoutingTable routeSet;
    protected NodeHandle localhandle;
    private boolean ready;
    protected Vector apps;
    protected WeakHashMap nodeHandleSet = new WeakHashMap();
    public static String EC_NO_CODE_AVAILABLE = "no error code available";

    protected PastryNode(NodeId id) {
        this.myNodeId = id;
        this.ready = false;
        this.apps = new Vector();
    }

    public LocalNodeI getLocalNodeI(LocalNodeI lni) {
        WeakReference<LocalNodeI> wr = (WeakReference<LocalNodeI>)this.nodeHandleSet.get(lni);
        if (wr == null) {
            wr = new WeakReference<LocalNodeI>(lni);
            this.nodeHandleSet.put(lni, wr);
        }
        return (LocalNodeI)wr.get();
    }

    public rice.p2p.commonapi.NodeHandle getLocalNodeHandle() {
        return this.localhandle;
    }

    public NodeHandle getLocalHandle() {
        return this.localhandle;
    }

    public NodeId getNodeId() {
        return this.myNodeId;
    }

    public boolean isReady() {
        return this.ready;
    }

    public MessageDispatch getMessageDispatch() {
        return this.myMessageDispatch;
    }

    public boolean isClosest(NodeId key) {
        return this.leafSet.mostSimilar(key) == 0;
    }

    public LeafSet getLeafSet() {
        return this.leafSet;
    }

    public RoutingTable getRoutingTable() {
        return this.routeSet;
    }

    public Id getId() {
        return this.getNodeId();
    }

    public IdFactory getIdFactory() {
        return new PastryIdFactory();
    }

    public String getErrorString(int errorCode) {
        return EC_NO_CODE_AVAILABLE;
    }

    public void setElements(NodeHandle lh, PastrySecurityManager sm, MessageDispatch md, LeafSet ls, RoutingTable rt) {
        this.localhandle = lh;
        this.mySecurityManager = sm;
        this.myMessageDispatch = md;
        this.leafSet = ls;
        this.routeSet = rt;
    }

    public void setMessageDispatch(MessageDispatch md) {
        this.myMessageDispatch = md;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReady() {
        if (this.isReady()) {
            return;
        }
        this.ready = true;
        this.nodeIsReady();
        Vector tmpApps = new Vector(this.apps);
        Iterator it = tmpApps.iterator();
        while (it.hasNext()) {
            ((PastryAppl)it.next()).notifyReady();
        }
        PastryNode pastryNode = this;
        synchronized (pastryNode) {
            this.notifyAll();
        }
    }

    public abstract void nodeIsReady();

    public abstract void initiateJoin(NodeHandle var1);

    public void addLeafSetObserver(Observer o) {
        this.leafSet.addObserver(o);
    }

    public void deleteLeafSetObserver(Observer o) {
        this.leafSet.deleteObserver(o);
    }

    public void addRouteSetObserver(Observer o) {
        this.routeSet.addObserver(o);
    }

    public void deleteRouteSetObserver(Observer o) {
        this.routeSet.deleteObserver(o);
    }

    public synchronized void receiveMessage(Message msg) {
        ObjectInputStream stream = msg.getStream();
        if (stream != null && !(stream instanceof PastryObjectInputStream)) {
            LocalNodeI.pending.setPending(stream, this);
        }
        if (this.mySecurityManager.verifyMessage(msg)) {
            this.myMessageDispatch.dispatchMessage(msg);
        }
    }

    public void registerReceiver(Credentials cred, Address address, MessageReceiver receiver) {
        if (!this.mySecurityManager.verifyAddressBinding(cred, address)) {
            throw new Error("security failure");
        }
        this.myMessageDispatch.registerReceiver(address, receiver);
    }

    public void registerApp(PastryAppl app) {
        if (this.isReady()) {
            app.notifyReady();
        }
        this.apps.add(app);
    }

    public abstract ScheduledMessage scheduleMsg(Message var1, long var2);

    public abstract ScheduledMessage scheduleMsg(Message var1, long var2, long var4);

    public abstract ScheduledMessage scheduleMsgAtFixedRate(Message var1, long var2, long var4);

    public String toString() {
        return "Pastry node " + this.myNodeId.toString();
    }

    public Endpoint registerApplication(Application application, String instance) {
        return new PastryEndpoint(this, application, instance);
    }

    public void messageNotSent(Message m, int errorCode) {
        MessageReceiver mr = this.getMessageDispatch().getDestination(m);
        if (mr != null && mr instanceof PastryAppl) {
            PastryAppl a = (PastryAppl)mr;
            a.messageNotDelivered(m, errorCode);
        } else {
            System.out.println("WARNING: message not sent " + m + ":" + this.getErrorString(errorCode));
        }
    }

    public void process(Executable task, Continuation command) {
        try {
            command.receiveResult(task.execute());
        }
        catch (Exception e) {
            command.receiveException(e);
        }
    }
}

