/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.PastryNode;
import rice.pastry.leafset.LeafSet;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.RoutingTable;

public abstract class PastryNodeFactory {
    private Hashtable pingCache = new Hashtable();

    public abstract LeafSet getLeafSet(NodeHandle var1) throws IOException;

    public abstract RouteSet[] getRouteRow(NodeHandle var1, int var2) throws IOException;

    public abstract int getProximity(NodeHandle var1, NodeHandle var2);

    public NodeHandle getNearest(NodeHandle local, NodeHandle seed) {
        try {
            if (seed == null) {
                return null;
            }
            NodeHandle currentClosest = seed;
            NodeHandle nearNode = seed;
            nearNode = this.closestToMe(local, nearNode, this.getLeafSet(nearNode));
            int depth = 160 / RoutingTable.idBaseBitLength;
            for (int i = 0; i < depth; ++i) {
                nearNode = this.closestToMe(local, nearNode, this.getRouteRow(nearNode, i));
            }
            while (!(currentClosest = nearNode).equals(nearNode = this.closestToMe(local, nearNode, this.getRouteRow(nearNode, depth - 1)))) {
            }
            if (nearNode.getLocalNode() == null) {
                nearNode.setLocalNode(local.getLocalNode());
            }
            return nearNode;
        }
        catch (IOException e) {
            System.out.println("ERROR: Exception " + e + " occured while finding best bootstrap.");
            return seed;
        }
    }

    public abstract PastryNode newNode(NodeHandle var1);

    public abstract PastryNode newNode(NodeHandle var1, NodeId var2);

    private int proximity(NodeHandle local, NodeHandle handle) {
        Hashtable<NodeId, Integer> localTable = (Hashtable<NodeId, Integer>)this.pingCache.get(local.getNodeId());
        if (localTable == null) {
            localTable = new Hashtable<NodeId, Integer>();
            this.pingCache.put(local.getNodeId(), localTable);
        }
        if (localTable.get(handle.getNodeId()) == null) {
            int value = this.getProximity(local, handle);
            localTable.put(handle.getNodeId(), new Integer(value));
            return value;
        }
        return (Integer)localTable.get(handle.getNodeId());
    }

    private NodeHandle closestToMe(NodeHandle local, NodeHandle handle, LeafSet leafSet) {
        int i;
        Vector<NodeHandle> handles = new Vector<NodeHandle>();
        for (i = 1; i <= leafSet.cwSize(); ++i) {
            handles.add(leafSet.get(i));
        }
        for (i = -leafSet.ccwSize(); i < 0; ++i) {
            handles.add(leafSet.get(i));
        }
        return this.closestToMe(local, handle, handles.toArray(new NodeHandle[0]));
    }

    private NodeHandle closestToMe(NodeHandle local, NodeHandle handle, RouteSet[] routeSets) {
        Vector<NodeHandle> handles = new Vector<NodeHandle>();
        for (int i = 0; i < routeSets.length; ++i) {
            RouteSet set = routeSets[i];
            if (set == null) continue;
            for (int j = 0; j < set.size(); ++j) {
                handles.add(set.get(j));
            }
        }
        return this.closestToMe(local, handle, handles.toArray(new NodeHandle[0]));
    }

    private NodeHandle closestToMe(NodeHandle local, NodeHandle handle, NodeHandle[] handles) {
        NodeHandle closestNode = handle;
        int nearestdist = this.proximity(local, closestNode);
        for (int i = 0; i < handles.length; ++i) {
            NodeHandle tempNode = handles[i];
            if (this.proximity(local, tempNode) >= nearestdist || !tempNode.isAlive()) continue;
            nearestdist = this.proximity(local, tempNode);
            closestNode = tempNode;
        }
        return closestNode;
    }
}

