/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.client;

import java.util.Observable;
import java.util.Observer;
import rice.pastry.Id;
import rice.pastry.Log;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.NodeSetUpdate;
import rice.pastry.PastryNode;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Address;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.MessageReceiver;
import rice.pastry.routing.RouteMessage;
import rice.pastry.routing.RoutingTable;
import rice.pastry.routing.SendOptions;
import rice.pastry.security.Credentials;
import rice.pastry.standard.StandardAddress;

public abstract class PastryAppl
implements MessageReceiver {
    protected String instance;
    protected PastryNode thePastryNode;
    protected Address address;

    public PastryAppl(PastryNode pn) {
        this.thePastryNode = pn;
        this.thePastryNode.registerReceiver(this.getCredentials(), this.getAddress(), this);
        this.thePastryNode.addLeafSetObserver(new LeafSetObserver());
        this.thePastryNode.addRouteSetObserver(new RouteSetObserver());
        this.thePastryNode.registerApp(this);
    }

    public PastryAppl(PastryNode pn, String instance) {
        this.instance = instance;
        this.address = new StandardAddress(this.getClass(), instance);
        this.thePastryNode = pn;
        this.thePastryNode.registerReceiver(this.getCredentials(), this.getAddress(), this);
        this.thePastryNode.addLeafSetObserver(new LeafSetObserver());
        this.thePastryNode.addRouteSetObserver(new RouteSetObserver());
        this.thePastryNode.registerApp(this);
    }

    public Address getAddress() {
        return this.address;
    }

    public final NodeId getNodeId() {
        return this.thePastryNode.getNodeId();
    }

    public NodeHandle getNodeHandle() {
        return this.thePastryNode.getLocalHandle();
    }

    public LeafSet getLeafSet() {
        return this.thePastryNode.getLeafSet().copy();
    }

    public RoutingTable getRoutingTable() {
        return this.thePastryNode.getRoutingTable();
    }

    public boolean isClosest(NodeId key) {
        return this.thePastryNode.isClosest(key);
    }

    public abstract Credentials getCredentials();

    public final void registerReceiver(Credentials cred, Address addr, MessageReceiver mr) {
        this.thePastryNode.registerReceiver(cred, addr, mr);
    }

    public final void sendMessage(Message msg) {
        if (Log.ifp(8)) {
            System.out.println("[" + this.thePastryNode + "] send " + msg);
        }
        this.thePastryNode.receiveMessage(msg);
    }

    public void receiveMessage(Message msg) {
        if (Log.ifp(8)) {
            System.out.println("[" + this.thePastryNode + "] recv " + msg);
        }
        if (msg instanceof RouteMessage) {
            RouteMessage rm = (RouteMessage)msg;
            if (this.enrouteMessage(rm.unwrap(), rm.getTarget(), rm.nextHop.getNodeId(), rm.getOptions())) {
                rm.routeMessage(this.thePastryNode.getLocalHandle());
            }
        } else {
            this.messageForAppl(msg);
        }
    }

    public boolean routeMsgDirect(NodeHandle dest, Message msg, Credentials cred, SendOptions opt) {
        if (Log.ifp(8)) {
            System.out.println("[" + this.thePastryNode + "] routemsgdirect " + msg + " to " + dest);
        }
        if (!dest.isAlive()) {
            return false;
        }
        dest.receiveMessage(msg);
        return dest.isAlive();
    }

    public void routeMsg(Id key, Message msg, Credentials cred, SendOptions opt) {
        if (Log.ifp(8)) {
            System.out.println("[" + this.thePastryNode + "] routemsg " + msg + " to " + key);
        }
        RouteMessage rm = new RouteMessage(key, msg, cred, opt, this.getAddress());
        this.thePastryNode.receiveMessage(rm);
    }

    public abstract void messageForAppl(Message var1);

    public boolean enrouteMessage(Message msg, Id key, NodeId nextHop, SendOptions opt) {
        return true;
    }

    public void leafSetChange(NodeHandle nh, boolean wasAdded) {
    }

    public void routeSetChange(NodeHandle nh, boolean wasAdded) {
    }

    public void notifyReady() {
    }

    public void messageNotDelivered(Message msg, int errorCode) {
        System.out.println("messageNotDelivered(" + msg + "):" + this.thePastryNode.getErrorString(errorCode));
    }

    private class RouteSetObserver
    implements Observer {
        private RouteSetObserver() {
        }

        public void update(Observable o, Object arg) {
            NodeSetUpdate nsu = (NodeSetUpdate)arg;
            NodeHandle handle = nsu.handle();
            boolean wa = nsu.wasAdded();
            PastryAppl.this.routeSetChange(handle, wa);
        }
    }

    private class LeafSetObserver
    implements Observer {
        private LeafSetObserver() {
        }

        public void update(Observable o, Object arg) {
            NodeSetUpdate nsu = (NodeSetUpdate)arg;
            NodeHandle handle = nsu.handle();
            boolean wa = nsu.wasAdded();
            PastryAppl.this.leafSetChange(handle, wa);
        }
    }
}

