/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.direct;

import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.PastryNode;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.messaging.Message;

public class DirectNodeHandle
extends NodeHandle {
    private PastryNode remoteNode;
    private NetworkSimulator simulator;

    public DirectNodeHandle(PastryNode ln, PastryNode rn, NetworkSimulator sim) {
        this.setLocalNode(ln);
        this.remoteNode = rn;
        this.simulator = sim;
    }

    public PastryNode getRemote() {
        return this.remoteNode;
    }

    public NodeId getNodeId() {
        return this.remoteNode.getNodeId();
    }

    public int getLiveness() {
        if (this.simulator.isAlive(this.remoteNode.getNodeId())) {
            return 1;
        }
        return 3;
    }

    public NetworkSimulator getSimulator() {
        return this.simulator;
    }

    public void notifyObservers(Object arg) {
        this.setChanged();
        super.notifyObservers(arg);
    }

    public boolean ping() {
        return this.isAlive();
    }

    public int proximity() {
        this.assertLocalNode();
        int result = this.simulator.proximity(this.getLocalNode().getNodeId(), this.remoteNode.getNodeId());
        return result;
    }

    public void receiveMessage(Message msg) {
        if (this.simulator.isAlive(msg.getSenderId())) {
            this.simulator.deliverMessage(msg, this.remoteNode);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        NodeHandle nh = (NodeHandle)obj;
        return this.getNodeId().equals(nh.getNodeId());
    }

    public int hashCode() {
        return this.getNodeId().hashCode();
    }

    public String toString() {
        return "[DNH " + this.getNodeId() + "]";
    }
}

