/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.direct;

import java.io.IOException;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.NodeIdFactory;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.direct.DirectNodeHandle;
import rice.pastry.direct.DirectPastryNode;
import rice.pastry.direct.DirectSecurityManager;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.MessageDispatch;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.RoutingTable;
import rice.pastry.standard.StandardJoinProtocol;
import rice.pastry.standard.StandardLeafSetProtocol;
import rice.pastry.standard.StandardRouteSetProtocol;
import rice.pastry.standard.StandardRouter;

public class DirectPastryNodeFactory
extends PastryNodeFactory {
    private NodeIdFactory nidFactory;
    private NetworkSimulator simulator;
    private static final int rtMax = 1;
    private static final int lSetSize = 24;

    public DirectPastryNodeFactory(NodeIdFactory nf, NetworkSimulator sim) {
        this.nidFactory = nf;
        this.simulator = sim;
    }

    public NetworkSimulator getNetworkSimulator() {
        return this.simulator;
    }

    public LeafSet getLeafSet(NodeHandle handle) throws IOException {
        DirectNodeHandle dHandle = (DirectNodeHandle)handle;
        return dHandle.getRemote().getLeafSet();
    }

    public RouteSet[] getRouteRow(NodeHandle handle, int row) throws IOException {
        DirectNodeHandle dHandle = (DirectNodeHandle)handle;
        return dHandle.getRemote().getRoutingTable().getRow(row);
    }

    public int getProximity(NodeHandle local, NodeHandle remote) {
        return this.simulator.proximity(local.getNodeId(), remote.getNodeId());
    }

    public PastryNode newNode(NodeHandle bootstrap) {
        return this.newNode(bootstrap, this.nidFactory.generateNodeId());
    }

    public PastryNode newNode(NodeHandle bootstrap, NodeId nodeId) {
        DirectPastryNode pn = new DirectPastryNode(nodeId, this.simulator);
        DirectNodeHandle localhandle = new DirectNodeHandle(pn, pn, this.simulator);
        this.simulator.registerNodeId(localhandle);
        DirectSecurityManager secureMan = new DirectSecurityManager(this.simulator);
        MessageDispatch msgDisp = new MessageDispatch();
        RoutingTable routeTable = new RoutingTable(localhandle, 1);
        LeafSet leafSet = new LeafSet(localhandle, 24);
        StandardRouter router = new StandardRouter(localhandle, routeTable, leafSet, secureMan);
        StandardLeafSetProtocol lsProtocol = new StandardLeafSetProtocol(pn, localhandle, secureMan, leafSet, routeTable);
        StandardRouteSetProtocol rsProtocol = new StandardRouteSetProtocol(localhandle, secureMan, routeTable);
        StandardJoinProtocol jProtocol = new StandardJoinProtocol(pn, localhandle, secureMan, routeTable, leafSet);
        msgDisp.registerReceiver(router.getAddress(), router);
        msgDisp.registerReceiver(lsProtocol.getAddress(), lsProtocol);
        msgDisp.registerReceiver(rsProtocol.getAddress(), rsProtocol);
        msgDisp.registerReceiver(jProtocol.getAddress(), jProtocol);
        pn.setElements(localhandle, secureMan, msgDisp, leafSet, routeTable);
        pn.setDirectElements();
        secureMan.setLocalPastryNode(pn);
        pn.doneNode(this.getNearest(localhandle, bootstrap));
        return pn;
    }
}

