/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.direct;

import java.util.Date;
import java.util.Hashtable;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.PastryNode;
import rice.pastry.direct.DirectNodeHandle;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.messaging.Address;
import rice.pastry.messaging.Message;
import rice.pastry.security.Credentials;
import rice.pastry.security.PastrySecurityManager;

public class DirectSecurityManager
implements PastrySecurityManager {
    private PastryNode pnode = null;
    private NetworkSimulator sim;
    private Hashtable pool;

    public DirectSecurityManager(NetworkSimulator ns) {
        this.sim = ns;
        this.pool = new Hashtable();
    }

    public Date getTimestamp() {
        return new Date();
    }

    public void setLocalPastryNode(PastryNode local) {
        this.pnode = local;
    }

    public boolean verifyMessage(Message msg) {
        return true;
    }

    public boolean verifyAddressBinding(Credentials cred, Address addr) {
        return true;
    }

    public NodeHandle verifyNodeHandle(NodeHandle handle) {
        NodeId nid;
        NodeId local = this.pnode.getNodeId();
        if (local.equals(nid = handle.getNodeId())) {
            return this.pnode.getLocalHandle();
        }
        if (handle instanceof DirectNodeHandle) {
            DirectNodeHandle dnh = (DirectNodeHandle)handle;
            DirectNodeHandle retDnh = (DirectNodeHandle)this.pool.get(handle.getNodeId());
            if (retDnh == null) {
                retDnh = new DirectNodeHandle(this.pnode, dnh.getRemote(), this.sim);
                this.pool.put(handle.getNodeId(), retDnh);
                this.sim.registerNodeId(retDnh);
            }
            return retDnh;
        }
        throw new Error("node handle of unknown type");
    }
}

