/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.direct;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.PastryNode;
import rice.pastry.PastrySeed;
import rice.pastry.direct.DirectNodeHandle;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.direct.TestRecord;
import rice.pastry.messaging.Message;

public class EuclideanNetwork
implements NetworkSimulator {
    private Random rng = new Random(PastrySeed.getSeed());
    private HashMap nodeMap = new HashMap();
    private Vector msgQueue = new Vector();
    private TestRecord testRecord = null;

    public boolean isAlive(NodeId nid) {
        NodeRecord nr = (NodeRecord)this.nodeMap.get(nid);
        if (nr == null) {
            return true;
        }
        return nr.alive;
    }

    public TestRecord getTestRecord() {
        return this.testRecord;
    }

    public DirectNodeHandle getClosest(NodeId nid) {
        Iterator it = this.nodeMap.values().iterator();
        DirectNodeHandle bestHandle = null;
        int bestProx = Integer.MAX_VALUE;
        while (it.hasNext()) {
            NodeRecord itRecord = (NodeRecord)it.next();
            DirectNodeHandle itHandle = (DirectNodeHandle)itRecord.handles.elementAt(0);
            NodeId itId = itHandle.getNodeId();
            if (!itHandle.isAlive() || !itHandle.getLocalNode().isReady() || nid == itId || this.proximity(nid, itId) >= bestProx) continue;
            bestProx = this.proximity(nid, itId);
            bestHandle = itHandle;
        }
        return bestHandle;
    }

    public void setAlive(NodeId nid, boolean alive) {
        NodeRecord nr = (NodeRecord)this.nodeMap.get(nid);
        if (nr == null) {
            throw new Error("setting node alive for unknown node");
        }
        if (nr.alive != alive) {
            nr.alive = alive;
            DirectNodeHandle[] handles = nr.handles.toArray(new DirectNodeHandle[0]);
            for (int i = 0; i < handles.length; ++i) {
                if (alive) {
                    handles[i].notifyObservers(NodeHandle.DECLARED_LIVE);
                    continue;
                }
                handles[i].notifyObservers(NodeHandle.DECLARED_DEAD);
            }
        }
    }

    public void setTestRecord(TestRecord tr) {
        this.testRecord = tr;
    }

    public void registerNodeId(DirectNodeHandle nh) {
        NodeId nid = nh.getNodeId();
        if (this.nodeMap.get(nid) != null) {
            NodeRecord record = (NodeRecord)this.nodeMap.get(nid);
            record.handles.add(nh);
        } else {
            this.nodeMap.put(nid, new NodeRecord(nh));
        }
    }

    public int proximity(NodeId a, NodeId b) {
        NodeRecord nra = (NodeRecord)this.nodeMap.get(a);
        NodeRecord nrb = (NodeRecord)this.nodeMap.get(b);
        if (nra == null || nrb == null) {
            throw new Error("asking about node proximity for unknown node(s)");
        }
        return nra.proximity(nrb);
    }

    public void deliverMessage(Message msg, PastryNode node) {
        if (this.isAlive(msg.getSenderId())) {
            MessageDelivery md = new MessageDelivery(msg, node);
            this.msgQueue.addElement(md);
        }
    }

    public boolean simulate() {
        if (this.msgQueue.size() == 0) {
            return false;
        }
        MessageDelivery md = (MessageDelivery)this.msgQueue.firstElement();
        this.msgQueue.removeElementAt(0);
        md.deliver();
        return true;
    }

    private class NodeRecord {
        public int x;
        public int y;
        public boolean alive;
        public Vector handles;

        public NodeRecord(DirectNodeHandle nh) {
            this.x = EuclideanNetwork.this.rng.nextInt() % 10000;
            this.y = EuclideanNetwork.this.rng.nextInt() % 10000;
            this.alive = true;
            this.handles = new Vector();
            this.handles.add(nh);
        }

        public int proximity(NodeRecord nr) {
            int dx = this.x - nr.x;
            int dy = this.y - nr.y;
            return (int)Math.sqrt(dx * dx + dy * dy);
        }
    }

    private class MessageDelivery {
        private Message msg;
        private PastryNode node;

        public MessageDelivery(Message m, PastryNode pn) {
            this.msg = m;
            this.node = pn;
        }

        public void deliver() {
            if (EuclideanNetwork.this.isAlive(this.msg.getSenderId())) {
                this.node.receiveMessage(this.msg);
            }
        }
    }
}

