/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.dist;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetSocketAddress;
import java.util.Observable;
import java.util.Observer;
import rice.pastry.Log;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.dist.DistNodeHandle;
import rice.pastry.dist.DistPastryNode;
import rice.pastry.messaging.Message;

public abstract class DistCoalesedNodeHandle
extends DistNodeHandle {
    private transient boolean verified = false;
    private transient DistCoalesedNodeHandle redirect = null;
    protected transient boolean isInPool = false;
    protected transient int status = 1;
    protected transient boolean isLocal = false;
    private transient int distance = DEFAULT_DISTANCE;
    public static int DEFAULT_DISTANCE = Integer.MAX_VALUE;

    public DistCoalesedNodeHandle(NodeId nodeId, InetSocketAddress address) {
        super(nodeId, address);
    }

    public final int getLiveness() {
        this.verify();
        if (this.redirect != null) {
            return this.redirect.getLiveness();
        }
        if (this.isLocal && this.status != 1) {
            System.out.println("panic; local node dead");
        }
        return this.status;
    }

    public boolean getIsInPool() {
        return this.isInPool;
    }

    protected final void setProximity(int value) {
        this.distance = value;
        this.setChanged();
        this.notifyObservers(PROXIMITY_CHANGED);
    }

    public void setIsInPool(boolean iip) {
        this.isInPool = iip;
    }

    protected void setChanged() {
        this.verify();
        if (this.redirect != null) {
            this.redirect.setChanged();
        } else {
            super.setChanged();
        }
    }

    private final void verify() {
        if (!this.verified && this.getLocalNode() != null) {
            DistCoalesedNodeHandle nh = (DistCoalesedNodeHandle)((DistPastryNode)this.getLocalNode()).getNodeHandlePool().coalesce(this);
            if (nh != this) {
                this.redirect = nh;
            }
            this.verified = true;
        }
    }

    public void afterSetLocalNode() {
        this.status = 1;
        this.isLocal = this.nodeId != null && this.getLocalNode().getNodeId().equals(this.nodeId);
        this.verify();
    }

    public final void markAlive() {
        this.verify();
        if (this.redirect != null) {
            this.redirect.markAlive();
            return;
        }
        if (!this.isAlive()) {
            if (Log.ifp(5)) {
                System.out.println(this.getLocalNode() + "found " + this.nodeId + " to be alive after all");
            }
            this.status = 1;
            this.distance = Integer.MAX_VALUE;
            this.setChanged();
            this.notifyObservers(DECLARED_LIVE);
        }
    }

    public final void markDead() {
        this.verify();
        if (this.redirect != null) {
            this.redirect.markDead();
            return;
        }
        if (this.isAlive()) {
            if (Log.ifp(5)) {
                if (this.getLocalNode() == null) {
                    System.out.println("Incoming node handle " + this.nodeId + " found remote node to be dead");
                } else {
                    System.out.println(this.getLocalNode() + " found " + this.nodeId + " to be dead");
                }
            }
            this.status = 3;
            this.distance = Integer.MAX_VALUE;
            this.setChanged();
            this.notifyObservers(DECLARED_DEAD);
        }
    }

    public final int proximity() {
        this.verify();
        if (this.redirect != null) {
            return this.redirect.proximity();
        }
        if (this.isLocal) {
            return 0;
        }
        return this.distance;
    }

    public final boolean ping() {
        this.verify();
        if (this.redirect != null) {
            return this.redirect.pingImpl();
        }
        return this.pingImpl();
    }

    protected abstract boolean pingImpl();

    public final void receiveMessage(Message message) {
        this.verify();
        if (this.redirect != null) {
            this.redirect.receiveMessageImpl(message);
        } else {
            this.receiveMessageImpl(message);
        }
    }

    protected abstract void receiveMessageImpl(Message var1);

    public final String toString() {
        this.verify();
        if (this.redirect != null) {
            return this.redirect.toStringImpl();
        }
        return this.toStringImpl();
    }

    protected abstract String toStringImpl();

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof NodeHandle)) {
            return false;
        }
        NodeHandle nh = (NodeHandle)obj;
        return this.nodeId.equals(nh.getNodeId());
    }

    public int hashCode() {
        return this.nodeId.hashCode();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.verified = false;
        this.isInPool = false;
        this.status = 1;
        this.distance = DEFAULT_DISTANCE;
        this.isLocal = false;
    }

    protected void debug(String s) {
        if (Log.ifp(8)) {
            if (this.getLocalNode() != null) {
                System.out.println(this.getLocalNode().getNodeId() + " (" + this.nodeId + "): " + s);
            } else {
                System.out.println(this.getLocalNode() + " (" + this.nodeId + "): " + s);
            }
        }
    }

    public void addObserver(Observer o) {
        this.verify();
        if (this.redirect != null) {
            this.redirect.addObserver(o);
        } else {
            super.addObserver(o);
        }
    }

    public int countObservers() {
        this.verify();
        if (this.redirect != null) {
            return this.redirect.countObservers();
        }
        return super.countObservers();
    }

    public void deleteObserver(Observer o) {
        this.verify();
        if (this.redirect != null) {
            this.redirect.deleteObserver(o);
        } else {
            super.deleteObserver(o);
        }
    }

    public void deleteObservers() {
        this.verify();
        if (this.redirect != null) {
            this.redirect.deleteObservers();
        } else {
            super.deleteObservers();
        }
    }

    public boolean hasChanged() {
        this.verify();
        if (this.redirect != null) {
            return this.redirect.hasChanged();
        }
        return super.hasChanged();
    }

    public void notifyObservers() {
        this.verify();
        if (this.redirect != null) {
            this.redirect.notifyObservers();
        } else {
            super.notifyObservers();
        }
    }

    public void notifyObservers(Object arg) {
        this.verify();
        if (this.redirect != null) {
            this.redirect.notifyObservers(arg);
        } else {
            super.notifyObservers(arg);
        }
    }

    protected void clearChanged() {
        this.verify();
        if (this.redirect != null) {
            this.redirect.clearChanged();
        } else {
            super.clearChanged();
        }
    }

    public void update(Observable o, Object obj) {
        System.out.println("DistCoalesedNodeHandle::update(): should not be here!!!!");
    }
}

