/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.dist;

import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import rice.Continuation;
import rice.Executable;
import rice.pastry.ExponentialBackoffScheduledMessage;
import rice.pastry.NetworkListener;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.PastryNode;
import rice.pastry.ScheduledMessage;
import rice.pastry.dist.DistNodeHandlePool;
import rice.pastry.join.InitiateJoin;
import rice.pastry.leafset.InitiateLeafSetMaintenance;
import rice.pastry.messaging.Message;
import rice.pastry.routing.InitiateRouteSetMaintenance;
import rice.selector.SelectorManager;
import rice.selector.Timer;

public abstract class DistPastryNode
extends PastryNode {
    protected int leafSetMaintFreq;
    protected int routeSetMaintFreq;
    private Vector listeners = new Vector();
    private ScheduledMessage joinEvent;
    protected ScheduledMessage leafSetRoutineMaintenance = null;
    protected ScheduledMessage routeSetRoutineMaintenance = null;
    public static final boolean verbose = false;
    public static ProcessingQueue QUEUE = new ProcessingQueue();
    public static ProcessingThread THREAD = new ProcessingThread(QUEUE);
    protected static final Timer timer = SelectorManager.getSelectorManager().getTimer();
    private static Vector errors = new Vector();

    protected DistPastryNode(NodeId id) {
        super(id);
    }

    public Timer getTimer() {
        return timer;
    }

    protected NetworkListener[] getNetworkListeners() {
        return this.listeners.toArray(new NetworkListener[0]);
    }

    public abstract DistNodeHandlePool getNodeHandlePool();

    public void addNetworkListener(NetworkListener listener) {
        this.listeners.add(listener);
    }

    public void broadcastSentListeners(Object message, InetSocketAddress[] path, int size) {
        NetworkListener[] listeners = this.getNetworkListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].dataSent(message, path[path.length - 1], size);
        }
    }

    public void broadcastReceivedListeners(Object message, InetSocketAddress[] path, int size) {
        NetworkListener[] listeners = this.getNetworkListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].dataReceived(message, path[path.length - 1], size);
        }
    }

    public final void initiateJoin(NodeHandle bootstrap) {
        if (bootstrap != null) {
            this.joinEvent = this.scheduleMsgExpBackoff(new InitiateJoin(bootstrap), 0L, 15000L, 2.0);
        } else {
            this.setReady();
        }
    }

    public void nodeIsReady() {
        if (this.joinEvent != null) {
            this.joinEvent.cancel();
        }
    }

    public void doneNode(NodeHandle bootstrap) {
        if (this.routeSetMaintFreq > 0) {
            this.routeSetRoutineMaintenance = this.scheduleMsgAtFixedRate(new InitiateRouteSetMaintenance(), this.routeSetMaintFreq * 1000, this.routeSetMaintFreq * 1000);
        }
        if (this.leafSetMaintFreq > 0) {
            this.leafSetRoutineMaintenance = this.scheduleMsgAtFixedRate(new InitiateLeafSetMaintenance(), this.leafSetMaintFreq * 1000, this.leafSetMaintFreq * 1000);
        }
    }

    public void resign() {
        this.leafSetRoutineMaintenance.cancel();
        this.routeSetRoutineMaintenance.cancel();
    }

    public ScheduledMessage scheduleMsg(Message msg, long delay) {
        ScheduledMessage sm = new ScheduledMessage(this, msg);
        timer.schedule(sm, delay);
        return sm;
    }

    public ScheduledMessage scheduleMsg(Message msg, long delay, long period) {
        ScheduledMessage sm = new ScheduledMessage(this, msg);
        timer.schedule(sm, delay, period);
        return sm;
    }

    public ExponentialBackoffScheduledMessage scheduleMsgExpBackoff(Message msg, long delay, long initialPeriod, double expBase) {
        ExponentialBackoffScheduledMessage sm = new ExponentialBackoffScheduledMessage(this, msg, timer, delay, initialPeriod, expBase);
        return sm;
    }

    public ScheduledMessage scheduleMsgAtFixedRate(Message msg, long delay, long period) {
        ScheduledMessage sm = new ScheduledMessage(this, msg);
        timer.scheduleAtFixedRate(sm, delay, period);
        return sm;
    }

    public void process(Executable task, Continuation command) {
        QUEUE.enqueue(new ProcessingRequest(task, command));
    }

    public static String[] getErrors() {
        String[] result = errors.toArray(new String[0]);
        errors.clear();
        return result;
    }

    public static void addError(String error) {
        if (errors.size() > 20) {
            errors.removeElementAt(0);
        }
        errors.add(error);
    }

    static {
        THREAD.start();
        THREAD.setPriority(1);
    }

    public static class ProcessingQueueOverflowException
    extends Exception {
    }

    private static class ProcessingRequest {
        Continuation c;
        Executable r;

        public ProcessingRequest(Executable r, Continuation c) {
            this.r = r;
            this.c = c;
        }

        public void returnResult(Object o) {
            this.c.receiveResult(o);
        }

        public void returnError(Exception e) {
            this.c.receiveException(e);
        }

        public void run() {
            try {
                Object result = this.r.execute();
                SelectorManager.getSelectorManager().invoke(new Runnable(this, result){
                    private final /* synthetic */ Object val$result;
                    private final /* synthetic */ ProcessingRequest this$0;
                    {
                        this.this$0 = this$0;
                        this.val$result = val$result;
                    }

                    public void run() {
                        this.this$0.returnResult(this.val$result);
                    }

                    public String toString() {
                        return "return ProcessingRequest for " + this.this$0.r + " to " + this.this$0.c;
                    }
                });
            }
            catch (Exception e) {
                SelectorManager.getSelectorManager().invoke(new Runnable(this, e){
                    private final /* synthetic */ Exception val$e;
                    private final /* synthetic */ ProcessingRequest this$0;
                    {
                        this.this$0 = this$0;
                        this.val$e = val$e;
                    }

                    public void run() {
                        this.this$0.returnError(this.val$e);
                    }

                    public String toString() {
                        return "return ProcessingRequest for " + this.this$0.r + " to " + this.this$0.c;
                    }
                });
            }
        }
    }

    public static class ProcessingQueue {
        List q = new LinkedList();
        int capacity = -1;

        public ProcessingQueue() {
        }

        public ProcessingQueue(int capacity) {
            this.capacity = capacity;
        }

        public synchronized int getLength() {
            return this.q.size();
        }

        public synchronized void enqueue(ProcessingRequest request) {
            if (this.capacity < 0 || this.q.size() < this.capacity) {
                this.q.add(request);
                this.notifyAll();
            } else {
                request.returnError(new ProcessingQueueOverflowException());
            }
        }

        public synchronized ProcessingRequest dequeue() {
            while (this.q.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return (ProcessingRequest)this.q.remove(0);
        }
    }

    private static class ProcessingThread
    extends Thread {
        ProcessingQueue queue;

        public ProcessingThread(ProcessingQueue queue) {
            super("Dedicated Processing Thread");
            this.queue = queue;
        }

        public void run() {
            while (true) {
                ProcessingRequest e = this.queue.dequeue();
                e.run();
            }
        }
    }
}

