/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.dist;

import java.net.InetSocketAddress;
import java.util.Random;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.NodeIdFactory;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.socket.SocketPastryNodeFactory;

public abstract class DistPastryNodeFactory
extends PastryNodeFactory {
    public static int PROTOCOL_SOCKET;
    public static int PROTOCOL_DEFAULT;

    protected DistPastryNodeFactory() {
    }

    public final NodeHandle getNodeHandle(InetSocketAddress address) {
        return this.generateNodeHandle(address);
    }

    public final NodeHandle getNodeHandle(InetSocketAddress[] addresses) {
        int i;
        Random r = new Random();
        for (i = 0; i < addresses.length; ++i) {
            int j = r.nextInt(addresses.length);
            InetSocketAddress tmp = addresses[j];
            addresses[j] = addresses[i];
            addresses[i] = tmp;
        }
        for (i = 0; i < addresses.length; ++i) {
            NodeHandle result = this.getNodeHandle(addresses[i]);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public abstract NodeHandle generateNodeHandle(InetSocketAddress var1);

    public abstract PastryNode newNode(NodeHandle var1);

    public abstract PastryNode newNode(NodeHandle var1, NodeId var2);

    public abstract PastryNode newNode(NodeHandle var1, NodeId var2, InetSocketAddress var3);

    public abstract PastryNode newNode(NodeHandle var1, InetSocketAddress var2);

    public static DistPastryNodeFactory getFactory(NodeIdFactory nf, int protocol, int port) {
        if (protocol == PROTOCOL_SOCKET) {
            return new SocketPastryNodeFactory(nf, port);
        }
        throw new IllegalArgumentException("Unsupported Protocol " + protocol);
    }

    static {
        PROTOCOL_DEFAULT = PROTOCOL_SOCKET = 2;
    }
}

