/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.messaging;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import rice.pastry.messaging.Address;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.MessageReceiver;

public class MessageDispatch {
    private HashMap addressBook = new HashMap();
    private Hashtable buffer = new Hashtable();
    private int bufferCount = 0;
    public static int BUFFER_SIZE = 32;

    public MessageReceiver getDestination(Message msg) {
        MessageReceiver mr = (MessageReceiver)this.addressBook.get(msg.getDestination());
        return mr;
    }

    public MessageReceiver getDestinationByAddress(Address addr) {
        MessageReceiver mr = (MessageReceiver)this.addressBook.get(addr);
        return mr;
    }

    public void registerReceiver(Address address, MessageReceiver receiver) {
        if (this.addressBook.get(address) != null) {
            System.out.println("ERROR - Registering receiver for already-registered address " + address);
        }
        this.addressBook.put(address, receiver);
    }

    public boolean dispatchMessage(Message msg) {
        MessageReceiver mr = (MessageReceiver)this.addressBook.get(msg.getDestination());
        if (mr != null) {
            Address address = msg.getDestination();
            mr.receiveMessage(msg);
            this.deliverBuffered(address);
            return true;
        }
        if (this.bufferCount > BUFFER_SIZE) {
            System.out.println("Could not dispatch message " + msg + " because the application address " + msg.getDestination() + " was unknown.");
            System.out.println("Message is going to be dropped on the floor.");
        } else if (msg.getDestination() != null) {
            Vector<Message> vector = (Vector<Message>)this.buffer.get(msg.getDestination());
            if (vector == null) {
                vector = new Vector<Message>();
                this.buffer.put(msg.getDestination(), vector);
            }
            vector.add(msg);
            ++this.bufferCount;
        } else {
            System.out.println("Message " + msg + "," + msg.getClass().getName() + " has no destination.");
            Thread.dumpStack();
        }
        return false;
    }

    protected void deliverBuffered(Address address) {
        Vector vector = (Vector)this.buffer.remove(address);
        if (vector != null) {
            MessageReceiver mr = (MessageReceiver)this.addressBook.get(address);
            for (int i = 0; i < vector.size(); ++i) {
                mr.receiveMessage((Message)vector.elementAt(i));
                --this.bufferCount;
            }
        }
    }
}

