/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.routing;

import java.util.Observable;
import java.util.Observer;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.NodeSet;
import rice.pastry.routing.RouteSet;

public class RoutingTable
extends Observable
implements Observer {
    private NodeId myNodeId;
    public NodeHandle myNodeHandle;
    private RouteSet[][] routingTable;
    private int maxEntries;
    public static int idBaseBitLength = 4;

    public RoutingTable(NodeHandle me, int max) {
        this.myNodeId = me.getNodeId();
        this.myNodeHandle = me;
        this.maxEntries = max;
        int cols = 1 << idBaseBitLength;
        int rows = 160 / idBaseBitLength;
        this.routingTable = new RouteSet[rows][cols];
        for (int i = 0; i < rows; ++i) {
            int myCol = this.myNodeId.getDigit(i, idBaseBitLength);
            this.routingTable[i][myCol] = new RouteSet(this.maxEntries);
            this.routingTable[i][myCol].put(this.myNodeHandle);
            this.routingTable[i][myCol].addObserver(this);
        }
    }

    public RouteSet getRouteSet(int index, int digit) {
        RouteSet ns = this.routingTable[index][digit];
        return ns;
    }

    public RouteSet getBestEntry(Id key) {
        int diffDigit = this.myNodeId.indexOfMSDD(key, idBaseBitLength);
        if (diffDigit < 0) {
            return null;
        }
        int digit = key.getDigit(diffDigit, idBaseBitLength);
        return this.routingTable[diffDigit][digit];
    }

    public NodeHandle get(NodeId nid) {
        RouteSet ns = this.getBestEntry(nid);
        if (ns == null) {
            return null;
        }
        return ns.get(nid);
    }

    public RouteSet[] getRow(int i) {
        return this.routingTable[i];
    }

    public int numColumns() {
        return this.routingTable[0].length;
    }

    public int numRows() {
        return this.routingTable.length;
    }

    public NodeHandle bestAlternateRoute(Id key) {
        return this.bestAlternateRoute(2, key);
    }

    public NodeHandle bestAlternateRoute(int minLiveness, Id key) {
        int cols = 1 << idBaseBitLength;
        int diffDigit = this.myNodeId.indexOfMSDD(key, idBaseBitLength);
        if (diffDigit < 0) {
            return null;
        }
        int keyDigit = key.getDigit(diffDigit, idBaseBitLength);
        int myDigit = this.myNodeId.getDigit(diffDigit, idBaseBitLength);
        Id.Distance bestDistance = this.myNodeId.distance(key);
        NodeHandle alt = null;
        boolean finished = false;
        int i = 1;
        while (!finished) {
            for (int j = 0; j < 2; ++j) {
                int digit = j == 0 ? keyDigit + i & cols - 1 : keyDigit + cols - i & cols - 1;
                RouteSet rs = this.getRouteSet(diffDigit, digit);
                for (int k = 0; rs != null && k < rs.size(); ++k) {
                    Id.Distance nDist;
                    NodeHandle n = rs.get(k);
                    if (n.getLiveness() > minLiveness || bestDistance.compareTo(nDist = n.getNodeId().distance(key)) <= 0) continue;
                    bestDistance = nDist;
                    alt = n;
                }
                if (digit != myDigit) continue;
                finished = true;
            }
            ++i;
        }
        return alt;
    }

    public NodeSet alternateRoutes(Id key, int max) {
        NodeSet set = new NodeSet();
        int cols = 1 << idBaseBitLength;
        int diffDigit = this.myNodeId.indexOfMSDD(key, idBaseBitLength);
        if (diffDigit < 0) {
            return set;
        }
        int keyDigit = key.getDigit(diffDigit, idBaseBitLength);
        int myDigit = this.myNodeId.getDigit(diffDigit, idBaseBitLength);
        Id.Distance myDistance = this.myNodeId.distance(key);
        boolean finished = false;
        int count = 0;
        int i = 0;
        while (!finished) {
            for (int j = 0; j < 2; ++j) {
                int digit = j == 0 ? keyDigit + i & cols - 1 : keyDigit + cols - i & cols - 1;
                RouteSet rs = this.getRouteSet(diffDigit, digit);
                for (int k = 0; rs != null && k < rs.size(); ++k) {
                    NodeHandle n = rs.get(k);
                    if (!n.isAlive()) continue;
                    Id.Distance nDist = n.getNodeId().distance(key);
                    if (set == null || count >= max || myDistance.compareTo(nDist) <= 0) continue;
                    set.put(n);
                    ++count;
                }
                if (digit != myDigit) continue;
                finished = true;
            }
            ++i;
        }
        return set;
    }

    private RouteSet makeBestEntry(Id key) {
        int diffDigit = this.myNodeId.indexOfMSDD(key, idBaseBitLength);
        if (diffDigit < 0) {
            return null;
        }
        int digit = key.getDigit(diffDigit, idBaseBitLength);
        if (this.routingTable[diffDigit][digit] == null) {
            this.routingTable[diffDigit][digit] = new RouteSet(this.maxEntries);
            this.routingTable[diffDigit][digit].addObserver(this);
        }
        return this.routingTable[diffDigit][digit];
    }

    public void put(NodeHandle handle) {
        NodeId nid = handle.getNodeId();
        RouteSet ns = this.makeBestEntry(nid);
        if (ns != null) {
            ns.put(handle);
        }
    }

    public NodeHandle remove(NodeHandle nh) {
        RouteSet ns = this.getBestEntry(nh.getNodeId());
        if (ns == null) {
            return null;
        }
        return ns.remove(nh);
    }

    public void update(Observable o, Object arg) {
        this.setChanged();
        this.notifyObservers(arg);
    }

    public String toString() {
        String s = "routing table: \n";
        for (int i = this.routingTable.length - 1; i >= 0; --i) {
            for (int j = 0; j < this.routingTable[i].length; ++j) {
                s = this.routingTable[i][j] != null ? s + "" + this.routingTable[i][j].size() + "\t" : s + "0\t";
            }
            s = s + "\n";
        }
        return s;
    }

    public static int baseBitLength() {
        return idBaseBitLength;
    }
}

