/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import rice.pastry.Log;
import rice.pastry.PastryNode;
import rice.pastry.socket.EpochInetSocketAddress;
import rice.pastry.socket.PingResponseListener;
import rice.pastry.socket.SocketChannelRepeater;
import rice.pastry.socket.SocketNodeHandle;
import rice.pastry.socket.SocketNodeHandlePool;
import rice.pastry.socket.SocketPastryNode;
import rice.pastry.socket.SocketSourceRouteManager;
import rice.pastry.socket.SourceRoute;
import rice.pastry.socket.messaging.DatagramMessage;
import rice.pastry.socket.messaging.IPAddressRequestMessage;
import rice.pastry.socket.messaging.IPAddressResponseMessage;
import rice.pastry.socket.messaging.PingMessage;
import rice.pastry.socket.messaging.PingResponseMessage;
import rice.pastry.socket.messaging.WrongEpochMessage;
import rice.selector.SelectionKeyHandler;
import rice.selector.SelectorManager;

public class PingManager
extends SelectionKeyHandler {
    protected Hashtable pingListeners = new Hashtable();
    protected ArrayList pendingMsgs;
    private Hashtable pingtimes;
    private Hashtable pingResponseTimes;
    private Hashtable pings;
    private PastryNode spn;
    private ByteBuffer buffer;
    private DatagramChannel channel;
    private SelectionKey key;
    private SocketNodeHandlePool pool;
    private SocketSourceRouteManager manager;
    private EpochInetSocketAddress localAddress;
    protected static byte[] HEADER_PING = new byte[]{73, 58, 9, 92};
    public static int HEADER_SIZE = HEADER_PING.length;
    public static int DATAGRAM_RECEIVE_BUFFER_SIZE = 131072;
    public static int DATAGRAM_SEND_BUFFER_SIZE = 65536;
    public static int PING_THROTTLE = 600000;

    public PingManager(SocketNodeHandlePool pool, SocketSourceRouteManager manager, PastryNode spn, EpochInetSocketAddress bindAddress, EpochInetSocketAddress proxyAddress) {
        this.pool = pool;
        this.spn = spn;
        this.manager = manager;
        this.pings = new Hashtable();
        this.pingtimes = new Hashtable();
        this.pingResponseTimes = new Hashtable();
        this.pendingMsgs = new ArrayList();
        this.localAddress = proxyAddress;
        this.buffer = ByteBuffer.allocateDirect(DATAGRAM_SEND_BUFFER_SIZE);
        try {
            this.channel = DatagramChannel.open();
            this.channel.configureBlocking(false);
            this.channel.socket().bind(bindAddress.getAddress());
            this.channel.socket().setSendBufferSize(DATAGRAM_SEND_BUFFER_SIZE);
            this.channel.socket().setReceiveBufferSize(DATAGRAM_RECEIVE_BUFFER_SIZE);
            this.key = SelectorManager.getSelectorManager().register(this.channel, this, 1);
        }
        catch (IOException e) {
            System.out.println("PANIC: Error binding datagram server to address " + this.localAddress + ": " + e);
        }
    }

    public long getLastTimePinged(SourceRoute path) {
        return (Long)this.pingtimes.get(path);
    }

    public long getLastTimeHeardFrom(SourceRoute path) {
        Long l = (Long)this.pingResponseTimes.get(path);
        if (l != null) {
            return l;
        }
        return 0L;
    }

    public void resign() throws IOException {
        this.key.channel().close();
        this.key.cancel();
    }

    protected void resetLastTimePinged(SourceRoute path) {
        this.pingtimes.remove(path);
    }

    public int proximity(SourceRoute path) {
        Integer i = (Integer)this.pings.get(path);
        if (i == null) {
            return SocketNodeHandle.DEFAULT_PROXIMITY;
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPingResponseListener(SourceRoute path, PingResponseListener prl) {
        if (prl == null) {
            return;
        }
        Hashtable hashtable = this.pingResponseTimes;
        synchronized (hashtable) {
            ArrayList<PingResponseListener> list = (ArrayList<PingResponseListener>)this.pingListeners.get(path);
            if (list == null) {
                list = new ArrayList<PingResponseListener>();
                this.pingListeners.put(path, list);
            }
            list.add(prl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(SourceRoute path, Object msg) {
        try {
            byte[] data = PingManager.addHeader(path, msg, this.localAddress);
            ArrayList arrayList = this.pendingMsgs;
            synchronized (arrayList) {
                this.pendingMsgs.add(new Envelope(path.getFirstHop(), data));
            }
            if (this.spn != null && this.spn instanceof SocketPastryNode) {
                ((SocketPastryNode)this.spn).broadcastSentListeners(msg, path.toArray(), data.length);
            }
            SelectorManager.getSelectorManager().modifyKey(this.key);
        }
        catch (IOException e) {
            System.out.println("ERROR: Received exceptoin " + e + " while enqueuing ping " + msg);
        }
    }

    public void receiveMessage(Object message, int size, InetSocketAddress from) throws IOException {
        if (message instanceof DatagramMessage) {
            DatagramMessage dm = (DatagramMessage)message;
            long start = dm.getStartTime();
            SourceRoute path = dm.getInboundPath();
            if (path == null) {
                path = SourceRoute.build(new EpochInetSocketAddress(from));
            }
            if (this.spn != null && this.spn instanceof SocketPastryNode) {
                ((SocketPastryNode)this.spn).broadcastReceivedListeners(dm, path.reverse().toArray(), size);
            }
            if (dm instanceof PingMessage) {
                this.enqueue(dm.getInboundPath(), new PingResponseMessage(dm.getOutboundPath(), dm.getInboundPath(), start));
            } else if (dm instanceof PingResponseMessage) {
                long curTime = System.currentTimeMillis();
                int time = (int)(curTime - start);
                if (this.pings.get(dm.getOutboundPath()) == null || (Integer)this.pings.get(dm.getOutboundPath()) > time) {
                    this.pings.put(dm.getOutboundPath(), new Integer(time));
                    this.manager.markProximity(dm.getOutboundPath(), time);
                }
                this.pingResponse(dm.getOutboundPath(), curTime);
            } else if (dm instanceof WrongEpochMessage) {
                WrongEpochMessage wem = (WrongEpochMessage)dm;
                System.out.println("----- INFO: Received wrong epoch update from " + wem.getCorrect() + " was " + wem.getIncorrect());
                this.manager.markAlive(dm.getOutboundPath());
                this.manager.markDead(wem.getIncorrect());
            } else if (dm instanceof IPAddressRequestMessage) {
                this.enqueue(SourceRoute.build(new EpochInetSocketAddress(from)), new IPAddressResponseMessage(from));
            } else {
                System.out.println("ERROR: Received unknown DatagramMessage " + dm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pingResponse(SourceRoute path, long curTime) {
        Hashtable hashtable = this.pingResponseTimes;
        synchronized (hashtable) {
            this.manager.markAlive(path);
            this.pingResponseTimes.put(path, new Long(curTime));
            this.notifyPingResponseListeners(path, this.proximity(path), curTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(SelectionKey key) {
        try {
            try {
                ArrayList arrayList = this.pendingMsgs;
                synchronized (arrayList) {
                    Iterator i = this.pendingMsgs.iterator();
                    while (i.hasNext()) {
                        Envelope write = (Envelope)i.next();
                        if (this.channel.send(ByteBuffer.wrap(write.data), write.destination.getAddress()) != write.data.length) break;
                        i.remove();
                    }
                }
            }
            catch (IOException e) {
                System.err.println("ERROR (datagrammanager:write): " + e);
                Object var7_7 = null;
                if (!this.pendingMsgs.isEmpty()) return;
                key.interestOps(key.interestOps() & 0xFFFFFFFB);
                return;
            }
            Object var7_6 = null;
            if (!this.pendingMsgs.isEmpty()) return;
            key.interestOps(key.interestOps() & 0xFFFFFFFB);
            return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (!this.pendingMsgs.isEmpty()) throw throwable;
            key.interestOps(key.interestOps() & 0xFFFFFFFB);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyKey(SelectionKey key) {
        ArrayList arrayList = this.pendingMsgs;
        synchronized (arrayList) {
            if (!this.pendingMsgs.isEmpty()) {
                key.interestOps(key.interestOps() | 4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(SelectionKey key) {
        try {
            InetSocketAddress address = null;
            while ((address = (InetSocketAddress)this.channel.receive(this.buffer)) != null) {
                this.buffer.flip();
                if (this.buffer.remaining() > 0) {
                    this.readHeader(address);
                    continue;
                }
                this.debug("Read from datagram channel, but no bytes were there - no bad, but wierd.");
                break;
            }
        }
        catch (IOException e) {
            System.out.println("ERROR (datagrammanager:read): " + e);
            e.printStackTrace();
        }
        finally {
            this.buffer.clear();
        }
    }

    public void ping(SourceRoute path, PingResponseListener prl) {
        this.ping(path, prl, false);
    }

    protected void forcePing(SourceRoute path, PingResponseListener prl) {
        this.ping(path, prl, true);
    }

    protected void notifyPingResponseListeners(SourceRoute path, int proximity, long lastTimePinged) {
        ArrayList list = (ArrayList)this.pingListeners.get(path);
        if (list != null) {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                ((PingResponseListener)i.next()).pingResponse(path, proximity, lastTimePinged);
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ping(SourceRoute path, PingResponseListener prl, boolean force) {
        Hashtable hashtable = this.pingResponseTimes;
        synchronized (hashtable) {
            if (force || this.pingtimes.get(path) == null || System.currentTimeMillis() - this.getLastTimePinged(path) > (long)PING_THROTTLE) {
                this.pingtimes.put(path, new Long(System.currentTimeMillis()));
                this.addPingResponseListener(path, prl);
                this.debug("Actually sending ping via path " + path + " local " + this.localAddress);
                this.enqueue(path, new PingMessage(path, path.reverse(this.localAddress)));
            } else if (this.getLastTimeHeardFrom(path) >= this.getLastTimePinged(path)) {
                if (prl != null) {
                    prl.pingResponse(path, this.proximity(path), this.getLastTimeHeardFrom(path));
                }
            } else {
                this.addPingResponseListener(path, prl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readHeader(InetSocketAddress address) throws IOException {
        byte[] header = new byte[HEADER_SIZE];
        this.buffer.get(header);
        if (!Arrays.equals(header, HEADER_PING)) {
            System.out.println("WARNING: Received unrecognized message header - ignoring.");
            throw new IOException("Improper message header received - ignoring. Read " + header[0] + " " + header[1] + " " + header[2] + " " + header[3]);
        }
        byte[] metadata = new byte[2];
        this.buffer.get(metadata);
        byte[] route = new byte[SocketChannelRepeater.HEADER_BUFFER_SIZE * metadata[1]];
        this.buffer.get(route);
        EpochInetSocketAddress eisa = SocketChannelRepeater.decodeHeader(route, metadata[0]);
        if (eisa.equals(this.localAddress) || eisa.getAddress().equals(this.localAddress.getAddress()) && eisa.getEpoch() == -1L) {
            if (metadata[0] + 1 == metadata[1]) {
                byte[] array = new byte[this.buffer.remaining()];
                this.buffer.get(array);
                this.buffer.clear();
                this.receiveMessage(PingManager.deserialize(array), array.length, address);
                return;
            }
            EpochInetSocketAddress next = SocketChannelRepeater.decodeHeader(route, metadata[0] + 1);
            this.buffer.position(0);
            byte[] packet = new byte[this.buffer.remaining()];
            this.buffer.get(packet);
            int n = HEADER_SIZE;
            packet[n] = (byte)(packet[n] + 1);
            ArrayList arrayList = this.pendingMsgs;
            synchronized (arrayList) {
                this.pendingMsgs.add(new Envelope(next, packet));
            }
            SelectorManager.getSelectorManager().modifyKey(this.key);
            return;
        }
        if (!eisa.getAddress().equals(this.localAddress.getAddress())) {
            System.out.println("WARNING: Received packet destined for EISA (" + metadata[0] + " " + metadata[1] + ") " + eisa + " but the local address is " + this.localAddress + " - dropping silently.");
            throw new IOException("Received packet destined for EISA (" + metadata[0] + " " + metadata[1] + ") " + eisa + " but the local address is " + this.localAddress + " - dropping silently.");
        }
        SourceRoute back = SourceRoute.build(new EpochInetSocketAddress[0]);
        SourceRoute outbound = SourceRoute.build(new EpochInetSocketAddress[0]);
        int i = 0;
        while (true) {
            if (i >= metadata[0]) {
                outbound = outbound.append(this.localAddress);
                this.enqueue(back.reverse(), new WrongEpochMessage(outbound, back.reverse(), eisa, this.localAddress));
                return;
            }
            back = back.append(SocketChannelRepeater.decodeHeader(route, i));
            if (i > 0) {
                outbound = outbound.append(SocketChannelRepeater.decodeHeader(route, i));
            }
            ++i;
        }
    }

    private void debug(String s) {
        if (Log.ifp(8)) {
            System.out.println(this.spn.getNodeId() + " (PM): " + s);
        }
    }

    public static byte[] serialize(Object message) throws IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(message);
            oos.close();
            return baos.toByteArray();
        }
        catch (InvalidClassException e) {
            System.out.println("PANIC: Object to be serialized was an invalid class!");
            throw new IOException("Invalid class during attempt to serialize.");
        }
        catch (NotSerializableException e) {
            System.out.println("PANIC: Object to be serialized was not serializable! [" + message + "]");
            throw new IOException("Unserializable class " + message + " during attempt to serialize.");
        }
    }

    public static byte[] addHeader(SourceRoute path, Object data, EpochInetSocketAddress localAddress) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.write(HEADER_PING);
        dos.write(1);
        dos.write((byte)path.getNumHops() + 1);
        dos.write(SocketChannelRepeater.encodeHeader(localAddress));
        for (int i = 0; i < path.getNumHops(); ++i) {
            dos.write(SocketChannelRepeater.encodeHeader(path.getHop(i)));
        }
        dos.write(PingManager.serialize(data));
        dos.flush();
        return baos.toByteArray();
    }

    public static Object deserialize(byte[] array) throws IOException {
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(array));
        try {
            return ois.readObject();
        }
        catch (ClassNotFoundException e) {
            System.out.println("PANIC: Unknown class type in serialized message!");
            throw new IOException("Unknown class type in message - closing channel.");
        }
        catch (InvalidClassException e) {
            System.out.println("PANIC: Serialized message was an invalid class!");
            throw new IOException("Invalid class in message - closing channel.");
        }
    }

    public class Envelope {
        protected EpochInetSocketAddress destination;
        protected byte[] data;

        public Envelope(EpochInetSocketAddress destination, byte[] data) {
            this.destination = destination;
            this.data = data;
        }
    }
}

