/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import rice.Continuation;
import rice.Executable;
import rice.pastry.Log;
import rice.pastry.PastryNode;
import rice.pastry.commonapi.PastryEndpointMessage;
import rice.pastry.messaging.Message;
import rice.pastry.routing.RouteMessage;
import rice.pastry.socket.SocketPastryNode;
import rice.pastry.socket.SourceRoute;

public class SocketChannelReader {
    private PastryNode spn;
    private int objectSize = -1;
    private ByteBuffer buffer;
    private ByteBuffer sizeBuffer;
    protected SourceRoute path;
    public static final int SELECTOR_DESERIALIZATION_MAX_SIZE = 100000;

    public SocketChannelReader(PastryNode spn, SourceRoute path) {
        this.spn = spn;
        this.path = path;
        this.sizeBuffer = ByteBuffer.allocateDirect(4);
    }

    protected void setPath(SourceRoute path) {
        this.path = path;
    }

    public Object read(final SocketChannel sc) throws IOException {
        int read;
        if (this.objectSize == -1) {
            read = sc.read(this.sizeBuffer);
            if (read == -1) {
                throw new IOException("Error on read - the channel has been closed.");
            }
            if (this.sizeBuffer.remaining() == 0) {
                this.initializeObjectBuffer();
            } else {
                return null;
            }
        }
        if (this.objectSize != -1) {
            read = sc.read(this.buffer);
            this.debug("Read " + read + " bytes of object..." + this.buffer.remaining());
            if (read == -1) {
                throw new ClosedChannelException();
            }
            if (this.buffer.remaining() == 0) {
                this.buffer.flip();
                final byte[] objectArray = new byte[this.objectSize];
                this.buffer.get(objectArray);
                final int size = this.objectSize + 4;
                this.reset();
                if (size < 100000) {
                    Object obj = this.deserialize(objectArray);
                    if (obj != null) {
                        this.debug("Deserialized bytes into object " + obj);
                        if (this.spn != null && this.spn instanceof SocketPastryNode) {
                            InetSocketAddress[] inetSocketAddressArray;
                            SocketPastryNode socketPastryNode = (SocketPastryNode)this.spn;
                            if (this.path == null) {
                                InetSocketAddress[] inetSocketAddressArray2 = new InetSocketAddress[1];
                                inetSocketAddressArray = inetSocketAddressArray2;
                                inetSocketAddressArray2[0] = (InetSocketAddress)sc.socket().getRemoteSocketAddress();
                            } else {
                                inetSocketAddressArray = this.path.toArray();
                            }
                            socketPastryNode.broadcastReceivedListeners(obj, inetSocketAddressArray, size);
                        }
                        this.record(obj, size, this.path);
                        return obj;
                    }
                } else {
                    ((SocketPastryNode)this.spn).process(new Executable(){

                        public String toString() {
                            return "Deserialization of message of size " + size + " from " + SocketChannelReader.this.path;
                        }

                        public Object execute() {
                            try {
                                return SocketChannelReader.this.deserialize(objectArray);
                            }
                            catch (Exception e) {
                                return e;
                            }
                        }
                    }, new Continuation(){

                        public void receiveResult(Object o) {
                            if (SocketChannelReader.this.spn != null && SocketChannelReader.this.spn instanceof SocketPastryNode) {
                                InetSocketAddress[] inetSocketAddressArray;
                                SocketPastryNode socketPastryNode = (SocketPastryNode)SocketChannelReader.this.spn;
                                if (SocketChannelReader.this.path == null) {
                                    InetSocketAddress[] inetSocketAddressArray2 = new InetSocketAddress[1];
                                    inetSocketAddressArray = inetSocketAddressArray2;
                                    inetSocketAddressArray2[0] = (InetSocketAddress)sc.socket().getRemoteSocketAddress();
                                } else {
                                    inetSocketAddressArray = SocketChannelReader.this.path.toArray();
                                }
                                socketPastryNode.broadcastReceivedListeners(o, inetSocketAddressArray, size);
                            }
                            SocketChannelReader.this.record(o, size, SocketChannelReader.this.path);
                            if (o instanceof Message) {
                                SocketChannelReader.this.spn.receiveMessage((Message)o);
                            } else {
                                this.receiveException((Exception)o);
                            }
                        }

                        public void receiveException(Exception e) {
                            System.err.println("Processing deserialization of message caused exception " + e);
                            e.printStackTrace();
                        }
                    });
                }
            }
        }
        return null;
    }

    protected void record(Object obj, int size, SourceRoute path) {
        boolean recorded = false;
        try {
            if (obj instanceof RouteMessage) {
                this.record(((RouteMessage)obj).unwrap(), size, path);
                recorded = true;
            } else if (obj instanceof PastryEndpointMessage) {
                this.record(((PastryEndpointMessage)obj).getMessage(), size, path);
                recorded = true;
            }
        }
        catch (NoClassDefFoundError exc) {
            // empty catch block
        }
        if (!recorded) {
            // empty if block
        }
    }

    public void reset() {
        this.objectSize = -1;
        this.buffer = null;
        this.sizeBuffer.clear();
    }

    private void initializeObjectBuffer() throws IOException {
        this.sizeBuffer.flip();
        byte[] sizeArray = new byte[4];
        this.sizeBuffer.get(sizeArray, 0, 4);
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(sizeArray));
        this.objectSize = dis.readInt();
        if (this.objectSize <= 0) {
            throw new IOException("Found message of improper number of bytes - " + this.objectSize + " bytes");
        }
        this.debug("Found object of " + this.objectSize + " bytes");
        this.buffer = ByteBuffer.allocateDirect(this.objectSize);
    }

    private Object deserialize(byte[] array) throws IOException {
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(array));
        Object o = null;
        try {
            return ois.readObject();
        }
        catch (ClassCastException e) {
            System.out.println("PANIC: Serialized message was not a pastry message!");
            throw new IOException("Message recieved " + o + " was not a pastry message - closing channel.");
        }
        catch (ClassNotFoundException e) {
            System.out.println("PANIC: Unknown class type in serialized message!");
            throw new IOException("Unknown class type in message - closing channel.");
        }
        catch (InvalidClassException e) {
            System.out.println("PANIC: Serialized message was an invalid class! " + e.getMessage());
            throw new IOException("Invalid class in message - closing channel.");
        }
        catch (IllegalStateException e) {
            System.out.println("PANIC: Serialized message caused an illegal state exception! " + e.getMessage());
            throw new IOException("Illegal state from deserializing message - closing channel.");
        }
        catch (NullPointerException e) {
            System.out.println("PANIC: Serialized message caused a null pointer exception! " + e.getMessage());
            return null;
        }
        catch (Exception e) {
            System.out.println("PANIC: Serialized message caused exception! " + e.getMessage());
            throw new IOException("Exception from deserializing message - closing channel.");
        }
    }

    private void debug(String s) {
        if (Log.ifp(8)) {
            if (this.spn == null) {
                System.out.println("(R): " + s);
            } else {
                System.out.println(this.spn.getNodeId() + " (R): " + s);
            }
        }
    }
}

