/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import rice.pastry.Log;
import rice.pastry.PastryNode;
import rice.pastry.socket.EpochInetSocketAddress;
import rice.pastry.socket.SocketCollectionManager;

public class SocketChannelRepeater {
    private boolean connected;
    private PastryNode spn;
    private SocketChannel original;
    private SocketCollectionManager.SourceRouteManager manager;
    private ByteBuffer buffer1;
    private ByteBuffer buffer2;
    private ByteBuffer headerBuffer;
    protected static int REPEATER_BUFFER_SIZE = 65536;
    protected static int HEADER_BUFFER_SIZE = 16;

    public SocketChannelRepeater(PastryNode spn, SocketCollectionManager.SourceRouteManager manager) {
        this.spn = spn;
        this.manager = manager;
        this.headerBuffer = ByteBuffer.allocateDirect(HEADER_BUFFER_SIZE);
        this.buffer1 = ByteBuffer.allocateDirect(REPEATER_BUFFER_SIZE);
        this.buffer2 = ByteBuffer.allocateDirect(REPEATER_BUFFER_SIZE);
    }

    private ByteBuffer getBuffer(SocketChannel sc, boolean reading) {
        if (reading == (sc == this.original)) {
            return this.buffer1;
        }
        return this.buffer2;
    }

    public boolean read(SocketChannel sc) throws IOException {
        if (this.original == null) {
            this.original = sc;
        }
        if (!this.connected) {
            int read = sc.read(this.headerBuffer);
            if (read == -1) {
                throw new IOException("Error on read - the channel has been closed.");
            }
            if (this.headerBuffer.remaining() == 0) {
                this.processHeaderBuffer();
            } else {
                return false;
            }
        }
        ByteBuffer buffer = this.getBuffer(sc, true);
        int read = sc.read(buffer);
        this.debug("Read " + read + " bytes of data..." + buffer.remaining());
        if (read == -1) {
            throw new ClosedChannelException();
        }
        if (read > 0) {
            buffer.flip();
            return true;
        }
        return false;
    }

    public boolean write(SocketChannel sc) throws IOException {
        ByteBuffer buffer = this.getBuffer(sc, false);
        int j = buffer.limit();
        int i = sc.write(buffer);
        this.debug("Wrote " + i + " of " + j + " bytes to " + sc.socket().getRemoteSocketAddress());
        if (buffer.remaining() == 0) {
            buffer.flip();
            buffer.clear();
            return true;
        }
        return false;
    }

    private void processHeaderBuffer() throws IOException {
        this.headerBuffer.flip();
        byte[] headerArray = new byte[HEADER_BUFFER_SIZE];
        this.headerBuffer.get(headerArray);
        EpochInetSocketAddress address = SocketChannelRepeater.decodeHeader(headerArray);
        this.manager.createConnection(address);
        this.debug("Read address " + address);
        this.connected = true;
    }

    private void debug(String s) {
        if (Log.ifp(8)) {
            System.out.println(this.spn.getNodeId() + " (SCR): " + s);
        }
    }

    public static byte[] encodeHeader(EpochInetSocketAddress address) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.write(address.getAddress().getAddress().getAddress());
            dos.writeInt(address.getAddress().getPort());
            dos.writeLong(address.getEpoch());
            dos.flush();
            return baos.toByteArray();
        }
        catch (IOException canthappen) {
            System.err.println("PANIC: SHOULDN'T HAPPEN " + canthappen);
            return null;
        }
    }

    public static EpochInetSocketAddress decodeHeader(byte[] array) throws IOException {
        return SocketChannelRepeater.decodeHeader(array, 0);
    }

    public static EpochInetSocketAddress decodeHeader(byte[] array, int offset) throws IOException {
        byte[] ip = new byte[4];
        byte[] skip = new byte[HEADER_BUFFER_SIZE];
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(array));
        for (int i = 0; i < offset; ++i) {
            dis.readFully(skip);
        }
        dis.readFully(ip);
        int port = dis.readInt();
        long epoch = dis.readLong();
        if (port <= 0 || port >= 65536) {
            throw new IOException("Found inet address with improper port - " + port);
        }
        return new EpochInetSocketAddress(new InetSocketAddress(InetAddress.getByAddress(ip), port), epoch);
    }
}

