/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import rice.pastry.Log;
import rice.pastry.PastryNode;
import rice.pastry.commonapi.PastryEndpointMessage;
import rice.pastry.dist.DistPastryNode;
import rice.pastry.messaging.Message;
import rice.pastry.routing.RouteMessage;
import rice.pastry.socket.SocketPastryNode;
import rice.pastry.socket.SourceRoute;

public class SocketChannelWriter {
    private PastryNode spn;
    private ByteBuffer buffer;
    private LinkedList queue;
    protected SourceRoute path;
    private static boolean logWriteTypes = false;
    private static Object statLock = new Object();
    private static HashMap msgTypes = new HashMap();
    private static HashMap msgSizes = new HashMap();
    private static long statsLastWritten = System.currentTimeMillis();
    private static long statsWriteInterval = 60000L;
    private static long numWrites = 0L;
    public static int MAXIMUM_QUEUE_LENGTH = 128;

    public SocketChannelWriter(PastryNode spn, SourceRoute path) {
        this.spn = spn;
        this.path = path;
        this.queue = new LinkedList();
    }

    public boolean isEmpty() {
        return this.buffer == null && this.queue.size() == 0;
    }

    public LinkedList getQueue() {
        return this.queue;
    }

    protected void setPath(SourceRoute path) {
        this.path = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enqueue(Object o) {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            this.addToQueue(o);
            if (this.queue.size() > MAXIMUM_QUEUE_LENGTH) {
                Object remove = this.queue.removeLast();
                System.err.println(this.spn.getNodeId() + " (W): Maximum TCP queue length reached to " + this.path + " - message " + remove + " will be dropped.");
                return false;
            }
            if (this.queue.size() > 20) {
                System.err.println(this.spn.getNodeId() + "  ERROR: Queue to " + this.path + " has more than 20 elements - probably a bad sign - enqueue of " + o);
                DistPastryNode.addError("WARNING: Outgoing queue has " + this.queue.size() + " elements, enqueuing " + o);
            }
        }
        return true;
    }

    public void reset() {
        this.queue = new LinkedList();
        this.buffer = null;
    }

    protected void record(String action, Object obj, int size, SourceRoute path) {
        boolean recorded = false;
        try {
            if (obj instanceof RouteMessage) {
                this.record(action, ((RouteMessage)obj).unwrap(), size, path);
                recorded = true;
            } else if (obj instanceof PastryEndpointMessage) {
                this.record(action, ((PastryEndpointMessage)obj).getMessage(), size, path);
                recorded = true;
            }
        }
        catch (NoClassDefFoundError exc) {
            // empty catch block
        }
        if (!recorded) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean write(SocketChannel sc) throws IOException {
        while (true) {
            LinkedList linkedList = this.queue;
            synchronized (linkedList) {
                if (this.buffer == null) {
                    if (this.queue.isEmpty()) {
                        return true;
                    }
                    this.debug("About to serialize object " + this.queue.getFirst());
                    this.buffer = SocketChannelWriter.serialize(this.queue.getFirst());
                    if (this.buffer == null) {
                        LinkedList linkedList2 = this.queue;
                        synchronized (linkedList2) {
                            this.queue.removeFirst();
                            return this.write(sc);
                        }
                    }
                    if (this.spn != null && this.spn instanceof SocketPastryNode) {
                        InetSocketAddress[] inetSocketAddressArray;
                        SocketPastryNode socketPastryNode = (SocketPastryNode)this.spn;
                        Object e = this.queue.getFirst();
                        if (this.path == null) {
                            InetSocketAddress[] inetSocketAddressArray2 = new InetSocketAddress[1];
                            inetSocketAddressArray = inetSocketAddressArray2;
                            inetSocketAddressArray2[0] = (InetSocketAddress)sc.socket().getRemoteSocketAddress();
                        } else {
                            inetSocketAddressArray = this.path.toArray();
                        }
                        socketPastryNode.broadcastSentListeners(e, inetSocketAddressArray, this.buffer.limit());
                    }
                    this.record("Sent", this.queue.getFirst(), this.buffer.limit(), this.path);
                }
                int j = this.buffer.limit();
                int i = sc.write(this.buffer);
                this.record("Wrote " + i + " of " + j + " bytes of", this.queue.getFirst(), this.buffer.limit(), this.path);
                this.debug("Wrote " + i + " of " + j + " bytes to " + sc.socket().getRemoteSocketAddress());
                if (this.buffer.remaining() != 0) {
                    return false;
                }
                if (this.spn != null) {
                    this.debug("Finished writing message " + this.queue.getFirst() + " - queue now contains " + (this.queue.size() - 1) + " items");
                }
                LinkedList linkedList3 = this.queue;
                synchronized (linkedList3) {
                    this.queue.removeFirst();
                    this.buffer = null;
                }
            }
        }
    }

    private void addToQueue(Object o) {
        this.record("Enqueued", o, -1, this.path);
        if (this.queue.size() > 0 && o instanceof Message) {
            Object obj;
            int i;
            for (i = 1; !(i >= this.queue.size() || (obj = this.queue.get(i)) instanceof Message && ((Message)obj).getPriority() > ((Message)o).getPriority()); ++i) {
            }
            this.queue.add(i, o);
        } else {
            this.queue.addLast(o);
        }
    }

    private void debug(String s) {
        if (Log.ifp(8)) {
            if (this.spn == null) {
                System.out.println("(W): " + s);
            } else {
                System.out.println(this.spn.getNodeId() + " (W): " + s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer serialize(Object o) throws IOException {
        if (o == null) {
            return null;
        }
        if (o instanceof byte[]) {
            return ByteBuffer.wrap((byte[])o);
        }
        if (logWriteTypes) {
            Object object = statLock;
            synchronized (object) {
                long now = System.currentTimeMillis();
                if (statsLastWritten / statsWriteInterval != now / statsWriteInterval) {
                    System.out.println("@L.TR interval=" + statsLastWritten + "-" + now + " numWrites=" + numWrites);
                    statsLastWritten = now;
                    Iterator ii = msgTypes.keySet().iterator();
                    while (ii.hasNext()) {
                        String s = (String)ii.next();
                        System.out.println("@L.TR   " + s + ":" + msgTypes.get(s) + " " + msgSizes.get(s));
                    }
                    msgTypes.clear();
                    msgSizes.clear();
                }
            }
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(o);
            oos.close();
            int len = baos.toByteArray().length;
            if (logWriteTypes) {
                Object newO = o;
                if (newO instanceof RouteMessage) {
                    newO = ((RouteMessage)newO).unwrap();
                }
                if (newO instanceof PastryEndpointMessage) {
                    newO = ((PastryEndpointMessage)newO).getMessage();
                }
                String oType = newO.getClass().getName();
                SocketChannelWriter.logMessageSent(oType, len);
            }
            ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos2);
            dos.writeInt(len);
            dos.flush();
            dos.write(baos.toByteArray());
            dos.flush();
            return ByteBuffer.wrap(baos2.toByteArray());
        }
        catch (InvalidClassException e) {
            System.out.println("PANIC: Object to be serialized was an invalid class!");
            throw new IOException("Invalid class during attempt to serialize.");
        }
        catch (NotSerializableException e) {
            System.out.println("PANIC: Object to be serialized was not serializable! [" + o + "]");
            throw new IOException("Unserializable class during attempt to serialize.");
        }
        catch (NullPointerException e) {
            System.out.println("PANIC: Object to be serialized caused null pointer exception! [" + o + "]");
            return null;
        }
        catch (Exception e) {
            System.out.println("PANIC: Object to be serialized caused excception! [" + e + "]");
            throw new IOException("Exception during attempt to serialize.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void logMessageSent(String className, int sizeInBytes) {
        Object object = statLock;
        synchronized (object) {
            Integer it = (Integer)msgTypes.get(className);
            if (it == null) {
                msgTypes.put(className, new Integer(1));
            } else {
                msgTypes.put(className, new Integer(it + 1));
            }
            Long is = (Long)msgSizes.get(className);
            if (is == null) {
                msgSizes.put(className, new Long(sizeInBytes));
            } else {
                msgSizes.put(className, new Long(is + (long)sizeInBytes));
            }
            ++numWrites;
        }
    }
}

