/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import rice.pastry.Log;
import rice.pastry.PastryNode;
import rice.pastry.messaging.Message;
import rice.pastry.socket.EpochInetSocketAddress;
import rice.pastry.socket.PingManager;
import rice.pastry.socket.PingResponseListener;
import rice.pastry.socket.SocketChannelReader;
import rice.pastry.socket.SocketChannelRepeater;
import rice.pastry.socket.SocketChannelWriter;
import rice.pastry.socket.SocketNodeHandlePool;
import rice.pastry.socket.SocketPastryNode;
import rice.pastry.socket.SocketSourceRouteManager;
import rice.pastry.socket.SourceRoute;
import rice.pastry.socket.messaging.LeafSetRequestMessage;
import rice.pastry.socket.messaging.LeafSetResponseMessage;
import rice.pastry.socket.messaging.NodeIdRequestMessage;
import rice.pastry.socket.messaging.NodeIdResponseMessage;
import rice.pastry.socket.messaging.RouteRowRequestMessage;
import rice.pastry.socket.messaging.RouteRowResponseMessage;
import rice.pastry.socket.messaging.RoutesRequestMessage;
import rice.pastry.socket.messaging.RoutesResponseMessage;
import rice.selector.SelectionKeyHandler;
import rice.selector.SelectorManager;
import rice.selector.TimerTask;

public class SocketCollectionManager
extends SelectionKeyHandler {
    private PastryNode pastryNode;
    private EpochInetSocketAddress localAddress;
    private LinkedList socketQueue;
    private Hashtable sockets;
    private LinkedList sourceRouteQueue;
    private SelectionKey key;
    private PingManager pingManager;
    private SocketSourceRouteManager manager;
    private boolean resigned;
    private Random random;
    public static int MAX_OPEN_SOCKETS = 40;
    public static int MAX_OPEN_SOURCE_ROUTES = 20;
    public static int SOCKET_BUFFER_SIZE = 32768;
    public static int PING_DELAY = 2500;
    public static int PING_JITTER = 1000;
    public static int NUM_PING_TRIES = 3;
    public static int BOOTSTRAP_PORT = 1;
    protected static byte[] HEADER_DIRECT = new byte[]{6, 27, 73, 116};
    protected static byte[] HEADER_SOURCE_ROUTE = new byte[]{25, 83, 19, 0};
    public static int HEADER_SIZE = HEADER_DIRECT.length;

    public SocketCollectionManager(PastryNode node, SocketNodeHandlePool pool, SocketSourceRouteManager manager, EpochInetSocketAddress bindAddress, EpochInetSocketAddress proxyAddress) {
        this.pastryNode = node;
        this.manager = manager;
        this.localAddress = proxyAddress;
        this.pingManager = new PingManager(pool, manager, node, bindAddress, proxyAddress);
        this.socketQueue = new LinkedList();
        this.sockets = new Hashtable();
        this.sourceRouteQueue = new LinkedList();
        this.resigned = false;
        this.random = new Random();
        try {
            final ServerSocketChannel channel = ServerSocketChannel.open();
            channel.configureBlocking(false);
            channel.socket().bind(bindAddress.getAddress());
            final SocketCollectionManager handler = this;
            SelectorManager.getSelectorManager().invoke(new Runnable(){

                public void run() {
                    try {
                        SocketCollectionManager.this.key = SelectorManager.getSelectorManager().register(channel, handler, 16);
                    }
                    catch (IOException e) {
                        System.out.println("ERROR creating server socket key " + e);
                    }
                }
            });
        }
        catch (IOException e) {
            System.out.println("ERROR creating server socket channel " + e);
            e.printStackTrace();
        }
    }

    public boolean isOpen(SourceRoute route) {
        return this.sockets.containsKey(route);
    }

    public int getNumSourceRoutes() {
        return this.sourceRouteQueue.size();
    }

    public int getNumSockets() {
        return this.socketQueue.size();
    }

    public PingManager getPingManager() {
        return this.pingManager;
    }

    public void ping(SourceRoute route) {
        this.pingManager.ping(route, null);
    }

    public void checkLiveness(SourceRoute route) {
        if (!this.sockets.containsKey(route)) {
            this.checkDead(route);
        }
    }

    public int proximity(SourceRoute path) {
        return this.pingManager.proximity(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(SourceRoute path, Message message) {
        Hashtable hashtable = this.sockets;
        synchronized (hashtable) {
            if (!this.sockets.containsKey(path)) {
                this.debug("No connection open to path " + path + " - opening one");
                this.openSocket(path, false);
            }
            if (this.sockets.containsKey(path)) {
                this.debug("Found connection open to path " + path + " - sending now");
                ((SocketManager)this.sockets.get(path)).send(message);
                this.socketUpdated(path);
            } else {
                this.debug("ERROR: Could not connection to remote address " + path + " rerouting message " + message);
                this.manager.reroute(path.getLastHop(), message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrap(SourceRoute path, Message message) {
        Hashtable hashtable = this.sockets;
        synchronized (hashtable) {
            this.openSocket(path, true);
            ((SocketManager)this.sockets.get(path)).send(message);
        }
    }

    protected void markDead(EpochInetSocketAddress address) {
        this.manager.markDead(address);
    }

    public void accept(SelectionKey key) {
        try {
            new SocketAccepter(key);
        }
        catch (IOException e) {
            System.out.println("ERROR (accepting connection): " + e);
        }
    }

    protected void checkDead(SourceRoute path) {
        if (!this.resigned) {
            DeadChecker checker = new DeadChecker(path, NUM_PING_TRIES);
            ((SocketPastryNode)this.pastryNode).getTimer().scheduleAtFixedRate(checker, PING_DELAY + this.random.nextInt(PING_JITTER), PING_DELAY + this.random.nextInt(PING_JITTER));
            this.pingManager.forcePing(path, checker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openSocket(SourceRoute path, boolean bootstrap) {
        try {
            Hashtable hashtable = this.sockets;
            synchronized (hashtable) {
                if (!this.sockets.containsKey(path)) {
                    this.socketOpened(path, new SocketManager(path, bootstrap));
                } else {
                    this.debug("SERIOUS ERROR: Request to open socket to already-open socket to path " + path);
                }
            }
        }
        catch (IOException e) {
            System.out.println("GOT ERROR " + e + " OPENING PATH - MARKING PATH " + path + " AS DEAD!");
            e.printStackTrace();
            this.closeSocket(path);
            this.manager.markDead(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeSocket(SourceRoute path) {
        Hashtable hashtable = this.sockets;
        synchronized (hashtable) {
            if (this.sockets.containsKey(path)) {
                ((SocketManager)this.sockets.get(path)).shutdown();
            } else {
                this.debug("SERIOUS ERROR: Request to close socket to non-open handle to path " + path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void socketOpened(SourceRoute path, SocketManager manager) {
        Hashtable hashtable = this.sockets;
        synchronized (hashtable) {
            if (!this.sockets.containsKey(path)) {
                this.sockets.put(path, manager);
                this.socketQueue.addFirst(path);
                this.debug("Recorded opening of socket to path " + path);
                if (this.sockets.size() > MAX_OPEN_SOCKETS) {
                    SourceRoute toClose = (SourceRoute)this.socketQueue.removeLast();
                    this.debug("Too many sockets open - closing socket to path " + toClose);
                    this.closeSocket(toClose);
                }
            } else {
                this.debug("ERROR: Request to record path opening for already-open path " + path);
                String local = "" + this.localAddress.getAddress().getAddress().getHostAddress() + this.localAddress.getAddress().getPort();
                String remote = "" + path.getLastHop().getAddress().getAddress().getHostAddress() + path.getLastHop().getAddress().getPort();
                this.debug("RESOLVE: Comparing paths " + local + " and " + remote);
                if (remote.compareTo(local) < 0) {
                    this.debug("RESOLVE: Cancelling existing connection to " + path);
                    SocketManager toClose = (SocketManager)this.sockets.get(path);
                    this.socketClosed(path, toClose);
                    this.socketOpened(path, manager);
                    toClose.close();
                } else {
                    this.debug("RESOLVE: Implicitly cancelling new connection to path " + path);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void socketClosed(SourceRoute path, SocketManager manager) {
        Hashtable hashtable = this.sockets;
        synchronized (hashtable) {
            if (this.sockets.containsKey(path)) {
                if (this.sockets.get(path) == manager) {
                    this.debug("Recorded closing of socket to " + path);
                    this.socketQueue.remove(path);
                    this.sockets.remove(path);
                } else {
                    this.debug("SocketClosed called with corrent address, but incorrect manager - not a big deal.");
                }
            } else {
                this.debug("SEROUS ERROR: Request to record socket closing for non-existant socket to path " + path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void socketUpdated(SourceRoute path) {
        Hashtable hashtable = this.sockets;
        synchronized (hashtable) {
            if (this.sockets.containsKey(path)) {
                this.socketQueue.remove(path);
                this.socketQueue.addFirst(path);
            } else {
                this.debug("SERIOUS ERROR: Request to record update for non-existant socket to " + path);
            }
        }
    }

    protected void sourceRouteOpened(SourceRouteManager manager) {
        if (!this.sourceRouteQueue.contains(manager)) {
            this.sourceRouteQueue.addFirst(manager);
            this.debug("Recorded opening of source route manager " + manager);
            if (this.sourceRouteQueue.size() > MAX_OPEN_SOURCE_ROUTES) {
                SourceRouteManager toClose = (SourceRouteManager)this.sourceRouteQueue.removeLast();
                this.debug("Too many source routes open - closing source route manager " + toClose);
                toClose.close();
                this.sourceRouteClosed(toClose);
            }
        } else {
            this.debug("ERROR: Request to record source route opening for already-open manager " + manager);
            this.sourceRouteUpdated(manager);
        }
    }

    protected void sourceRouteClosed(SourceRouteManager manager) {
        if (this.sourceRouteQueue.contains(manager)) {
            this.sourceRouteQueue.remove(manager);
            this.debug("Recorded closing of source route manager " + manager);
        } else {
            this.debug("ERROR: Request to record source route closing for unknown manager " + manager);
        }
    }

    protected void sourceRouteUpdated(SourceRouteManager manager) {
        if (this.sourceRouteQueue.contains(manager)) {
            this.sourceRouteQueue.remove(manager);
            this.sourceRouteQueue.addFirst(manager);
        } else {
            this.debug("SERIOUS ERROR: Request to record update for unknown source route " + manager);
        }
    }

    private void debug(String s) {
        if (Log.ifp(8)) {
            System.out.println(this.pastryNode.getNodeId() + " (SCM): " + s);
        }
    }

    public void resign() throws IOException {
        this.resigned = true;
        this.pingManager.resign();
        while (this.socketQueue.size() > 0) {
            ((SocketManager)this.sockets.get(this.socketQueue.getFirst())).close();
        }
        while (this.sourceRouteQueue.size() > 0) {
            ((SourceRouteManager)this.sourceRouteQueue.getFirst()).close();
        }
        this.key.channel().close();
        this.key.cancel();
    }

    protected class SocketAccepter
    extends SelectionKeyHandler {
        private SelectionKey key;
        private ByteBuffer buffer = ByteBuffer.allocateDirect(HEADER_SIZE);

        public SocketAccepter(SelectionKey key) throws IOException {
            this.acceptConnection(key);
        }

        public void close() {
            try {
                if (this.key != null) {
                    this.key.channel().close();
                    this.key.cancel();
                    this.key.attach(null);
                    this.key = null;
                }
            }
            catch (IOException e) {
                System.out.println("ERROR: Recevied exception " + e + " while closing just accepted socket!");
            }
        }

        public void read(SelectionKey key) {
            try {
                int read = ((SocketChannel)key.channel()).read(this.buffer);
                this.debug("Read " + read + " bytes from newly accepted connection.");
                if (read == -1) {
                    throw new IOException("Error on read - the channel has been closed.");
                }
                if (this.buffer.remaining() == 0) {
                    this.processBuffer();
                }
            }
            catch (IOException e) {
                this.debug("ERROR " + e + " reading source route - cancelling.");
                this.close();
            }
        }

        protected void acceptConnection(SelectionKey serverKey) throws IOException {
            SocketChannel channel = ((ServerSocketChannel)serverKey.channel()).accept();
            channel.socket().setSendBufferSize(SOCKET_BUFFER_SIZE);
            channel.socket().setReceiveBufferSize(SOCKET_BUFFER_SIZE);
            channel.configureBlocking(false);
            this.debug("Accepted incoming connection from " + channel.socket().getRemoteSocketAddress());
            this.key = SelectorManager.getSelectorManager().register(channel, this, 1);
        }

        private void processBuffer() throws IOException {
            this.buffer.flip();
            byte[] array = new byte[HEADER_SIZE];
            this.buffer.get(array, 0, HEADER_SIZE);
            if (Arrays.equals(array, HEADER_DIRECT)) {
                new SocketManager(this.key);
            } else if (Arrays.equals(array, HEADER_SOURCE_ROUTE)) {
                new SourceRouteManager(this.key);
            } else {
                System.out.println("ERROR: Improperly formatted header received accepted connection - ignoring.");
                System.out.println("READ " + array[0] + " " + array[1] + " " + array[2] + " " + array[3]);
                throw new IOException("Improperly formatted header received - unknown header.");
            }
        }

        private void debug(String s) {
            if (Log.ifp(8)) {
                System.out.println(SocketCollectionManager.this.pastryNode.getNodeId() + " (SA): " + s);
            }
        }
    }

    protected class SourceRouteManager
    extends SelectionKeyHandler {
        private SocketChannel channel1;
        private SocketChannel channel2;
        private SocketChannelRepeater repeater;

        public SourceRouteManager(SelectionKey key) throws IOException {
            this.repeater = new SocketChannelRepeater(SocketCollectionManager.this.pastryNode, this);
            SocketCollectionManager.this.sourceRouteOpened(this);
            this.acceptConnection(key);
        }

        private SocketChannel otherChannel(SelectableChannel channel) {
            return channel == this.channel1 ? this.channel2 : this.channel1;
        }

        protected void addInterestOp(SelectableChannel channel, int op) throws IOException {
            String k = channel == this.channel1 ? "1" : "2";
            this.debug(this + "   adding interest op " + op + " to key " + k);
            if (SelectorManager.getSelectorManager().getKey(channel) == null) {
                this.debug(this + "   key " + k + " is null - reregistering with ops " + op);
                SelectorManager.getSelectorManager().register(channel, this, op);
            } else {
                SelectorManager.getSelectorManager().register(channel, this, SelectorManager.getSelectorManager().getKey(channel).interestOps() | op);
                this.debug(this + "   interest ops for key " + k + " are now " + SelectorManager.getSelectorManager().getKey(channel).interestOps());
            }
        }

        protected void removeInterestOp(SelectableChannel channel, int op) throws IOException {
            String k = channel == this.channel1 ? "1" : "2";
            this.debug(this + "   removing interest op " + op + " from key " + k);
            SelectionKey key = SelectorManager.getSelectorManager().getKey(channel);
            if (key != null) {
                key.interestOps(key.interestOps() & ~op);
                if (key.interestOps() == 0) {
                    this.debug(this + "   key " + k + " has no interest ops - cancelling");
                    SelectorManager.getSelectorManager().cancel(key);
                }
            }
        }

        public void shutdown(SocketChannel channel) {
            try {
                this.debug(this + " shutting down output to key " + (channel == this.channel1 ? "1" : "2"));
                channel.socket().shutdownOutput();
                SocketCollectionManager.this.sourceRouteClosed(this);
            }
            catch (IOException e) {
                System.err.println("ERROR: Received exception " + e + " while shutting down SR output.");
                this.close();
            }
        }

        public void close() {
            this.debug(this + " closing source route");
            try {
                SelectionKey key;
                if (this.channel1 != null) {
                    key = SelectorManager.getSelectorManager().getKey(this.channel1);
                    if (key != null) {
                        key.cancel();
                    }
                    this.channel1.close();
                    this.channel1 = null;
                }
                if (this.channel2 != null) {
                    key = SelectorManager.getSelectorManager().getKey(this.channel2);
                    if (key != null) {
                        key.cancel();
                    }
                    this.channel2.close();
                    this.channel2 = null;
                }
                SocketCollectionManager.this.sourceRouteClosed(this);
            }
            catch (IOException e) {
                System.out.println("ERROR: Recevied exception " + e + " while closing intermediateSourceRoute!");
            }
        }

        public void connect(SelectionKey key) {
            this.debug(this + " connecting to key " + (key.channel() == this.channel1 ? "1" : "2"));
            try {
                if (((SocketChannel)key.channel()).finishConnect()) {
                    this.removeInterestOp(key.channel(), 8);
                }
                this.debug("Found connectable source route channel - completed connection");
            }
            catch (IOException e) {
                System.out.println("Got exception " + e + " on connect - killing off source route");
                this.close();
            }
        }

        public void read(SelectionKey key) {
            block6: {
                String k = key.channel() == this.channel1 ? "1" : "2";
                this.debug(this + " reading from key " + k + " " + key.interestOps());
                try {
                    try {
                        if (this.repeater.read((SocketChannel)key.channel())) {
                            this.addInterestOp(this.otherChannel(key.channel()), 4);
                            this.removeInterestOp(key.channel(), 1);
                        }
                        this.debug(this + " done reading from key " + k);
                    }
                    catch (ClosedChannelException e) {
                        this.debug(this + " reading from key " + k + " returned -1 - processing shutdown");
                        if (this.otherChannel(key.channel()).socket().isInputShutdown()) {
                            this.debug(this + " other key is shut down - closing");
                            this.close();
                            break block6;
                        }
                        ((SocketChannel)key.channel()).socket().shutdownInput();
                        this.removeInterestOp(key.channel(), 1);
                        this.removeInterestOp(this.otherChannel(key.channel()), 4);
                        this.debug(this + " other key not yet closed - shutting it down");
                        this.shutdown(this.otherChannel(key.channel()));
                    }
                }
                catch (IOException e) {
                    System.out.println("SRM: ERROR " + e + " reading source route - cancelling.");
                    e.printStackTrace();
                    this.close();
                }
            }
        }

        public synchronized void write(SelectionKey key) {
            String k = key.channel() == this.channel1 ? "1" : "2";
            this.debug(this + " writing to key " + k + " " + key.interestOps());
            try {
                if (this.repeater.write((SocketChannel)key.channel())) {
                    this.addInterestOp(this.otherChannel(key.channel()), 1);
                    this.removeInterestOp(key.channel(), 4);
                }
                this.debug(this + " done writing to key " + k);
            }
            catch (IOException e) {
                System.out.println("ERROR " + e + " writing source route - cancelling.");
                this.close();
            }
        }

        protected void acceptConnection(SelectionKey key) throws IOException {
            this.debug(this + " accepted connection for key 1 as " + ((SocketChannel)key.channel()).socket().getRemoteSocketAddress());
            this.debug("Accepted source route connection from " + ((SocketChannel)key.channel()).socket().getRemoteSocketAddress());
            SelectorManager.getSelectorManager().register(key.channel(), this, 1);
            this.channel1 = (SocketChannel)key.channel();
        }

        protected void createConnection(EpochInetSocketAddress address) throws IOException {
            this.debug(this + " creating connection for key 2 as " + address.getAddress());
            this.channel2 = SocketChannel.open();
            this.channel2.socket().setSendBufferSize(SOCKET_BUFFER_SIZE);
            this.channel2.socket().setReceiveBufferSize(SOCKET_BUFFER_SIZE);
            this.channel2.configureBlocking(false);
            this.debug("Initiating source route connection to " + address);
            boolean done = this.channel2.connect(address.getAddress());
            if (done) {
                SelectorManager.getSelectorManager().register(this.channel2, this, 1);
            } else {
                SelectorManager.getSelectorManager().register(this.channel2, this, 9);
            }
            this.debug(this + "   setting initial ops to " + 1 + " for key 2");
        }

        private void debug(String s) {
            if (Log.ifp(5)) {
                System.out.println(SocketCollectionManager.this.pastryNode.getNodeId() + " (SRM): " + s);
            }
        }
    }

    private class SocketManager
    extends SelectionKeyHandler {
        private SelectionKey key;
        private SocketChannelReader reader;
        private SocketChannelWriter writer;
        private SourceRoute path;
        private boolean bootstrap;

        public SocketManager(SelectionKey key) throws IOException {
            this.reader = new SocketChannelReader(SocketCollectionManager.this.pastryNode, null);
            this.writer = new SocketChannelWriter(SocketCollectionManager.this.pastryNode, null);
            this.bootstrap = false;
            this.acceptConnection(key);
        }

        public SocketManager(SourceRoute path, boolean bootstrap) throws IOException {
            this.reader = new SocketChannelReader(SocketCollectionManager.this.pastryNode, path.reverse());
            this.writer = new SocketChannelWriter(SocketCollectionManager.this.pastryNode, path);
            this.bootstrap = bootstrap;
            this.createConnection(path);
            for (int i = 1; i < path.getNumHops(); ++i) {
                this.send(HEADER_SOURCE_ROUTE);
                this.send(SocketChannelRepeater.encodeHeader(path.getHop(i)));
            }
            this.send(HEADER_DIRECT);
            if (!bootstrap) {
                this.send(path.reverse(SocketCollectionManager.this.localAddress));
            }
        }

        public void shutdown() {
            try {
                if (this.key != null && this.key.channel() != null) {
                    ((SocketChannel)this.key.channel()).socket().shutdownOutput();
                }
                SocketCollectionManager.this.socketClosed(this.path, this);
                SelectorManager.getSelectorManager().modifyKey(this.key);
            }
            catch (IOException e) {
                System.err.println("ERROR: Received exception " + e + " while shutting down output.");
                this.close();
            }
        }

        public void close() {
            try {
                if (this.key != null) {
                    this.key.channel().close();
                    this.key.cancel();
                    this.key.attach(null);
                    this.key = null;
                }
                if (this.path != null) {
                    SocketCollectionManager.this.socketClosed(this.path, this);
                    Iterator i = this.writer.getQueue().iterator();
                    this.writer.reset();
                    while (i.hasNext()) {
                        Object o = i.next();
                        if (!(o instanceof Message) || SocketCollectionManager.this.manager == null) continue;
                        SocketCollectionManager.this.manager.reroute(this.path.getLastHop(), (Message)o);
                    }
                    this.path = null;
                }
            }
            catch (IOException e) {
                System.out.println("ERROR: Recevied exception " + e + " while closing socket!");
            }
        }

        public void send(Object message) {
            this.writer.enqueue(message);
            if (this.key != null) {
                SelectorManager.getSelectorManager().modifyKey(this.key);
            }
        }

        public synchronized void modifyKey(SelectionKey key) {
            if (((SocketChannel)key.channel()).socket().isOutputShutdown()) {
                key.interestOps(key.interestOps() & 0xFFFFFFFB);
            } else if (!this.writer.isEmpty() && (key.interestOps() & 4) == 0) {
                key.interestOps(key.interestOps() | 4);
            }
        }

        public void connect(SelectionKey key) {
            try {
                if (((SocketChannel)key.channel()).finishConnect()) {
                    key.interestOps(key.interestOps() & 0xFFFFFFF7);
                }
                SocketCollectionManager.this.manager.markAlive(this.path);
                this.debug("Found connectable channel - completed connection");
            }
            catch (Exception e) {
                this.debug("Got exception " + e + " on connect - marking as dead");
                System.out.println("Unable to connect to path " + this.path + " (" + e + ") marking as dead.");
                e.printStackTrace();
                SocketCollectionManager.this.manager.markDead(this.path);
                this.close();
            }
        }

        public void read(SelectionKey key) {
            try {
                Object o = this.reader.read((SocketChannel)key.channel());
                if (o != null) {
                    this.debug("Read message " + o + " from socket.");
                    if (o instanceof SourceRoute) {
                        if (this.path == null) {
                            this.path = (SourceRoute)o;
                            SocketCollectionManager.this.socketOpened(this.path, this);
                            SocketCollectionManager.this.manager.markAlive(this.path);
                            this.writer.setPath(this.path);
                            this.reader.setPath(this.path.reverse());
                        } else {
                            System.out.println("SERIOUS ERROR: Received duplicate path assignments: " + this.path + " and " + o);
                        }
                    } else {
                        this.receive((Message)o);
                    }
                }
            }
            catch (IOException e) {
                this.debug("ERROR " + e + " reading - cancelling.");
                if (this.path != null && this.path.getFirstHop().getAddress().getPort() != BOOTSTRAP_PORT && !((SocketChannel)key.channel()).socket().isOutputShutdown()) {
                    SocketCollectionManager.this.checkDead(this.path);
                }
                this.close();
            }
        }

        public synchronized void write(SelectionKey key) {
            try {
                if (this.writer.write((SocketChannel)key.channel())) {
                    key.interestOps(key.interestOps() & 0xFFFFFFFB);
                    if (this.bootstrap) {
                        this.close();
                    }
                }
            }
            catch (IOException e) {
                this.debug("ERROR " + e + " writing - cancelling.");
                this.close();
            }
        }

        protected void acceptConnection(SelectionKey key) throws IOException {
            this.debug("Accepted connection from " + ((SocketChannel)key.channel()).socket().getRemoteSocketAddress());
            this.key = SelectorManager.getSelectorManager().register(key.channel(), this, 1);
        }

        protected void createConnection(SourceRoute path) throws IOException {
            SocketChannel channel = SocketChannel.open();
            channel.socket().setSendBufferSize(SOCKET_BUFFER_SIZE);
            channel.socket().setReceiveBufferSize(SOCKET_BUFFER_SIZE);
            channel.configureBlocking(false);
            boolean done = channel.connect(path.getFirstHop().getAddress());
            this.path = path;
            this.debug("Initiating socket connection to path " + path);
            SocketManager handler = this;
            SelectorManager.getSelectorManager().invoke(new Runnable(this, done, channel, handler){
                private final /* synthetic */ boolean val$done;
                private final /* synthetic */ SocketChannel val$channel;
                private final /* synthetic */ SelectionKeyHandler val$handler;
                private final /* synthetic */ SocketManager this$1;
                {
                    this.this$1 = this$1;
                    this.val$done = val$done;
                    this.val$channel = val$channel;
                    this.val$handler = val$handler;
                }

                public void run() {
                    try {
                        if (this.val$done) {
                            SocketManager.access$502(this.this$1, SelectorManager.getSelectorManager().register(this.val$channel, this.val$handler, 1));
                        } else {
                            SocketManager.access$502(this.this$1, SelectorManager.getSelectorManager().register(this.val$channel, this.val$handler, 9));
                        }
                        SelectorManager.getSelectorManager().modifyKey(SocketManager.access$500(this.this$1));
                    }
                    catch (IOException e) {
                        System.out.println("ERROR creating server socket channel " + e);
                    }
                }
            });
        }

        protected void receive(Message message) {
            if (message instanceof NodeIdRequestMessage) {
                this.send(new NodeIdResponseMessage(SocketCollectionManager.this.pastryNode.getNodeId(), SocketCollectionManager.this.localAddress.getEpoch()));
            } else if (message instanceof LeafSetRequestMessage) {
                this.send(new LeafSetResponseMessage(SocketCollectionManager.this.pastryNode.getLeafSet()));
            } else if (message instanceof RoutesRequestMessage) {
                this.send(new RoutesResponseMessage(SocketCollectionManager.this.manager.getBest().values().toArray(new SourceRoute[0])));
            } else if (message instanceof RouteRowRequestMessage) {
                RouteRowRequestMessage rrMessage = (RouteRowRequestMessage)message;
                this.send(new RouteRowResponseMessage(SocketCollectionManager.this.pastryNode.getRoutingTable().getRow(rrMessage.getRow())));
            } else {
                long start = System.currentTimeMillis();
                SocketCollectionManager.this.pastryNode.receiveMessage(message);
            }
        }

        private void debug(String s) {
            if (Log.ifp(8)) {
                System.out.println(SocketCollectionManager.this.pastryNode.getNodeId() + " (SM " + SocketCollectionManager.this.pastryNode.getNodeId() + " -> " + this.path + "): " + s);
            }
        }

        static /* synthetic */ SelectionKey access$502(SocketManager x0, SelectionKey x1) {
            x0.key = x1;
            return x0.key;
        }

        static /* synthetic */ SelectionKey access$500(SocketManager x0) {
            return x0.key;
        }
    }

    protected class DeadChecker
    extends TimerTask
    implements PingResponseListener {
        protected int tries = 1;
        protected int numTries;
        protected SourceRoute path;

        public DeadChecker(SourceRoute path, int numTries) {
            this.path = path;
            this.numTries = numTries;
        }

        public void pingResponse(SourceRoute path, long RTT, long timeHeardFrom) {
            SocketCollectionManager.this.manager.markAlive(path);
            this.cancel();
        }

        public void run() {
            if (this.tries < this.numTries) {
                ++this.tries;
                if (SocketCollectionManager.this.manager.getLiveness(this.path.getLastHop()) == 1) {
                    SocketCollectionManager.this.manager.markSuspected(this.path);
                }
                SocketCollectionManager.this.pingManager.forcePing(this.path, this);
            } else {
                System.out.println("DeadChecker(" + this.path + ") expired - marking as dead.");
                SocketCollectionManager.this.manager.markDead(this.path);
                this.cancel();
            }
        }
    }
}

