/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket;

import java.util.Observable;
import rice.pastry.Log;
import rice.pastry.NodeId;
import rice.pastry.dist.DistNodeHandle;
import rice.pastry.messaging.Message;
import rice.pastry.socket.EpochInetSocketAddress;
import rice.pastry.socket.SocketNodeHandlePool;
import rice.pastry.socket.SocketPastryNode;

public class SocketNodeHandle
extends DistNodeHandle {
    protected EpochInetSocketAddress eaddress;
    static final long serialVersionUID = -5452528188786429274L;
    public static final int LIVENESS_DEAD_FOREVER = 4;
    public static int DEFAULT_PROXIMITY = Integer.MAX_VALUE;

    public SocketNodeHandle(EpochInetSocketAddress address, NodeId nodeId) {
        super(nodeId, address.getAddress());
        this.eaddress = address;
    }

    public EpochInetSocketAddress getEpochAddress() {
        return this.eaddress;
    }

    public int getLiveness() {
        SocketPastryNode spn = (SocketPastryNode)this.getLocalNode();
        if (spn == null) {
            return 1;
        }
        if (this.isLocal()) {
            return 1;
        }
        return spn.getSocketSourceRouteManager().getLiveness(this.getEpochAddress());
    }

    public boolean isLocal() {
        this.assertLocalNode();
        return this.getLocalNode().getNodeId().equals(this.nodeId);
    }

    public boolean checkLiveness() {
        SocketPastryNode spn = (SocketPastryNode)this.getLocalNode();
        if (spn != null) {
            spn.getSocketSourceRouteManager().checkLiveness(this.getEpochAddress());
        }
        return this.isAlive();
    }

    public void receiveMessage(Message msg) {
        this.assertLocalNode();
        SocketPastryNode spn = (SocketPastryNode)this.getLocalNode();
        if (spn.getNodeId().equals(this.nodeId)) {
            spn.receiveMessage(msg);
        } else {
            this.debug("Passing message " + msg + " to the socket controller for writing");
            spn.getSocketSourceRouteManager().send(this.getEpochAddress(), msg);
        }
    }

    public void bootstrap(Message msg) {
        ((SocketPastryNode)this.getLocalNode()).getSocketSourceRouteManager().bootstrap(this.getEpochAddress(), msg);
    }

    public String toString() {
        if (this.getLocalNode() == null) {
            return "[SNH: " + this.nodeId + "/" + this.getEpochAddress() + "]";
        }
        return "[SNH: " + this.getLocalNode().getNodeId() + " -> " + this.nodeId + "/" + this.getEpochAddress() + "]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SocketNodeHandle)) {
            return false;
        }
        SocketNodeHandle other = (SocketNodeHandle)obj;
        return other.getNodeId().equals(this.getNodeId()) && other.eaddress.equals(this.eaddress);
    }

    public int hashCode() {
        return this.getNodeId().hashCode() ^ this.eaddress.hashCode();
    }

    public int proximity() {
        SocketPastryNode spn = (SocketPastryNode)this.getLocalNode();
        if (spn == null) {
            return DEFAULT_PROXIMITY;
        }
        if (spn.getNodeId().equals(this.nodeId)) {
            return 0;
        }
        return spn.getSocketSourceRouteManager().proximity(this.getEpochAddress());
    }

    public boolean ping() {
        SocketPastryNode spn = (SocketPastryNode)this.getLocalNode();
        if (spn != null) {
            spn.getSocketSourceRouteManager().ping(this.getEpochAddress());
        }
        return this.isAlive();
    }

    public void afterSetLocalNode() {
        ((SocketNodeHandlePool)((SocketPastryNode)this.getLocalNode()).getNodeHandlePool()).record(this);
    }

    public void update(Observable o, Object obj) {
    }

    protected void update(Object update) {
        this.setChanged();
        this.notifyObservers(update);
    }

    private void debug(String s) {
        if (Log.ifp(8)) {
            System.out.println(this + ": " + s);
        }
    }
}

