/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket;

import java.lang.ref.WeakReference;
import java.util.Hashtable;
import java.util.Vector;
import rice.pastry.dist.DistNodeHandle;
import rice.pastry.dist.DistNodeHandlePool;
import rice.pastry.socket.EpochInetSocketAddress;
import rice.pastry.socket.SocketNodeHandle;
import rice.pastry.socket.SocketPastryNode;

public class SocketNodeHandlePool
extends DistNodeHandlePool {
    protected SocketPastryNode node;
    protected Hashtable handles;

    public SocketNodeHandlePool(SocketPastryNode node) {
        this.node = node;
        this.handles = new Hashtable();
    }

    public DistNodeHandle coalesce(DistNodeHandle handle) {
        return handle;
    }

    protected void record(SocketNodeHandle handle) {
        Vector<WeakReference<SocketNodeHandle>> vector = (Vector<WeakReference<SocketNodeHandle>>)this.handles.get(handle.getEpochAddress());
        if (vector == null) {
            vector = new Vector<WeakReference<SocketNodeHandle>>();
            this.handles.put(handle.getEpochAddress(), vector);
        }
        vector.addElement(new WeakReference<SocketNodeHandle>(handle));
    }

    protected void update(EpochInetSocketAddress address, Object update) {
        Vector vector = (Vector)this.handles.get(address);
        if (vector != null) {
            boolean printed = false;
            Object[] array = vector.toArray();
            for (int i = 0; i < array.length; ++i) {
                SocketNodeHandle handle = (SocketNodeHandle)((WeakReference)array[i]).get();
                if (handle != null) {
                    if (!printed) {
                        if (update == SocketNodeHandle.DECLARED_DEAD) {
                            System.out.println(this.node.getNodeId() + " found " + handle.getNodeId() + " to be dead.");
                        } else if (update == SocketNodeHandle.DECLARED_LIVE) {
                            System.out.println(this.node.getNodeId() + " found " + handle.getNodeId() + " to be alive again.");
                        }
                        printed = true;
                    }
                    handle.update(update);
                    continue;
                }
                vector.remove(array[i]);
            }
        }
    }
}

