/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.Random;
import rice.pastry.Log;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.NodeIdFactory;
import rice.pastry.PastryNode;
import rice.pastry.dist.DistPastryNodeFactory;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.MessageDispatch;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.RoutingTable;
import rice.pastry.socket.EpochInetSocketAddress;
import rice.pastry.socket.PingManager;
import rice.pastry.socket.SocketChannelReader;
import rice.pastry.socket.SocketChannelWriter;
import rice.pastry.socket.SocketCollectionManager;
import rice.pastry.socket.SocketNodeHandle;
import rice.pastry.socket.SocketNodeHandlePool;
import rice.pastry.socket.SocketPastryNode;
import rice.pastry.socket.SocketPastrySecurityManager;
import rice.pastry.socket.SocketSourceRouteManager;
import rice.pastry.socket.SourceRoute;
import rice.pastry.socket.messaging.IPAddressRequestMessage;
import rice.pastry.socket.messaging.IPAddressResponseMessage;
import rice.pastry.socket.messaging.LeafSetRequestMessage;
import rice.pastry.socket.messaging.LeafSetResponseMessage;
import rice.pastry.socket.messaging.NodeIdRequestMessage;
import rice.pastry.socket.messaging.NodeIdResponseMessage;
import rice.pastry.socket.messaging.RouteRowRequestMessage;
import rice.pastry.socket.messaging.RouteRowResponseMessage;
import rice.pastry.socket.messaging.RoutesRequestMessage;
import rice.pastry.socket.messaging.RoutesResponseMessage;
import rice.pastry.standard.PeriodicLeafSetProtocol;
import rice.pastry.standard.StandardJoinProtocol;
import rice.pastry.standard.StandardRouteSetProtocol;
import rice.pastry.standard.StandardRouter;

public class SocketPastryNodeFactory
extends DistPastryNodeFactory {
    private NodeIdFactory nidFactory;
    private int port;
    private Random random;
    private static final int rtMax = 1;
    private static final int lSetSize = 24;
    private static final int maxOpenSockets = 5;
    private static final int leafSetMaintFreq = 60;
    private static final int routeSetMaintFreq = 900;

    public SocketPastryNodeFactory(NodeIdFactory nf, int startPort) {
        this.nidFactory = nf;
        this.port = startPort;
        this.random = new Random();
    }

    public SourceRoute[] getRoutes(NodeHandle handle) throws IOException {
        SocketNodeHandle wHandle = (SocketNodeHandle)handle;
        RoutesResponseMessage lm = (RoutesResponseMessage)this.getResponse(wHandle.getAddress(), new RoutesRequestMessage());
        return lm.getRoutes();
    }

    public LeafSet getLeafSet(NodeHandle handle) throws IOException {
        SocketNodeHandle wHandle = (SocketNodeHandle)handle;
        LeafSetResponseMessage lm = (LeafSetResponseMessage)this.getResponse(wHandle.getAddress(), new LeafSetRequestMessage());
        return lm.getLeafSet();
    }

    public RouteSet[] getRouteRow(NodeHandle handle, int row) throws IOException {
        SocketNodeHandle wHandle = (SocketNodeHandle)handle;
        RouteRowResponseMessage rm = (RouteRowResponseMessage)this.getResponse(wHandle.getAddress(), new RouteRowRequestMessage(row));
        return rm.getRouteRow();
    }

    public int getProximity(NodeHandle local, NodeHandle handle) {
        SocketNodeHandle lHandle = (SocketNodeHandle)local;
        SocketNodeHandle wHandle = (SocketNodeHandle)handle;
        if (lHandle.getAddress().equals(wHandle.getAddress())) {
            return Integer.MAX_VALUE;
        }
        if (wHandle.proximity() == SocketNodeHandle.DEFAULT_PROXIMITY) {
            try {
                long startTime = System.currentTimeMillis();
                this.getResponse(wHandle.getAddress(), new NodeIdRequestMessage());
                long ping = System.currentTimeMillis() - startTime;
                return (int)ping;
            }
            catch (IOException e) {
                System.out.println("Error pinging address " + wHandle.getAddress() + ": " + e);
                return SocketNodeHandle.DEFAULT_PROXIMITY;
            }
        }
        return wHandle.proximity();
    }

    protected Message getResponse(InetSocketAddress address, Message message) throws IOException {
        SocketChannelWriter writer = new SocketChannelWriter(null, SourceRoute.build(new EpochInetSocketAddress(address, 0L)));
        SocketChannelReader reader = new SocketChannelReader(null, SourceRoute.build(new EpochInetSocketAddress(address, 0L)));
        SocketChannel channel = SocketChannel.open();
        channel.configureBlocking(true);
        channel.socket().connect(address, 20000);
        channel.socket().setSoTimeout(20000);
        writer.enqueue(SocketCollectionManager.HEADER_DIRECT);
        writer.enqueue(message);
        writer.write(channel);
        Object o = null;
        while (o == null) {
            o = reader.read(channel);
        }
        channel.socket().close();
        channel.close();
        return (Message)o;
    }

    private EpochInetSocketAddress getEpochAddress(int portNumber, long epoch) {
        EpochInetSocketAddress result = null;
        try {
            result = new EpochInetSocketAddress(new InetSocketAddress(InetAddress.getLocalHost(), portNumber), epoch);
            ServerSocket test = new ServerSocket();
            try {
                test.bind(result.getAddress());
            }
            catch (SocketException e) {
                Socket temp = new Socket("yahoo.com", 80);
                result = new EpochInetSocketAddress(new InetSocketAddress(temp.getLocalAddress(), portNumber), epoch);
                temp.close();
                System.out.println("Error binding to original IP, using " + result);
            }
            test.close();
            return result;
        }
        catch (UnknownHostException e) {
            System.out.println("PANIC: Unknown host in getAddress. " + e);
        }
        catch (IOException e) {
            System.out.println("PANIC: IOException in getAddress. " + e);
        }
        return result;
    }

    public NodeHandle generateNodeHandle(InetSocketAddress address) {
        try {
            NodeIdResponseMessage rm = (NodeIdResponseMessage)this.getResponse(address, new NodeIdRequestMessage());
            return new SocketNodeHandle(new EpochInetSocketAddress(address, rm.getEpoch()), rm.getNodeId());
        }
        catch (IOException e) {
            System.out.println("Error connecting to address " + address + ": " + e);
            System.out.println("Couldn't find a bootstrap node, starting a new ring...");
            return null;
        }
    }

    public PastryNode newNode(NodeHandle bootstrap) {
        return this.newNode(bootstrap, this.nidFactory.generateNodeId());
    }

    public PastryNode newNode(NodeHandle bootstrap, NodeId nodeId) {
        return this.newNode(bootstrap, nodeId, null);
    }

    public PastryNode newNode(NodeHandle bootstrap, InetSocketAddress proxy) {
        return this.newNode(bootstrap, this.nidFactory.generateNodeId(), proxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PastryNode newNode(NodeHandle bootstrap, NodeId nodeId, InetSocketAddress pAddress) {
        SocketPastryNode pn = new SocketPastryNode(nodeId);
        SocketSourceRouteManager srManager = null;
        SocketNodeHandlePool pool = new SocketNodeHandlePool(pn);
        EpochInetSocketAddress localAddress = null;
        EpochInetSocketAddress proxyAddress = null;
        long epoch = this.random.nextLong();
        SocketPastryNodeFactory socketPastryNodeFactory = this;
        synchronized (socketPastryNodeFactory) {
            localAddress = this.getEpochAddress(this.port, epoch);
            proxyAddress = pAddress == null ? localAddress : new EpochInetSocketAddress(pAddress, epoch);
            srManager = new SocketSourceRouteManager(pn, pool, localAddress, proxyAddress);
            ++this.port;
        }
        SocketNodeHandle localhandle = new SocketNodeHandle(proxyAddress, nodeId);
        SocketPastrySecurityManager secureMan = new SocketPastrySecurityManager(localhandle, pool);
        MessageDispatch msgDisp = new MessageDispatch();
        RoutingTable routeTable = new RoutingTable(localhandle, 1);
        LeafSet leafSet = new LeafSet(localhandle, 24);
        StandardRouter router = new StandardRouter(localhandle, routeTable, leafSet, secureMan);
        PeriodicLeafSetProtocol lsProtocol = new PeriodicLeafSetProtocol(pn, localhandle, secureMan, leafSet, routeTable);
        StandardRouteSetProtocol rsProtocol = new StandardRouteSetProtocol(localhandle, secureMan, routeTable);
        StandardJoinProtocol jProtocol = new StandardJoinProtocol(pn, localhandle, secureMan, routeTable, leafSet);
        msgDisp.registerReceiver(router.getAddress(), router);
        msgDisp.registerReceiver(lsProtocol.getAddress(), lsProtocol);
        msgDisp.registerReceiver(rsProtocol.getAddress(), rsProtocol);
        msgDisp.registerReceiver(jProtocol.getAddress(), jProtocol);
        pn.setElements(localhandle, secureMan, msgDisp, leafSet, routeTable);
        pn.setSocketElements(proxyAddress, srManager, pool, 60, 900);
        secureMan.setLocalPastryNode(pn);
        pool.coalesce(localhandle);
        localhandle.setLocalNode(pn);
        if (bootstrap != null) {
            bootstrap.setLocalNode(pn);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        pn.doneNode(this.getNearest(localhandle, bootstrap));
        return pn;
    }

    private void debug(String s) {
        if (Log.ifp(8)) {
            System.out.println(" (F): " + s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InetSocketAddress verifyConnection(int timeout, InetSocketAddress local, InetSocketAddress[] existing) throws IOException {
        System.err.println("Verifying connection of local node " + local + " using " + existing[0] + " and " + existing.length + " more");
        DatagramSocket socket = null;
        try {
            socket = new DatagramSocket(local);
            socket.setSoTimeout(timeout);
            for (int i = 0; i < existing.length; ++i) {
                byte[] buf = PingManager.addHeader(SourceRoute.build(new EpochInetSocketAddress(existing[i])), new IPAddressRequestMessage(), new EpochInetSocketAddress(local));
                DatagramPacket send = new DatagramPacket(buf, buf.length, existing[i]);
                socket.send(send);
            }
            DatagramPacket receive = new DatagramPacket(new byte[10000], 10000);
            socket.receive(receive);
            byte[] data = new byte[receive.getLength() - 38];
            System.arraycopy(receive.getData(), 38, data, 0, data.length);
            InetSocketAddress inetSocketAddress = ((IPAddressResponseMessage)PingManager.deserialize(data)).getAddress();
            return inetSocketAddress;
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }
}

