/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import rice.pastry.Log;
import rice.pastry.NodeSet;
import rice.pastry.PastryNode;
import rice.pastry.messaging.Message;
import rice.pastry.routing.RouteMessage;
import rice.pastry.socket.EpochInetSocketAddress;
import rice.pastry.socket.SocketCollectionManager;
import rice.pastry.socket.SocketNodeHandle;
import rice.pastry.socket.SocketNodeHandlePool;
import rice.pastry.socket.SourceRoute;

public class SocketSourceRouteManager {
    private PastryNode spn;
    private Hashtable managers;
    private SocketCollectionManager manager;
    private SocketNodeHandlePool pool;
    private EpochInetSocketAddress localAddress;

    protected SocketSourceRouteManager(PastryNode node, SocketNodeHandlePool pool, EpochInetSocketAddress bindAddress, EpochInetSocketAddress proxyAddress) {
        this.spn = node;
        this.pool = pool;
        this.managers = new Hashtable();
        this.manager = new SocketCollectionManager(node, pool, this, bindAddress, proxyAddress);
        this.localAddress = bindAddress;
    }

    public HashMap getBest() {
        HashMap result = new HashMap();
        Iterator i = this.managers.keySet().iterator();
        while (i.hasNext()) {
            Object addr = i.next();
            if (((AddressManager)this.managers.get(addr)).getLiveness() >= 3) continue;
            result.put(addr, ((AddressManager)this.managers.get(addr)).best);
        }
        return result;
    }

    public SocketCollectionManager getManager() {
        return this.manager;
    }

    protected AddressManager getAddressManager(EpochInetSocketAddress address, boolean search) {
        AddressManager manager = (AddressManager)this.managers.get(address);
        if (manager == null) {
            manager = new AddressManager(address, search);
            this.managers.put(address, manager);
        }
        return manager;
    }

    public int getLiveness(EpochInetSocketAddress address) {
        return this.getAddressManager(address, true).getLiveness();
    }

    protected SourceRoute[] getAllRoutes(EpochInetSocketAddress destination) {
        NodeSet nodes = this.spn.getLeafSet().neighborSet(Integer.MAX_VALUE);
        nodes.randomize();
        Vector<SourceRoute> result = new Vector<SourceRoute>();
        result.add(SourceRoute.build(destination));
        for (int i = 0; i < nodes.size(); ++i) {
            SocketNodeHandle handle = (SocketNodeHandle)nodes.get(i);
            if (handle.isLocal() || handle.getEpochAddress().equals(destination) || this.getBestRoute(handle.getEpochAddress()) == null) continue;
            result.add(this.getBestRoute(handle.getEpochAddress()).append(destination));
        }
        return result.toArray(new SourceRoute[0]);
    }

    protected SourceRoute getBestRoute(EpochInetSocketAddress address) {
        AddressManager am = (AddressManager)this.managers.get(address);
        if (am == null || am.getLiveness() == 3 || am.getLiveness() == 4) {
            return null;
        }
        return am.best;
    }

    public void resign() throws IOException {
        this.manager.resign();
    }

    public void bootstrap(EpochInetSocketAddress address, Message message) {
        this.manager.bootstrap(SourceRoute.build(address), message);
    }

    public void send(EpochInetSocketAddress address, Message message) {
        this.getAddressManager(address, true).send(message);
    }

    public void ping(EpochInetSocketAddress address) {
        AddressManager am = (AddressManager)this.managers.get(address);
        if (am == null) {
            this.manager.ping(SourceRoute.build(address));
        } else {
            am.ping();
        }
    }

    public void checkLiveness(EpochInetSocketAddress address) {
        this.getAddressManager(address, true).checkLiveness();
    }

    public int proximity(EpochInetSocketAddress address) {
        AddressManager am = (AddressManager)this.managers.get(address);
        if (am == null) {
            return SocketNodeHandle.DEFAULT_PROXIMITY;
        }
        return am.proximity();
    }

    protected void markDead(SourceRoute route) {
        this.debug("Found route " + route + " to be dead");
        AddressManager am = (AddressManager)this.managers.get(route.getLastHop());
        if (am != null) {
            am.markDead(route);
        }
    }

    protected void markDead(EpochInetSocketAddress address) {
        AddressManager am = (AddressManager)this.managers.get(address);
        if (am != null) {
            am.markDeadForever();
        }
    }

    protected void markAlive(SourceRoute route) {
        this.debug("Found route " + route + " to be alive");
        this.getAddressManager(route.getLastHop(), false).markAlive(route);
    }

    protected void markSuspected(SourceRoute route) {
        this.debug("Found route " + route + " to be suspected");
        this.getAddressManager(route.getLastHop(), false).markSuspected(route);
    }

    protected synchronized void markProximity(SourceRoute route, int proximity) {
        this.getAddressManager(route.getLastHop(), false).markProximity(route, proximity);
    }

    protected void reroute(EpochInetSocketAddress address, Message m) {
        if (this.getLiveness(address) == 1) {
            this.debug("Attempting to resend message " + m + " to alive address " + address);
            this.send(address, m);
        } else if (m instanceof RouteMessage) {
            if (((RouteMessage)m).getOptions().multipleHopsAllowed()) {
                this.debug("Attempting to reroute route message " + m);
                ((RouteMessage)m).nextHop = null;
                this.spn.receiveMessage(m);
            }
        } else {
            System.out.println("Dropping message " + m + " because next hop is dead!");
        }
    }

    private void debug(String s) {
        if (Log.ifp(8)) {
            System.out.println(this.spn.getNodeId() + " (SSRM): " + s);
        }
    }

    protected class AddressManager {
        protected EpochInetSocketAddress address;
        protected SourceRoute best;
        protected Vector queue;
        protected HashSet deadRoutes;
        protected HashSet pendingRoutes;
        protected int liveness;
        protected int proximity;

        public AddressManager(EpochInetSocketAddress address, boolean search) {
            this.address = address;
            this.queue = new Vector();
            this.pendingRoutes = new HashSet();
            this.deadRoutes = new HashSet();
            this.liveness = 2;
            this.proximity = SocketNodeHandle.DEFAULT_PROXIMITY;
            if (search) {
                this.checkRoute(SourceRoute.build(address));
            }
        }

        public int getLiveness() {
            return this.liveness;
        }

        protected void setAlive() {
            switch (this.liveness) {
                case 3: {
                    this.liveness = 1;
                    SocketSourceRouteManager.this.pool.update(this.address, SocketNodeHandle.DECLARED_LIVE);
                    break;
                }
                case 2: {
                    this.liveness = 1;
                    break;
                }
                case 4: {
                    System.out.println("ERROR: Found dead-forever handle to " + this.address + " to be alive again!");
                }
            }
            while (this.queue.size() > 0) {
                SocketSourceRouteManager.this.manager.send(this.best, (Message)this.queue.remove(0));
            }
        }

        protected void setSuspected() {
            switch (this.liveness) {
                case 1: {
                    this.liveness = 2;
                    break;
                }
                case 3: {
                    System.out.println("ERROR: Found node handle " + this.address + " to be suspected from dead - should not happen!");
                    break;
                }
                case 4: {
                    System.out.println("ERROR: Found node handle " + this.address + " to be suspected from dead forever - should never ever happen!");
                }
            }
            Object[] array = this.queue.toArray();
            for (int i = 0; i < array.length; ++i) {
                if (!(array[i] instanceof RouteMessage)) continue;
                System.out.println("REROUTE: Rerouting message " + array[i] + " due to suspected next hop " + this.address);
                SocketSourceRouteManager.this.reroute(this.address, (Message)array[i]);
                this.queue.remove(array[i]);
            }
        }

        protected void setDead() {
            switch (this.liveness) {
                case 3: {
                    return;
                }
                case 4: {
                    System.out.println("ERROR: Found node handle " + this.address + " to be dead from dead forever - should not happen!");
                    break;
                }
                default: {
                    this.best = null;
                    this.liveness = 3;
                    SocketSourceRouteManager.this.pool.update(this.address, SocketNodeHandle.DECLARED_DEAD);
                }
            }
            while (this.queue.size() > 0) {
                SocketSourceRouteManager.this.reroute(this.address, (Message)this.queue.remove(0));
            }
        }

        protected void setDeadForever() {
            switch (this.liveness) {
                case 4: {
                    return;
                }
                case 3: {
                    this.liveness = 4;
                    break;
                }
                default: {
                    this.best = null;
                    this.liveness = 4;
                    SocketSourceRouteManager.this.pool.update(this.address, SocketNodeHandle.DECLARED_DEAD);
                }
            }
        }

        protected synchronized void markAlive(SourceRoute route) {
            this.deadRoutes.remove(route);
            this.pendingRoutes.remove(route);
            if (this.best == null) {
                SocketSourceRouteManager.this.debug("No previous best route existed to " + this.address + " route " + route + " is now the best");
                this.best = route;
            }
            if (this.best.getNumHops() > route.getNumHops() || this.best.getNumHops() == route.getNumHops() && SocketSourceRouteManager.this.manager.proximity(this.best) > SocketSourceRouteManager.this.manager.proximity(route)) {
                SocketSourceRouteManager.this.debug("Route " + route + " is better than previous best route " + this.best + " - replacing");
                this.best = route;
            }
            this.setAlive();
        }

        protected synchronized void markSuspected(SourceRoute route) {
            if (this.best != null && this.best.equals(route)) {
                this.setSuspected();
            }
        }

        protected synchronized void markDead(SourceRoute route) {
            this.deadRoutes.add(route);
            this.pendingRoutes.remove(route);
            if (this.liveness == 3 || this.liveness == 4) {
                return;
            }
            if (this.best == null || route.equals(this.best)) {
                this.best = null;
                SourceRoute[] routes = SocketSourceRouteManager.this.getAllRoutes(route.getLastHop());
                boolean found = false;
                for (int i = 0; i < routes.length; ++i) {
                    if (this.deadRoutes.contains(routes[i])) continue;
                    found = true;
                    if (this.pendingRoutes.contains(routes[i])) continue;
                    this.checkRoute(routes[i]);
                }
                if (!found) {
                    this.setDead();
                }
            }
        }

        protected synchronized void markDeadForever() {
            System.out.println("MARKING ADDRESS " + this.address + " AS DEAD FOREVER!");
            this.best = null;
            this.setDeadForever();
        }

        protected synchronized void markProximity(SourceRoute route, int proximity) {
            if (this.proximity > proximity) {
                if (this.best == null) {
                    SocketSourceRouteManager.this.debug("No previous best route existed to " + this.address + " route " + route + " is now the best");
                    this.best = route;
                }
                this.proximity = proximity;
                SocketSourceRouteManager.this.pool.update(this.address, SocketNodeHandle.PROXIMITY_CHANGED);
                this.setAlive();
            }
        }

        public synchronized void send(Message message) {
            if (this.liveness == 3) {
                SocketSourceRouteManager.this.manager.checkDead(SourceRoute.build(this.address));
            }
            if (this.best == null) {
                this.queue.add(message);
                if (this.pendingRoutes.size() == 0) {
                    System.err.println("ERROR: Enqueueing message to " + this.address + " without any pending routes - very very bad!!!");
                }
            } else if (!SocketSourceRouteManager.this.manager.isOpen(this.best)) {
                this.queue.add(message);
                this.checkRoute(this.best);
                this.best = null;
            } else {
                SocketSourceRouteManager.this.manager.send(this.best, message);
            }
        }

        public void ping() {
            switch (this.liveness) {
                case 4: {
                    return;
                }
                case 3: {
                    System.out.println("PING: CHECKING DEAD ON DEAD ADDRESS " + this.address + " - JUST IN CASE, NO HARM ANYWAY");
                    SocketSourceRouteManager.this.manager.checkDead(SourceRoute.build(this.address));
                    break;
                }
                default: {
                    if (this.best == null) break;
                    SocketSourceRouteManager.this.manager.ping(this.best);
                    if (this.best.isDirect()) break;
                    SocketSourceRouteManager.this.manager.ping(SourceRoute.build(this.address));
                }
            }
        }

        public void checkLiveness() {
            switch (this.liveness) {
                case 4: {
                    return;
                }
                case 3: {
                    System.out.println("CHECKLIVENESS: CHECKING DEAD ON DEAD ADDRESS " + this.address + " - JUST IN CASE, NO HARM ANYWAY");
                    SocketSourceRouteManager.this.manager.checkDead(SourceRoute.build(this.address));
                    break;
                }
                default: {
                    if (this.best == null) break;
                    SocketSourceRouteManager.this.manager.checkLiveness(this.best);
                    if (this.best.isDirect()) break;
                    SocketSourceRouteManager.this.manager.ping(SourceRoute.build(this.address));
                }
            }
        }

        public int proximity() {
            return this.proximity;
        }

        protected synchronized void checkRoute(SourceRoute route) {
            if (!this.pendingRoutes.contains(route)) {
                this.pendingRoutes.add(route);
                SocketSourceRouteManager.this.manager.checkDead(route);
            }
        }
    }
}

