/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.standard;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.util.zip.GZIPInputStream;
import rice.p2p.util.SecurityUtils;
import rice.p2p.util.XMLObjectInputStream;
import rice.p2p.util.XMLObjectOutputStream;
import rice.pastry.NodeId;
import rice.pastry.NodeIdFactory;
import rice.pastry.standard.IPNodeIdFactory;
import rice.pastry.standard.RandomNodeIdFactory;

public class CertifiedNodeIdFactory
implements NodeIdFactory {
    protected int port;
    protected IPNodeIdFactory realFactory;
    public static String NODE_ID_FILENAME = "nodeId";

    public CertifiedNodeIdFactory(int port) {
        this.port = port;
        this.realFactory = new IPNodeIdFactory(port);
    }

    public NodeId generateNodeId() {
        XMLObjectInputStream xois;
        block12: {
            File g;
            xois = null;
            File f = new File(NODE_ID_FILENAME);
            if (!f.exists() && (g = new File("." + NODE_ID_FILENAME + "-" + this.port)).exists()) {
                g.renameTo(f);
            }
            if (!f.exists()) break block12;
            xois = new XMLObjectInputStream(new FileInputStream(f));
            NodeId nodeId = (NodeId)xois.readObject();
            Object var5_6 = null;
            try {
                if (xois != null) {
                    xois.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return nodeId;
        }
        try {
            try {
                System.err.println("Unable to find NodeID certificate - exiting.");
                throw new RuntimeException("Unable to find NodeID certificate - make sure that the NodeID certificate file '" + NODE_ID_FILENAME + "' exists in your ePOST directory.");
            }
            catch (IOException e) {
                System.err.println(e);
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                System.err.println(e);
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            try {
                if (xois != null) {
                    xois.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            throw throwable;
        }
    }

    public static String getArg(String[] args, String argType) {
        for (int i = 0; i < args.length; ++i) {
            String ret;
            if (!args[i].startsWith(argType) || args.length <= i + 1 || (ret = args[i + 1]).startsWith("-")) continue;
            return ret;
        }
        return null;
    }

    public static void generateCertificate(NodeId id, File file, PrivateKey key) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLObjectOutputStream xoos = new XMLObjectOutputStream(baos);
            xoos.writeObject(id);
            xoos.close();
            XMLObjectOutputStream xoos2 = new XMLObjectOutputStream(new FileOutputStream(file));
            xoos2.writeObject(id);
            xoos2.write(SecurityUtils.sign(baos.toByteArray(), key));
            xoos2.close();
        }
        catch (IOException e) {
            System.out.println(e);
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        String caDirectory = CertifiedNodeIdFactory.getArg(args, "-ca");
        String out = CertifiedNodeIdFactory.getArg(args, "-out");
        File f = new File(caDirectory, "ca.keypair.enc");
        FileInputStream fis = new FileInputStream(f);
        XMLObjectInputStream ois = new XMLObjectInputStream(new BufferedInputStream(new GZIPInputStream(fis)));
        byte[] cipher = (byte[])ois.readObject();
        File pwFile = new File(caDirectory, "pw");
        StreamTokenizer st = new StreamTokenizer(new BufferedReader(new InputStreamReader(new FileInputStream(pwFile))));
        st.nextToken();
        KeyPair caPair = (KeyPair)SecurityUtils.deserialize(SecurityUtils.decryptSymmetric(cipher, SecurityUtils.hash(st.sval.getBytes())));
        CertifiedNodeIdFactory.generateCertificate(new RandomNodeIdFactory().generateNodeId(), new File("/tmp/epost/" + out + "/" + NODE_ID_FILENAME), caPair.getPrivate());
    }
}

