/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.standard;

import java.util.Random;
import rice.pastry.NodeHandle;
import rice.pastry.NodeSet;
import rice.pastry.PastryNode;
import rice.pastry.leafset.BroadcastLeafSet;
import rice.pastry.leafset.InitiateLeafSetMaintenance;
import rice.pastry.leafset.LeafSet;
import rice.pastry.leafset.LeafSetProtocolAddress;
import rice.pastry.leafset.RequestLeafSet;
import rice.pastry.messaging.Address;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.MessageReceiver;
import rice.pastry.routing.RoutingTable;
import rice.pastry.security.PastrySecurityManager;

public class PeriodicLeafSetProtocol
implements MessageReceiver {
    protected NodeHandle localHandle;
    protected PastryNode localNode;
    protected PastrySecurityManager security;
    protected LeafSet leafSet;
    protected RoutingTable routeTable;
    protected Random random;
    private Address address;

    public PeriodicLeafSetProtocol(PastryNode ln, NodeHandle local, PastrySecurityManager sm, LeafSet ls, RoutingTable rt) {
        this.localNode = ln;
        this.localHandle = local;
        this.security = sm;
        this.leafSet = ls;
        this.routeTable = rt;
        this.random = new Random();
        this.address = new LeafSetProtocolAddress();
    }

    public Address getAddress() {
        return this.address;
    }

    public void receiveMessage(Message msg) {
        NodeSet set;
        if (msg instanceof BroadcastLeafSet) {
            BroadcastLeafSet bls = (BroadcastLeafSet)msg;
            if (bls.type() == 1) {
                this.leafSet.merge(bls.leafSet(), bls.from(), this.routeTable, this.security, false, null);
                this.localNode.setReady();
                this.broadcastAll();
            } else {
                int i;
                NodeSet set2 = this.leafSet.neighborSet(Integer.MAX_VALUE);
                for (i = 0; i < set2.size(); ++i) {
                    if (!bls.leafSet().test(set2.get(i))) continue;
                    set2.get(i).checkLiveness();
                }
                set2 = bls.leafSet().neighborSet(Integer.MAX_VALUE);
                for (i = 0; i < set2.size(); ++i) {
                    if (set2.get(i).isAlive()) continue;
                    set2.get(i).checkLiveness();
                }
                this.leafSet.merge(bls.leafSet(), bls.from(), this.routeTable, this.security, false, null);
            }
        } else if (msg instanceof RequestLeafSet) {
            RequestLeafSet rls = (RequestLeafSet)msg;
            rls.returnHandle().receiveMessage(new BroadcastLeafSet(this.localHandle, this.leafSet, 0));
        } else if (msg instanceof InitiateLeafSetMaintenance && (set = this.leafSet.neighborSet(Integer.MAX_VALUE)).size() > 1) {
            NodeHandle handle = set.get(this.random.nextInt(set.size() - 1) + 1);
            handle.receiveMessage(new RequestLeafSet(this.localHandle));
            handle.receiveMessage(new BroadcastLeafSet(this.localHandle, this.leafSet, 0));
            NodeHandle check = set.get(this.random.nextInt(set.size() - 1) + 1);
            check.checkLiveness();
        }
    }

    protected void broadcastAll() {
        BroadcastLeafSet bls = new BroadcastLeafSet(this.localHandle, this.leafSet, 2);
        NodeSet set = this.leafSet.neighborSet(Integer.MAX_VALUE);
        for (int i = 1; i < set.size(); ++i) {
            set.get(i).receiveMessage(bls);
        }
    }
}

