/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.standard;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import rice.pastry.NodeId;
import rice.pastry.NodeIdFactory;
import rice.pastry.PastrySeed;

public class RandomNodeIdFactory
implements NodeIdFactory {
    private Random rng = new Random(PastrySeed.getSeed());
    private long next = this.rng.nextLong();

    public NodeId generateNodeId() {
        byte[] raw = new byte[8];
        long tmp = ++this.next;
        for (int i = 0; i < 8; ++i) {
            raw[i] = (byte)(tmp & 0xFFL);
            tmp >>= 8;
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println("No SHA support!");
        }
        md.update(raw);
        byte[] digest = md.digest();
        NodeId nodeId = NodeId.buildNodeId(digest);
        return nodeId;
    }
}

