/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.standard;

import java.util.Observable;
import java.util.Observer;
import java.util.Random;
import rice.pastry.Log;
import rice.pastry.NodeHandle;
import rice.pastry.PastrySeed;
import rice.pastry.messaging.Address;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.MessageReceiver;
import rice.pastry.routing.BroadcastRouteRow;
import rice.pastry.routing.InitiateRouteSetMaintenance;
import rice.pastry.routing.RequestRouteRow;
import rice.pastry.routing.RouteProtocolAddress;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.RoutingTable;
import rice.pastry.security.PastrySecurityManager;

public class StandardRouteSetProtocol
implements Observer,
MessageReceiver {
    private NodeHandle localHandle;
    private PastrySecurityManager security;
    private RoutingTable routeTable;
    private Address address;
    private Random rng;
    private static final int maxTrials = (1 << RoutingTable.baseBitLength()) / 2;

    public StandardRouteSetProtocol(NodeHandle lh, PastrySecurityManager sm, RoutingTable rt) {
        this.localHandle = lh;
        this.security = sm;
        this.routeTable = rt;
        this.rng = new Random(PastrySeed.getSeed());
        this.address = new RouteProtocolAddress();
        rt.addObserver(this);
    }

    public Address getAddress() {
        return this.address;
    }

    public void update(Observable obs, Object arg) {
    }

    public void receiveMessage(Message msg) {
        if (msg instanceof BroadcastRouteRow) {
            BroadcastRouteRow brr = (BroadcastRouteRow)msg;
            RouteSet[] row = brr.getRow();
            NodeHandle nh = brr.from();
            if ((nh = this.security.verifyNodeHandle(nh)).isAlive()) {
                this.routeTable.put(nh);
            }
            for (int i = 0; i < row.length; ++i) {
                RouteSet rs = row[i];
                for (int j = 0; rs != null && j < rs.size(); ++j) {
                    nh = rs.get(j);
                    if (!(nh = this.security.verifyNodeHandle(nh)).isAlive()) continue;
                    this.routeTable.put(nh);
                }
            }
        } else if (msg instanceof RequestRouteRow) {
            RequestRouteRow rrr = (RequestRouteRow)msg;
            int reqRow = rrr.getRow();
            NodeHandle nh = rrr.returnHandle();
            nh = this.security.verifyNodeHandle(nh);
            RouteSet[] row = this.routeTable.getRow(reqRow);
            BroadcastRouteRow brr = new BroadcastRouteRow(this.localHandle, row);
            nh.receiveMessage(brr);
        } else if (msg instanceof InitiateRouteSetMaintenance) {
            this.maintainRouteSet();
        } else {
            throw new Error("StandardRouteSetProtocol: received message is of unknown type");
        }
    }

    private void maintainRouteSet() {
        if (Log.ifp(7)) {
            System.out.println("maintainRouteSet " + this.localHandle.getNodeId());
        }
        for (int i = this.routeTable.numRows() - 1; i >= 0; --i) {
            int j;
            RouteSet[] row = this.routeTable.getRow(i);
            BroadcastRouteRow brr = new BroadcastRouteRow(this.localHandle, row);
            RequestRouteRow rrr = new RequestRouteRow(this.localHandle, i);
            int myCol = this.localHandle.getNodeId().getDigit(i, RoutingTable.baseBitLength());
            for (j = 0; j < maxTrials; ++j) {
                NodeHandle nh;
                RouteSet rs;
                int col = this.rng.nextInt(this.routeTable.numColumns());
                if (col == myCol || (rs = row[col]) == null || (nh = rs.closestNode()) == null) continue;
                nh.receiveMessage(brr);
                nh.receiveMessage(rrr);
                break;
            }
            if (j == maxTrials) break;
        }
    }
}

