/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.standard;

import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Address;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.MessageReceiver;
import rice.pastry.routing.BroadcastRouteRow;
import rice.pastry.routing.RouteMessage;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.RouterAddress;
import rice.pastry.routing.RoutingTable;
import rice.pastry.security.PastrySecurityManager;

public class StandardRouter
implements MessageReceiver {
    private NodeId localId;
    private NodeHandle localHandle;
    private RoutingTable routeTable;
    private LeafSet leafSet;
    private PastrySecurityManager security;
    private Address routeAddress;

    public StandardRouter(NodeHandle handle, RoutingTable rt, LeafSet ls, PastrySecurityManager sm) {
        this.localHandle = handle;
        this.localId = handle.getNodeId();
        this.routeTable = rt;
        this.leafSet = ls;
        this.security = sm;
        this.routeAddress = new RouterAddress();
    }

    public Address getAddress() {
        return this.routeAddress;
    }

    public void receiveMessage(Message msg) {
        if (msg instanceof RouteMessage) {
            RouteMessage rm = (RouteMessage)msg;
            if (!rm.routeMessage(this.localHandle)) {
                this.receiveRouteMessage(rm);
            }
        } else {
            throw new Error("message " + msg + " bounced at StandardRouter");
        }
    }

    private void receiveRouteMessage(RouteMessage msg) {
        Id target = msg.getTarget();
        if (target == null) {
            target = this.localId;
        }
        int cwSize = this.leafSet.cwSize();
        int ccwSize = this.leafSet.ccwSize();
        int lsPos = this.leafSet.mostSimilar(target);
        if (lsPos == 0) {
            msg.nextHop = this.localHandle;
        } else if (lsPos > 0 && (lsPos < cwSize || !this.leafSet.get(lsPos).getNodeId().clockwise(target)) || lsPos < 0 && (-lsPos < ccwSize || this.leafSet.get(lsPos).getNodeId().clockwise(target))) {
            NodeHandle handle = this.leafSet.get(lsPos);
            if (!handle.isAlive()) {
                this.leafSet.remove(handle);
                this.receiveRouteMessage(msg);
                return;
            }
            msg.nextHop = handle;
            msg.getOptions().setRerouteIfSuspected(false);
        } else {
            RouteSet rs = this.routeTable.getBestEntry(target);
            NodeHandle handle = null;
            if (rs == null || (handle = rs.closestNode(1)) == null) {
                handle = this.routeTable.bestAlternateRoute(1, target);
                if (handle == null) {
                    handle = this.leafSet.get(lsPos);
                    if (!handle.isAlive()) {
                        this.leafSet.remove(handle);
                        this.receiveRouteMessage(msg);
                        return;
                    }
                    msg.getOptions().setRerouteIfSuspected(false);
                } else {
                    Id.Distance altDist = handle.getNodeId().distance(target);
                    Id.Distance lsDist = this.leafSet.get(lsPos).getNodeId().distance(target);
                    if (lsDist.compareTo(altDist) < 0) {
                        handle = this.leafSet.get(lsPos);
                        if (!handle.isAlive()) {
                            this.leafSet.remove(handle);
                            this.receiveRouteMessage(msg);
                            return;
                        }
                        msg.getOptions().setRerouteIfSuspected(false);
                    }
                }
            } else {
                this.checkForRouteTableHole(msg, handle);
            }
            msg.nextHop = handle;
        }
        msg.setPrevNode(this.localHandle);
        this.localHandle.receiveMessage(msg);
    }

    private void checkForRouteTableHole(RouteMessage msg, NodeHandle handle) {
        Id key;
        if (msg.getPrevNode() == null) {
            return;
        }
        NodeId prevId = msg.getPrevNode().getNodeId();
        int diffDigit = prevId.indexOfMSDD(key = msg.getTarget(), RoutingTable.baseBitLength());
        if (diffDigit == this.localId.indexOfMSDD(key, RoutingTable.baseBitLength())) {
            RouteSet[] row = this.routeTable.getRow(diffDigit);
            BroadcastRouteRow brr = new BroadcastRouteRow(this.localHandle, row);
            NodeHandle prevNode = this.security.verifyNodeHandle(msg.getPrevNode());
            if (prevNode.isAlive()) {
                prevNode.receiveMessage(brr);
            }
        }
    }
}

