/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Vector;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.direct.DirectNodeHandle;
import rice.pastry.direct.DirectPastryNodeFactory;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.direct.SphereNetwork;
import rice.pastry.standard.RandomNodeIdFactory;

public class ClosestRegrTest {
    private PastryNodeFactory factory;
    private NetworkSimulator simulator;
    private Vector pastryNodes;
    Random random = new Random();
    int incorrect = 0;
    double sum = 0.0;
    public static int NUM_NODES = 1000;
    public static int NUM_TRIALS = 1000;

    private ClosestRegrTest() {
        this.simulator = new SphereNetwork();
        this.factory = new DirectPastryNodeFactory(new RandomNodeIdFactory(), this.simulator);
        this.pastryNodes = new Vector();
    }

    protected NodeHandle getBootstrap() {
        NodeHandle bootstrap = null;
        try {
            PastryNode lastnode = (PastryNode)this.pastryNodes.lastElement();
            bootstrap = lastnode.getLocalHandle();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return bootstrap;
    }

    protected void run() {
        for (int i = 0; i < NUM_NODES; ++i) {
            PastryNode node = this.factory.newNode(this.getBootstrap());
            if (i > 0) {
                this.test(i, node.getLocalHandle());
            }
            while (this.simulator.simulate()) {
            }
            System.out.println("CREATED NODE " + i + " " + node.getNodeId());
            this.pastryNodes.add(node);
        }
    }

    protected void test(int i, NodeHandle handle) {
        NodeId nodeId = handle.getNodeId();
        PastryNode bootNode = (PastryNode)this.pastryNodes.elementAt(this.random.nextInt(i));
        NodeHandle bootstrap = bootNode.getLocalHandle();
        NodeHandle closest = this.factory.getNearest(handle, bootstrap);
        DirectNodeHandle realClosest = this.simulator.getClosest(nodeId);
        if (!closest.getNodeId().equals(((NodeHandle)realClosest).getNodeId())) {
            ++this.incorrect;
            this.sum += (double)(this.simulator.proximity(closest.getNodeId(), nodeId) / this.simulator.proximity(((NodeHandle)realClosest).getNodeId(), nodeId));
            System.out.println("ERROR: CLOSEST TO " + nodeId + " WAS " + closest.getNodeId() + " REAL CLOSEST: " + ((NodeHandle)realClosest).getNodeId());
            System.out.println("SO FAR: " + this.incorrect + "/" + i + " PERCENTAGE: " + this.sum / (double)this.incorrect);
        }
    }

    public static void main(String[] args) {
        ClosestRegrTest pt = new ClosestRegrTest();
        pt.run();
    }
}

