/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Vector;
import rice.pastry.Log;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.PastrySeed;
import rice.pastry.direct.DirectPastryNodeFactory;
import rice.pastry.direct.EuclideanNetwork;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.standard.RandomNodeIdFactory;
import rice.pastry.testing.HelloWorldApp;

public class HelloWorld {
    private PastryNodeFactory factory;
    private NetworkSimulator simulator = new EuclideanNetwork();
    private Vector pastryNodes;
    private Vector helloClients;
    private Random rng;
    private static int numnodes = 3;
    private static int nummsgs = 3;
    private static boolean simultaneous_joins = false;
    private static boolean simultaneous_msgs = false;

    public HelloWorld() {
        this.factory = new DirectPastryNodeFactory(new RandomNodeIdFactory(), this.simulator);
        this.pastryNodes = new Vector();
        this.helloClients = new Vector();
        this.rng = new Random(PastrySeed.getSeed());
    }

    private NodeHandle getBootstrap() {
        NodeHandle bootstrap = null;
        try {
            PastryNode lastnode = (PastryNode)this.pastryNodes.lastElement();
            bootstrap = lastnode.getLocalHandle();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return bootstrap;
    }

    public void makePastryNode() {
        PastryNode pn = this.factory.newNode(this.getBootstrap());
        this.pastryNodes.addElement(pn);
        HelloWorldApp app = new HelloWorldApp(pn);
        this.helloClients.addElement(app);
        if (Log.ifp(5)) {
            System.out.println("created " + pn);
        }
    }

    private void printLeafSets() {
        for (int i = 0; i < this.pastryNodes.size(); ++i) {
            PastryNode pn = (PastryNode)this.pastryNodes.get(i);
            if (!Log.ifp(5)) continue;
            System.out.println(pn.getLeafSet());
        }
    }

    private void sendRandomMessage() {
        int n = this.helloClients.size();
        int client = this.rng.nextInt(n);
        HelloWorldApp app = (HelloWorldApp)this.helloClients.get(client);
        app.sendRndMsg(this.rng);
    }

    private boolean simulate() {
        return this.simulator.simulate();
    }

    public static void main(String[] args) {
        int i;
        Log.init(args);
        for (int i2 = 0; i2 < args.length; ++i2) {
            if (args[i2].equals("-nodes") && i2 + 1 < args.length) {
                numnodes = Integer.parseInt(args[i2 + 1]);
            }
            if (args[i2].equals("-msgs") && i2 + 1 < args.length) {
                nummsgs = Integer.parseInt(args[i2 + 1]);
            }
            if (args[i2].equals("-simultaneous_joins")) {
                simultaneous_joins = true;
            }
            if (args[i2].equals("-simultaneous_msgs")) {
                simultaneous_msgs = true;
            }
            if (!args[i2].equals("-help")) continue;
            System.out.println("Usage: HelloWorld [-msgs m] [-nodes n] [-verbose|-silent|-verbosity v]");
            System.out.println("                  [-simultaneous_joins] [-simultaneous_msgs] [-help]");
            System.exit(1);
        }
        HelloWorld driver = new HelloWorld();
        for (i = 0; i < numnodes; ++i) {
            driver.makePastryNode();
            if (simultaneous_joins) continue;
            while (driver.simulate()) {
            }
        }
        if (simultaneous_joins) {
            if (Log.ifp(5)) {
                System.out.println("let the joins begin!");
            }
            while (driver.simulate()) {
            }
        }
        if (Log.ifp(5)) {
            System.out.println(numnodes + " nodes constructed");
        }
        driver.printLeafSets();
        for (i = 0; i < nummsgs; ++i) {
            driver.sendRandomMessage();
            if (simultaneous_msgs) continue;
            while (driver.simulate()) {
            }
        }
        if (simultaneous_msgs) {
            if (Log.ifp(5)) {
                System.out.println("let the msgs begin!");
            }
            while (driver.simulate()) {
            }
        }
    }
}

